#!/bin/bash

# No uninstall_*.sh needed.

export ARG0=$0

POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions

# Workaround for selinux problems on Fedora.
CHCON=$(which chcon)    2> /dev/null
if [ "${CHCON}" == "" -o ! -x "${CHCON}" ]; then
    if [ -x /usr/bin/chcon ]; then
        # This is first because this is where Fedora installs chcon.
        CHCON=/usr/bin/chcon
    fi

    if [ -x /usr/sbin/chcon ]; then
        CHCON=/usr/sbin/chcon
    fi

    if [ -x /sbin/chcon ]; then
        CHCON=/sbin/chcon
    fi

    if [ -x /bin/chcon ]; then
        CHCON=/bin/chcon
    fi
fi

if [ -x "${CHCON}" ]; then

    echo $"Setting selinux context..."

    pushd ..  > /dev/null

    # Some of these (eg. Oggs) are not needed anymore, but 
    # include them anyway just in case.
    eval_cmd ${CHCON} -t textrel_shlib_t \
        codecs/colorcvt.so               \
        codecs/drvc.so                   \
        codecs/drv2.so                   \
        codecs/raac.so                   \
        plugins/swfrender.so             \
        plugins/oggfformat.so            \
        plugins/vorbisrend.so            \
        plugins/theorarend.so            \
        2> /dev/null

    popd  > /dev/null

    # Not checking for success because chcon can be installed 
    # on a system/distribution but FS labeling disabled,
    # (when selinux is turned off.)
else
    echo $"chcon not found; not setting selinux context needed only for Fedora."
fi

popd > /dev/null

