#!/bin/bash

export ARG0=$0

if [ "$1" = "" -o "$1" = "install" ] ; then
    CMD=install
elif [ "$1" = "uninstall" ] ; then
    CMD=uninstall
else
    echo
    echo "Usage: install_icon_resource.sh [uninstall]"
    echo
    exit 1
fi

POSTINST_DIR=${ARG0%/*}  # Delete trailing file name.
POSTINST_DIR=$( cd $POSTINST_DIR; pwd )
export POSTINST_DIR
pushd $POSTINST_DIR  > /dev/null


. ./functions


echo ${CMD}ing application icons resource...
APP_ICON_NAME=${TARGET}.png
for SIZE in "16" "22" "24" "32" "36" "48" "64" "72" "96" "128" "192" ; do
    SOURCE_ICON="$INSTDIR/share/icons/${TARGET}_${SIZE}x${SIZE}.png"
    if [ -f "$SOURCE_ICON" ] ; then
        if [ "${CMD}" = "uninstall" ] ; then
            # Uninstall; no logging.
            xdg-icon-resource uninstall --novendor --noupdate --context apps --size $SIZE ${APP_ICON_NAME}
        else
            # Rename realplay_32x32.png to realplay.png before installing.
            ICON_TMPDIR=$(mktemp -d -t renamedIconDir.XXXXXXXX) && {
                cp ${SOURCE_ICON} ${ICON_TMPDIR}/${APP_ICON_NAME}
                eval_cmd xdg-icon-resource install --novendor --noupdate --context apps --size $SIZE ${ICON_TMPDIR}/${APP_ICON_NAME}
                # Clean up.
                rm -rf ${ICON_TMPDIR}
            }
        fi
    fi
done



echo ${CMD}ing document icons resource...
# TODO: To Add video/x-ms-asf

for SIZE in "16" "22" "24" "32" "36" "48" "64" "72" "96" "128" "192" ; do

    # First column: MIME Type.
    # Second column: Icon Name.
    # The first block lists all icons available.
    # Following it, all MIME Types are listed with icons mapping.
    for ROW in \
        "application-generic                  mime-application-generic" \
        "application-ogg                      mime-application-ogg"     \
        "application-ram                      mime-application-ram"     \
        "application-rm                       mime-application-rm"      \
        "application-smil                     mime-application-smil"    \
        "audio-aiff                           mime-audio-aiff"          \
        "audio-au                             mime-audio-au"            \
        "audio-generic                        mime-audio-generic"       \
        "audio-mp3                            mime-audio-mp3"           \
        "audio-mp4                            mime-audio-mp4"           \
        "audio-ogg                            mime-audio-ogg"           \
        "audio-ra                             mime-audio-ra"            \
        "audio-wav                            mime-audio-wav"           \
        "text-realtext                        mime-text-realtext"       \
        "video-avi                            mime-video-avi"           \
        "video-generic                        mime-video-generic"       \
        "video-mov                            mime-video-mov"           \
        "video-ogg                            mime-video-ogg"           \
        "video-rv                             mime-video-rv"            \
        "video-swf                            mime-video-swf"           \
        "application-x-ogg                    mime-application-ogg"        \
        "application-ogg                      mime-application-ogg"        \
        "audio-x-vorbis+ogg                   mime-application-ogg"        \
        "video-x-theora+ogg                   mime-application-ogg"        \
        "audio-mp3                            mime-audio-mp3"              \
        "audio-x-mp3                          mime-audio-mp3"              \
        "audio-m4a                            mime-audio-mp4"              \
        "audio-x-m4a                          mime-audio-mp4"              \
        "audio-mp4                            mime-audio-mp4"              \
        "audio-rn-mpeg                        mime-audio-mp4"              \
        "audio-mpeg                           mime-audio-mp4"              \
        "audio-mpg                            mime-audio-mp4"              \
        "audio-x-mpeg                         mime-audio-mp4"              \
        "audio-x-mpg                          mime-audio-mp4"              \
        "audio-mpegurl                        mime-audio-generic"          \
        "audio-x-mpegurl                      mime-audio-generic"          \
        "audio-scpls                          mime-audio-generic"          \
        "audio-x-scpls                        mime-audio-generic"          \
        "audio-wav                            mime-audio-wav"              \
        "audio-x-wav                          mime-audio-wav"              \
        "audio-x-pn-wav                       mime-audio-wav"              \
        "audio-x-pn-windows-acm               mime-audio-wav"              \
        "audio-x-pn-windows-pcm               mime-audio-wav"              \
        "text-vnd.rn-realtext                 mime-text-realtext"          \
        "audio-vnd.rn-realaudio               mime-audio-ra"               \
        "audio-x-pn-realaudio                 mime-audio-ra"               \
        "audio-x-realaudio                    mime-audio-ra"               \
        "audio-x-realaudio-secure             mime-audio-ra"               \
        "application-vnd.rn-realaudio-secure  mime-audio-ra"               \
        "application-vnd.rn-realmedia         mime-application-rm"         \
        "application-vnd.rn-realmedia-vbr     mime-application-rm"         \
        "application-vnd.rn-realmedia-secure  mime-application-rm"         \
        "application-vnd.rn-realsystem-rmj    mime-application-rm"         \
        "application-vnd.rn-realsystem-rmx    mime-application-rm"         \
        "image-vnd.rn-realpix                 mime-application-generic"    \
        "video-vnd.rn-realvideo               mime-video-rv"               \
        "video-vnd.rn-realvideo-secure        mime-video-rv"               \
        "audio-x-aac                          mime-audio-generic"          \
        "application-smil                     mime-application-smil"       \
        "application-x-smil                   mime-application-smil"       \
        "application-smil+xml                 mime-application-smil"       \
        "application-streamingmedia           mime-application-generic"    \
        "application-x-streamingmedia         mime-application-generic"    \
        "application-sdp                      mime-application-generic"    \
        "audio-basic                          mime-audio-generic"          \
        "audio-x-pn-au                        mime-audio-au"               \
        "audio-aiff                           mime-audio-aiff"             \
        "audio-x-aiff                         mime-audio-aiff"             \
        "audio-x-pn-aiff                      mime-audio-aiff"             \
        "video-3gpp                           mime-video-generic"          \
        "video-3gpp-encrypted                 mime-video-generic"          \
        "audio-3gpp                           mime-audio-mp4"              \
        "audio-3gpp-encrypted                 mime-audio-mp4"              \
        "audio-amr                            mime-audio-generic"          \
        "audio-amr-encrypted                  mime-audio-generic"          \
        "audio-amr-wb                         mime-audio-generic"          \
        "audio-amr-wb-encrypted               mime-audio-generic"          \
        "audio-x-rn-3gpp-amr                  mime-audio-mp4"              \
        "audio-x-rn-3gpp-amr-encrypted        mime-audio-mp4"              \
        "audio-x-rn-3gpp-amr-wb               mime-audio-mp4"              \
        "audio-x-rn-3gpp-amr-wb-encrypted     mime-audio-mp4"              \
        "audio-x-rn-3gpp-amr-wb-encrypted     mime-audio-mp4"              \
        "video-3gpp2                          mime-video-generic"          \
        "audio-3gpp2                          mime-audio-mp4"              \
        "video-x-real-video                   mime-video-rv"               \
        "video-mpeg4-generic                  mime-video-generic"
    do
        MIME_TYPES=${ROW%% *}    # Greedy; delete trailing space followed by anything.
        ICON_NAME=${ROW##* }     # Greedy; delete leading anything and space.
        ICON="$INSTDIR/share/icons/${ICON_NAME}_${SIZE}x${SIZE}.png"
        if [ -f "$ICON" ] ; then
            eval_cmd xdg-icon-resource $CMD --novendor --noupdate \
                --context mimetypes --size ${SIZE} ${ICON} ${MIME_TYPES}
        fi
    done
done

eval_cmd xdg-icon-resource forceupdate

#last_cmd_status_check

popd > /dev/null

