
/*! \brief
 * Define compile time symbols for CPU type and operating system type.
 * This file should only contain preprocessor commands so that
 * there are no dependencies on other files.
 *
 * cpuopsys.h
 *
 * Copyright (c) 2001, Nvidia Corporation.  All rights reserved.
 */

/*!
 * Uniform names are defined for compile time options to distinguish
 * CPU types and Operating systems.
 * Distinctions between CPU and OpSys should be orthogonal.
 *
 * These uniform names have initially been defined by keying off the
 * makefile/build names defined for builds in the OpenGL group.
 * Getting the uniform names defined for other builds may require
 * different qualifications.
 *
 * The file is placed here to allow for the possibility of all driver
 * components using the same naming convention for conditional compilation.
 */

#ifndef __cpuopsys_h_
#define __cpuopsys_h_

/*****************************************************************************/
// Define all OS/CPU-Chip related symbols

// ***** DOS variations
#if defined(__DJGPP__)
#   define NV_DOS
#endif

// ***** WINDOWS variations
#if defined(_WIN32) || defined(_WIN16)
#   define NV_WINDOWS

#   if defined(_WIN32_WINNT)
#      define NV_WINDOWS_NT
#   elif defined(_WIN32_WCE)
#      define NV_WINDOWS_CE
#   elif !defined(NV_MODS)
#      define NV_WINDOWS_9X
#   endif
#endif  // _WIN32 || defined(_WIN16)

// ***** Unix variations
#if defined(__linux__) && !defined(NV_LINUX)
#   define NV_LINUX
#endif  // defined(__linux__)

// SunOS + gcc
#if defined(__sun__) && defined(__svr4__)
#   define NV_SUNOS
#endif // defined(__sun__) && defined(__svr4__)

// SunOS + Sun Compiler (named SunPro, Studio or Forte)
#if defined(__SUNPRO_C) || defined(__SUNPRO_CC)
#   define NV_SUNPRO_C
#   define NV_SUNOS
#   define  __FUNCTION__ __func__
#   define NV_OPENGL_THREAD_UNSAFE // XXX To start with
#endif // defined(_SUNPRO_C) || defined(__SUNPRO_CC)

#if defined(__FreeBSD__)
#   define NV_BSD
#endif // defined(__FreeBSD__)

// XXXar don't define NV_UNIX on MacOSX or vxworks or dos or QNX
#if (defined(__unix__) || defined(__unix) ) && !defined(macosx) && !defined(vxworks) && !defined(__DJGPP__) && !defined(NV_UNIX) && !defined(__QNX__) && !defined(__QNXNTO__)// XXX until removed from Makefiles
#   define NV_UNIX
#endif // defined(__unix__)

#if (defined(__QNX__) || defined(__QNXNTO__)) && !defined(NV_QNX)
#   define NV_QNX
#endif

// ***** Apple variations
#if defined(macintosh) || defined(__APPLE__)
#   define NV_MACINTOSH
#   if defined(__MACH__)
#      define NV_MACINTOSH_OSX
#      if !defined(NV_MODS)
#         define NV_MACOSX_OPENGL
#      endif
#   else
#      define NV_MACINTOSH_OS9
#   endif
#   if defined(__LP64__)
#      define NV_MACINTOSH_64
#   endif
#endif  // defined(macintosh)

// ***** X-Box
#if defined(_XBOX)
#   define NV_XBOX
#endif

// ***** VxWorks
#if defined(vxworks)
#   define NV_VXWORKS
#   if (CPU==PENTIUM)
#      define NV_VXWORKS_PENTIUM
#   elif (CPU==PPC604)
#      define NV_VXWORKS_PPC604
#   endif
#endif

// ***** Processor type variations
// Note: The prefix NV_CPU_* is taken by \\sw\main\sdk\nvidia\inc\Nvcm.h

#if ((defined(_M_IX86) || defined(__i386__) || defined(__i386)) && !defined(NVCPU_X86)) // XXX until removed from Makefiles
    // _M_IX86 for windows, __i386__ for Linux (or any x86 using gcc)
    // __i386 for Studio compiler on Solaris x86
#   define NVCPU_X86               // any IA32 machine (not x86-64)
#endif

#if defined(_WIN32) && defined(_M_IA64)
#   define NVCPU_IA64_WINDOWS      // any IA64 for Windows opsys
#endif
#if defined(NV_LINUX) && defined(__ia64__)
#   define NVCPU_IA64_LINUX        // any IA64 for Linux opsys
#endif
#if defined(NVCPU_IA64_WINDOWS) || defined(NVCPU_IA64_LINUX) || defined(IA64)
#   define NVCPU_IA64              // any IA64 for any opsys
#endif

#if (defined(NV_MACINTOSH) && !(defined(__i386__) || defined(__x86_64__)))  || defined(__PPC__)
#   ifndef NVCPU_PPC
#   define NVCPU_PPC               // any PowerPC architecture
#   endif
#   ifndef NV_BIG_ENDIAN
#   define NV_BIG_ENDIAN
#   endif
#endif

#if defined(__x86_64) || defined(AMD64) || defined(_M_AMD64)
#    define NVCPU_X86_64           // any x86-64 for any opsys
#endif

#if defined(__XSCALE__)
#define NVCPU_XSCALE               // for XSCALE ARM processors
#endif

#if defined(__SH4__)
#   ifndef NVCPU_SH4
#   define NVCPU_SH4               // Renesas (formerly Hitachi) SH4
#   endif
#endif

// For Xtensa processors
#if defined(__XTENSA__)
# define NVCPU_XTENSA
# if defined(__XTENSA_EB__)
#  define NV_BIG_ENDIAN
# endif
#endif


// Other flavors of CPU type should be determined at run-time.
// For example, an x86 architecture with/without SSE.
// If it can compile, then there's no need for a compile time option.
// For some current GCC limitations, these may be fixed by using the Intel
// compiler for certain files in a Linux build.


#if defined(NVCPU_IA64) || defined(NVCPU_X86_64)
#   define NV_64_BITS          // all architectures where pointers are 64 bits
#else
    // we assume 32 bits. I don't see a need for NV_16_BITS.
#endif

// NOTE: NV_INT64_OK is not needed in the OpenGL driver for any platform
// we care about these days. The only consideration is that Linux does not
// have a 64-bit divide on the server. To get around this, we convert the
// expression to (double) for the division.
#if (!(defined(macintosh) || defined(vxworks) || defined(__INTEL_COMPILER)) || defined(NV_LINUX)) && !defined(NV_INT64_OK)
#define NV_INT64_OK
#endif

// For verification-only features not intended to be included in normal drivers
#if defined(NV_MODS) && defined(DEBUG) && !defined(NV_DOS)
#define NV_VERIF_FEATURES
#endif

/*****************************************************************************/

#endif /* __cpuopsys_h_ */
