using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Contacts specific imports
using Google.GData.Client;
using Google.GData.Extensions;
using Google.GData.Contacts;
using Google.GData.Tools;
#endregion

namespace Google_ContactsApplication
{
    public partial class Form1 : Form
    {

        private String googleAuthToken = null;
        private ContactsService contactsService = null;

        public Form1()
        {
            InitializeComponent();

            this.contactsService = new ContactsService("GoogleContactsSample");

            if (this.googleAuthToken == null)
            {
                GoogleClientLogin loginDialog = new GoogleClientLogin(this.contactsService, "youremailhere@gmail.com");
                loginDialog.ShowDialog();

                this.googleAuthToken = loginDialog.AuthenticationToken;

                if (this.googleAuthToken != null)
                {
                    this.contactsService.SetAuthenticationToken(this.googleAuthToken);
                    this.Text = "Successfully logged in";

                    ContactsQuery query = new ContactsQuery(ContactsQuery.CreateContactsUri(loginDialog.User));
                    this.listView.Clear();

                    ContactsFeed feed = this.contactsService.Query(query);

                    if (feed != null && feed.Entries.Count > 0)
                    {
                        foreach (ContactEntry entry in feed.Entries)
                        {
                            ListViewItem item = new ListViewItem(entry.Title.Text);
                            item.Tag = entry;
                            this.listView.Items.Add(item);
                        }
                    }
                    this.listView.Update();
                }
            }
        }
    }
}