/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_NL_CONFIG_H
#define _HAVE_NL_CONFIG_H

#include <glib.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define NL_TYPE_CONFIG (nl_config_get_type ())

#define NL_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        NL_TYPE_CONFIG, NlConfig))

#define NL_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        NL_TYPE_CONFIG, NlConfigClass))

#define NL_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        NL_TYPE_CONFIG))

#define NL_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        NL_TYPE_CONFIG))

#define NL_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        NL_TYPE_CONFIG, NlConfigClass))

typedef struct _NlConfig NlConfig;
typedef struct _NlConfigClass NlConfigClass;
typedef struct _NlConfigPrivate NlConfigPrivate;

struct _NlConfig
{
  GObject       parent;

  /* Config values */
  gboolean      tablet_mode;
  gboolean      is_portrait;
  gboolean      disable_single_instance;
  gint          win_width;
  gint          win_height;
  gint          bar_width;
  gint          n_cats;

  gint          iconview_width;
  gint          iconview_height;
  gint          iconview_padding;
  gint          iconview_rows;
  gint          iconview_cols;

  gint          icon_width;
  gint          icon_height;

  gint          shortcut_height;

  gchar         font_name[300];

  gboolean      low_graphics;

  gint          monitor_number;
  gint          monitor_width;
  gint          monitor_height;
  
  /*< private >*/
  NlConfigPrivate   *priv;
};

struct _NlConfigClass 
{
  /*< private >*/
  GObjectClass    parent_class;

  /* <signals> */
  void (*config_changed) (NlConfig *config);
  void (*resume_event)   (NlConfig *condfig);
  
  /* future padding */
  void (*_nl_config_1) (void);
  void (*_nl_config_2) (void);
  void (*_nl_config_3) (void);
  void (*_nl_config_4) (void);
};

GType           nl_config_get_type    (void) G_GNUC_CONST;

NlConfig*       nl_config_get_default (void);

gint            nl_config_get_n_cats  (NlConfig *cfg);

void            nl_config_set_windowed (gint width, gint height);

G_END_DECLS

#endif /* _HAVE_NL_CONFIG_H */
