/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include "HTMLVideoElement.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLVideoElement);

/* Hash table */

static const HashTableValue JSHTMLVideoElementTableValues[7] =
{
    { "width", DontDelete, (intptr_t)jsHTMLVideoElementWidth, (intptr_t)setJSHTMLVideoElementWidth },
    { "height", DontDelete, (intptr_t)jsHTMLVideoElementHeight, (intptr_t)setJSHTMLVideoElementHeight },
    { "videoWidth", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoWidth, (intptr_t)0 },
    { "videoHeight", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoHeight, (intptr_t)0 },
    { "poster", DontDelete, (intptr_t)jsHTMLVideoElementPoster, (intptr_t)setJSHTMLVideoElementPoster },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLVideoElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLVideoElementTableValues, 0 };
#else
    { 17, 15, JSHTMLVideoElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLVideoElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLVideoElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLVideoElementConstructorTableValues, 0 };
#endif

class JSHTMLVideoElementConstructor : public DOMConstructorObject {
public:
    JSHTMLVideoElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLVideoElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLVideoElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElementConstructor", 0, &JSHTMLVideoElementConstructorTable, 0 };

bool JSHTMLVideoElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElementConstructor, DOMObject>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLVideoElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLVideoElementConstructor, DOMObject>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLVideoElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLVideoElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", 0, &JSHTMLVideoElementPrototypeTable, 0 };

JSObject* JSHTMLVideoElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(exec, globalObject);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &JSHTMLMediaElement::s_info, &JSHTMLVideoElementTable, 0 };

JSHTMLVideoElement::JSHTMLVideoElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLVideoElement> impl)
    : JSHTMLMediaElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLVideoElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLVideoElementPrototype(JSHTMLVideoElementPrototype::createStructure(JSHTMLMediaElementPrototype::self(exec, globalObject)));
}

bool JSHTMLVideoElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, slot);
}

bool JSHTMLVideoElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLVideoElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    return jsNumber(exec, imp->width());
}

JSValue jsHTMLVideoElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    return jsNumber(exec, imp->height());
}

JSValue jsHTMLVideoElementVideoWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    return jsNumber(exec, imp->videoWidth());
}

JSValue jsHTMLVideoElementVideoHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    return jsNumber(exec, imp->videoHeight());
}

JSValue jsHTMLVideoElementPoster(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    return jsString(exec, imp->poster());
}

JSValue jsHTMLVideoElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLVideoElement* domObject = static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()));
    return JSHTMLVideoElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLVideoElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLVideoElement, Base>(exec, propertyName, value, &JSHTMLVideoElementTable, this, slot);
}

void setJSHTMLVideoElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setWidth(value.toInt32(exec));
}

void setJSHTMLVideoElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setHeight(value.toInt32(exec));
}

void setJSHTMLVideoElementPoster(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setPoster(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLVideoElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(VIDEO)
