/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_epmapper.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_epm_protocol(struct ndr_push *ndr, int ndr_flags, enum epm_protocol r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_protocol(struct ndr_pull *ndr, int ndr_flags, enum epm_protocol *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_protocol(struct ndr_print *ndr, const char *name, enum epm_protocol r)
{
	const char *val = NULL;

	switch (r) {
		case EPM_PROTOCOL_DNET_NSP: val = "EPM_PROTOCOL_DNET_NSP"; break;
		case EPM_PROTOCOL_OSI_TP4: val = "EPM_PROTOCOL_OSI_TP4"; break;
		case EPM_PROTOCOL_OSI_CLNS: val = "EPM_PROTOCOL_OSI_CLNS"; break;
		case EPM_PROTOCOL_TCP: val = "EPM_PROTOCOL_TCP"; break;
		case EPM_PROTOCOL_UDP: val = "EPM_PROTOCOL_UDP"; break;
		case EPM_PROTOCOL_IP: val = "EPM_PROTOCOL_IP"; break;
		case EPM_PROTOCOL_NCADG: val = "EPM_PROTOCOL_NCADG"; break;
		case EPM_PROTOCOL_NCACN: val = "EPM_PROTOCOL_NCACN"; break;
		case EPM_PROTOCOL_NCALRPC: val = "EPM_PROTOCOL_NCALRPC"; break;
		case EPM_PROTOCOL_UUID: val = "EPM_PROTOCOL_UUID"; break;
		case EPM_PROTOCOL_IPX: val = "EPM_PROTOCOL_IPX"; break;
		case EPM_PROTOCOL_SMB: val = "EPM_PROTOCOL_SMB"; break;
		case EPM_PROTOCOL_PIPE: val = "EPM_PROTOCOL_PIPE"; break;
		case EPM_PROTOCOL_NETBIOS: val = "EPM_PROTOCOL_NETBIOS"; break;
		case EPM_PROTOCOL_NETBEUI: val = "EPM_PROTOCOL_NETBEUI"; break;
		case EPM_PROTOCOL_SPX: val = "EPM_PROTOCOL_SPX"; break;
		case EPM_PROTOCOL_NB_IPX: val = "EPM_PROTOCOL_NB_IPX"; break;
		case EPM_PROTOCOL_DSP: val = "EPM_PROTOCOL_DSP"; break;
		case EPM_PROTOCOL_DDP: val = "EPM_PROTOCOL_DDP"; break;
		case EPM_PROTOCOL_APPLETALK: val = "EPM_PROTOCOL_APPLETALK"; break;
		case EPM_PROTOCOL_VINES_SPP: val = "EPM_PROTOCOL_VINES_SPP"; break;
		case EPM_PROTOCOL_VINES_IPC: val = "EPM_PROTOCOL_VINES_IPC"; break;
		case EPM_PROTOCOL_STREETTALK: val = "EPM_PROTOCOL_STREETTALK"; break;
		case EPM_PROTOCOL_HTTP: val = "EPM_PROTOCOL_HTTP"; break;
		case EPM_PROTOCOL_UNIX_DS: val = "EPM_PROTOCOL_UNIX_DS"; break;
		case EPM_PROTOCOL_NULL: val = "EPM_PROTOCOL_NULL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_epm_rhs_dnet_nsp(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_dnet_nsp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_dnet_nsp(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_dnet_nsp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_dnet_nsp(struct ndr_print *ndr, const char *name, const struct epm_rhs_dnet_nsp *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_dnet_nsp");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_osi_tp4(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_osi_tp4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_osi_tp4(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_osi_tp4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_osi_tp4(struct ndr_print *ndr, const char *name, const struct epm_rhs_osi_tp4 *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_osi_tp4");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_osi_clns(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_osi_clns *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_osi_clns(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_osi_clns *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_osi_clns(struct ndr_print *ndr, const char *name, const struct epm_rhs_osi_clns *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_osi_clns");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_udp(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_udp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_udp(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_udp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_udp(struct ndr_print *ndr, const char *name, const struct epm_rhs_udp *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_udp");
	ndr->depth++;
	ndr_print_uint16(ndr, "port", r->port);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_tcp(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_tcp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_tcp(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_tcp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_tcp(struct ndr_print *ndr, const char *name, const struct epm_rhs_tcp *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_tcp");
	ndr->depth++;
	ndr_print_uint16(ndr, "port", r->port);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_ip(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_ip *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipaddr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_ip(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_ip *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipaddr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_ip(struct ndr_print *ndr, const char *name, const struct epm_rhs_ip *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_ip");
	ndr->depth++;
	ndr_print_ipv4address(ndr, "ipaddr", r->ipaddr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_ncadg(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_ncadg *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_ncadg(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_ncadg *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_ncadg(struct ndr_print *ndr, const char *name, const struct epm_rhs_ncadg *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_ncadg");
	ndr->depth++;
	ndr_print_uint16(ndr, "minor_version", r->minor_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_ncacn(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_ncacn *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_ncacn(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_ncacn *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_ncacn(struct ndr_print *ndr, const char *name, const struct epm_rhs_ncacn *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_ncacn");
	ndr->depth++;
	ndr_print_uint16(ndr, "minor_version", r->minor_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_uuid(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_uuid *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->unknown));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_uuid(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_uuid *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->unknown));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_uuid(struct ndr_print *ndr, const char *name, const struct epm_rhs_uuid *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_uuid");
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "unknown", r->unknown);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_ipx(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_ipx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_ipx(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_ipx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_ipx(struct ndr_print *ndr, const char *name, const struct epm_rhs_ipx *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_ipx");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_smb(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_smb *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->unc));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_smb(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_smb *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->unc));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_smb(struct ndr_print *ndr, const char *name, const struct epm_rhs_smb *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_smb");
	ndr->depth++;
	ndr_print_string(ndr, "unc", r->unc);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_pipe(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_pipe *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->path));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_pipe(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_pipe *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->path));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_pipe(struct ndr_print *ndr, const char *name, const struct epm_rhs_pipe *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_pipe");
	ndr->depth++;
	ndr_print_string(ndr, "path", r->path);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_netbios(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_netbios *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_netbios(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_netbios *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_netbios(struct ndr_print *ndr, const char *name, const struct epm_rhs_netbios *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_netbios");
	ndr->depth++;
	ndr_print_string(ndr, "name", r->name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_netbeui(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_netbeui *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_netbeui(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_netbeui *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_netbeui(struct ndr_print *ndr, const char *name, const struct epm_rhs_netbeui *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_netbeui");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_spx(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_spx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_spx(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_spx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_spx(struct ndr_print *ndr, const char *name, const struct epm_rhs_spx *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_spx");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_nb_ipx(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_nb_ipx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_nb_ipx(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_nb_ipx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_nb_ipx(struct ndr_print *ndr, const char *name, const struct epm_rhs_nb_ipx *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_nb_ipx");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_http(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_http *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_http(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_http *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_http(struct ndr_print *ndr, const char *name, const struct epm_rhs_http *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_http");
	ndr->depth++;
	ndr_print_uint16(ndr, "port", r->port);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_unix_ds(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_unix_ds *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->path));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_unix_ds(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_unix_ds *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->path));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_unix_ds(struct ndr_print *ndr, const char *name, const struct epm_rhs_unix_ds *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_unix_ds");
	ndr->depth++;
	ndr_print_string(ndr, "path", r->path);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_null(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_null *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_null(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_null *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_null(struct ndr_print *ndr, const char *name, const struct epm_rhs_null *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_null");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_ncalrpc(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_ncalrpc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_ncalrpc(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_ncalrpc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->minor_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_ncalrpc(struct ndr_print *ndr, const char *name, const struct epm_rhs_ncalrpc *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_ncalrpc");
	ndr->depth++;
	ndr_print_uint16(ndr, "minor_version", r->minor_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_appletalk(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_appletalk *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_appletalk(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_appletalk *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_appletalk(struct ndr_print *ndr, const char *name, const struct epm_rhs_appletalk *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_appletalk");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_atalk_stream(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_atalk_stream *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_atalk_stream(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_atalk_stream *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_atalk_stream(struct ndr_print *ndr, const char *name, const struct epm_rhs_atalk_stream *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_atalk_stream");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_atalk_datagram(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_atalk_datagram *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_atalk_datagram(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_atalk_datagram *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_atalk_datagram(struct ndr_print *ndr, const char *name, const struct epm_rhs_atalk_datagram *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_atalk_datagram");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_vines_spp(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_vines_spp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_vines_spp(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_vines_spp *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_vines_spp(struct ndr_print *ndr, const char *name, const struct epm_rhs_vines_spp *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_vines_spp");
	ndr->depth++;
	ndr_print_uint16(ndr, "port", r->port);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_vines_ipc(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_vines_ipc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_vines_ipc(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_vines_ipc *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_vines_ipc(struct ndr_print *ndr, const char *name, const struct epm_rhs_vines_ipc *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_vines_ipc");
	ndr->depth++;
	ndr_print_uint16(ndr, "port", r->port);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs_streettalk(struct ndr_push *ndr, int ndr_flags, const struct epm_rhs_streettalk *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->streettalk));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs_streettalk(struct ndr_pull *ndr, int ndr_flags, struct epm_rhs_streettalk *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->streettalk));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs_streettalk(struct ndr_print *ndr, const char *name, const struct epm_rhs_streettalk *r)
{
	ndr_print_struct(ndr, name, "epm_rhs_streettalk");
	ndr->depth++;
	ndr_print_string(ndr, "streettalk", r->streettalk);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_rhs(struct ndr_push *ndr, int ndr_flags, const union epm_rhs *r)
{
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		if (ndr_flags & NDR_SCALARS) {
			int level = ndr_push_get_switch_value(ndr, r);
			switch (level) {
				case EPM_PROTOCOL_DNET_NSP: {
					NDR_CHECK(ndr_push_epm_rhs_dnet_nsp(ndr, NDR_SCALARS, &r->dnet_nsp));
				break; }

				case EPM_PROTOCOL_OSI_TP4: {
					NDR_CHECK(ndr_push_epm_rhs_osi_tp4(ndr, NDR_SCALARS, &r->osi_tp4));
				break; }

				case EPM_PROTOCOL_OSI_CLNS: {
					NDR_CHECK(ndr_push_epm_rhs_osi_clns(ndr, NDR_SCALARS, &r->osi_clns));
				break; }

				case EPM_PROTOCOL_TCP: {
					NDR_CHECK(ndr_push_epm_rhs_tcp(ndr, NDR_SCALARS, &r->tcp));
				break; }

				case EPM_PROTOCOL_UDP: {
					NDR_CHECK(ndr_push_epm_rhs_udp(ndr, NDR_SCALARS, &r->udp));
				break; }

				case EPM_PROTOCOL_IP: {
					NDR_CHECK(ndr_push_epm_rhs_ip(ndr, NDR_SCALARS, &r->ip));
				break; }

				case EPM_PROTOCOL_NCADG: {
					NDR_CHECK(ndr_push_epm_rhs_ncadg(ndr, NDR_SCALARS, &r->ncadg));
				break; }

				case EPM_PROTOCOL_NCACN: {
					NDR_CHECK(ndr_push_epm_rhs_ncacn(ndr, NDR_SCALARS, &r->ncacn));
				break; }

				case EPM_PROTOCOL_NCALRPC: {
					NDR_CHECK(ndr_push_epm_rhs_ncalrpc(ndr, NDR_SCALARS, &r->ncalrpc));
				break; }

				case EPM_PROTOCOL_UUID: {
					NDR_CHECK(ndr_push_epm_rhs_uuid(ndr, NDR_SCALARS, &r->uuid));
				break; }

				case EPM_PROTOCOL_IPX: {
					NDR_CHECK(ndr_push_epm_rhs_ipx(ndr, NDR_SCALARS, &r->ipx));
				break; }

				case EPM_PROTOCOL_SMB: {
					NDR_CHECK(ndr_push_epm_rhs_smb(ndr, NDR_SCALARS, &r->smb));
				break; }

				case EPM_PROTOCOL_PIPE: {
					NDR_CHECK(ndr_push_epm_rhs_pipe(ndr, NDR_SCALARS, &r->pipe));
				break; }

				case EPM_PROTOCOL_NETBIOS: {
					NDR_CHECK(ndr_push_epm_rhs_netbios(ndr, NDR_SCALARS, &r->netbios));
				break; }

				case EPM_PROTOCOL_NETBEUI: {
					NDR_CHECK(ndr_push_epm_rhs_netbeui(ndr, NDR_SCALARS, &r->netbeui));
				break; }

				case EPM_PROTOCOL_SPX: {
					NDR_CHECK(ndr_push_epm_rhs_spx(ndr, NDR_SCALARS, &r->spx));
				break; }

				case EPM_PROTOCOL_NB_IPX: {
					NDR_CHECK(ndr_push_epm_rhs_nb_ipx(ndr, NDR_SCALARS, &r->nb_ipx));
				break; }

				case EPM_PROTOCOL_DSP: {
					NDR_CHECK(ndr_push_epm_rhs_atalk_stream(ndr, NDR_SCALARS, &r->atalk_stream));
				break; }

				case EPM_PROTOCOL_DDP: {
					NDR_CHECK(ndr_push_epm_rhs_atalk_datagram(ndr, NDR_SCALARS, &r->atalk_datagram));
				break; }

				case EPM_PROTOCOL_APPLETALK: {
					NDR_CHECK(ndr_push_epm_rhs_appletalk(ndr, NDR_SCALARS, &r->appletalk));
				break; }

				case EPM_PROTOCOL_VINES_SPP: {
					NDR_CHECK(ndr_push_epm_rhs_vines_spp(ndr, NDR_SCALARS, &r->vines_spp));
				break; }

				case EPM_PROTOCOL_VINES_IPC: {
					NDR_CHECK(ndr_push_epm_rhs_vines_ipc(ndr, NDR_SCALARS, &r->vines_ipc));
				break; }

				case EPM_PROTOCOL_STREETTALK: {
					NDR_CHECK(ndr_push_epm_rhs_streettalk(ndr, NDR_SCALARS, &r->streettalk));
				break; }

				case EPM_PROTOCOL_HTTP: {
					NDR_CHECK(ndr_push_epm_rhs_http(ndr, NDR_SCALARS, &r->http));
				break; }

				case EPM_PROTOCOL_UNIX_DS: {
					NDR_CHECK(ndr_push_epm_rhs_unix_ds(ndr, NDR_SCALARS, &r->unix_ds));
				break; }

				case EPM_PROTOCOL_NULL: {
					NDR_CHECK(ndr_push_epm_rhs_null(ndr, NDR_SCALARS, &r->null));
				break; }

				default: {
					{
						uint32_t _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->unknown));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			int level = ndr_push_get_switch_value(ndr, r);
			switch (level) {
				case EPM_PROTOCOL_DNET_NSP:
				break;

				case EPM_PROTOCOL_OSI_TP4:
				break;

				case EPM_PROTOCOL_OSI_CLNS:
				break;

				case EPM_PROTOCOL_TCP:
				break;

				case EPM_PROTOCOL_UDP:
				break;

				case EPM_PROTOCOL_IP:
				break;

				case EPM_PROTOCOL_NCADG:
				break;

				case EPM_PROTOCOL_NCACN:
				break;

				case EPM_PROTOCOL_NCALRPC:
				break;

				case EPM_PROTOCOL_UUID:
				break;

				case EPM_PROTOCOL_IPX:
				break;

				case EPM_PROTOCOL_SMB:
				break;

				case EPM_PROTOCOL_PIPE:
				break;

				case EPM_PROTOCOL_NETBIOS:
				break;

				case EPM_PROTOCOL_NETBEUI:
				break;

				case EPM_PROTOCOL_SPX:
				break;

				case EPM_PROTOCOL_NB_IPX:
				break;

				case EPM_PROTOCOL_DSP:
				break;

				case EPM_PROTOCOL_DDP:
				break;

				case EPM_PROTOCOL_APPLETALK:
				break;

				case EPM_PROTOCOL_VINES_SPP:
				break;

				case EPM_PROTOCOL_VINES_IPC:
				break;

				case EPM_PROTOCOL_STREETTALK:
				break;

				case EPM_PROTOCOL_HTTP:
				break;

				case EPM_PROTOCOL_UNIX_DS:
				break;

				case EPM_PROTOCOL_NULL:
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_rhs(struct ndr_pull *ndr, int ndr_flags, union epm_rhs *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		level = ndr_pull_get_switch_value(ndr, r);
		if (ndr_flags & NDR_SCALARS) {
			switch (level) {
				case EPM_PROTOCOL_DNET_NSP: {
					NDR_CHECK(ndr_pull_epm_rhs_dnet_nsp(ndr, NDR_SCALARS, &r->dnet_nsp));
				break; }

				case EPM_PROTOCOL_OSI_TP4: {
					NDR_CHECK(ndr_pull_epm_rhs_osi_tp4(ndr, NDR_SCALARS, &r->osi_tp4));
				break; }

				case EPM_PROTOCOL_OSI_CLNS: {
					NDR_CHECK(ndr_pull_epm_rhs_osi_clns(ndr, NDR_SCALARS, &r->osi_clns));
				break; }

				case EPM_PROTOCOL_TCP: {
					NDR_CHECK(ndr_pull_epm_rhs_tcp(ndr, NDR_SCALARS, &r->tcp));
				break; }

				case EPM_PROTOCOL_UDP: {
					NDR_CHECK(ndr_pull_epm_rhs_udp(ndr, NDR_SCALARS, &r->udp));
				break; }

				case EPM_PROTOCOL_IP: {
					NDR_CHECK(ndr_pull_epm_rhs_ip(ndr, NDR_SCALARS, &r->ip));
				break; }

				case EPM_PROTOCOL_NCADG: {
					NDR_CHECK(ndr_pull_epm_rhs_ncadg(ndr, NDR_SCALARS, &r->ncadg));
				break; }

				case EPM_PROTOCOL_NCACN: {
					NDR_CHECK(ndr_pull_epm_rhs_ncacn(ndr, NDR_SCALARS, &r->ncacn));
				break; }

				case EPM_PROTOCOL_NCALRPC: {
					NDR_CHECK(ndr_pull_epm_rhs_ncalrpc(ndr, NDR_SCALARS, &r->ncalrpc));
				break; }

				case EPM_PROTOCOL_UUID: {
					NDR_CHECK(ndr_pull_epm_rhs_uuid(ndr, NDR_SCALARS, &r->uuid));
				break; }

				case EPM_PROTOCOL_IPX: {
					NDR_CHECK(ndr_pull_epm_rhs_ipx(ndr, NDR_SCALARS, &r->ipx));
				break; }

				case EPM_PROTOCOL_SMB: {
					NDR_CHECK(ndr_pull_epm_rhs_smb(ndr, NDR_SCALARS, &r->smb));
				break; }

				case EPM_PROTOCOL_PIPE: {
					NDR_CHECK(ndr_pull_epm_rhs_pipe(ndr, NDR_SCALARS, &r->pipe));
				break; }

				case EPM_PROTOCOL_NETBIOS: {
					NDR_CHECK(ndr_pull_epm_rhs_netbios(ndr, NDR_SCALARS, &r->netbios));
				break; }

				case EPM_PROTOCOL_NETBEUI: {
					NDR_CHECK(ndr_pull_epm_rhs_netbeui(ndr, NDR_SCALARS, &r->netbeui));
				break; }

				case EPM_PROTOCOL_SPX: {
					NDR_CHECK(ndr_pull_epm_rhs_spx(ndr, NDR_SCALARS, &r->spx));
				break; }

				case EPM_PROTOCOL_NB_IPX: {
					NDR_CHECK(ndr_pull_epm_rhs_nb_ipx(ndr, NDR_SCALARS, &r->nb_ipx));
				break; }

				case EPM_PROTOCOL_DSP: {
					NDR_CHECK(ndr_pull_epm_rhs_atalk_stream(ndr, NDR_SCALARS, &r->atalk_stream));
				break; }

				case EPM_PROTOCOL_DDP: {
					NDR_CHECK(ndr_pull_epm_rhs_atalk_datagram(ndr, NDR_SCALARS, &r->atalk_datagram));
				break; }

				case EPM_PROTOCOL_APPLETALK: {
					NDR_CHECK(ndr_pull_epm_rhs_appletalk(ndr, NDR_SCALARS, &r->appletalk));
				break; }

				case EPM_PROTOCOL_VINES_SPP: {
					NDR_CHECK(ndr_pull_epm_rhs_vines_spp(ndr, NDR_SCALARS, &r->vines_spp));
				break; }

				case EPM_PROTOCOL_VINES_IPC: {
					NDR_CHECK(ndr_pull_epm_rhs_vines_ipc(ndr, NDR_SCALARS, &r->vines_ipc));
				break; }

				case EPM_PROTOCOL_STREETTALK: {
					NDR_CHECK(ndr_pull_epm_rhs_streettalk(ndr, NDR_SCALARS, &r->streettalk));
				break; }

				case EPM_PROTOCOL_HTTP: {
					NDR_CHECK(ndr_pull_epm_rhs_http(ndr, NDR_SCALARS, &r->http));
				break; }

				case EPM_PROTOCOL_UNIX_DS: {
					NDR_CHECK(ndr_pull_epm_rhs_unix_ds(ndr, NDR_SCALARS, &r->unix_ds));
				break; }

				case EPM_PROTOCOL_NULL: {
					NDR_CHECK(ndr_pull_epm_rhs_null(ndr, NDR_SCALARS, &r->null));
				break; }

				default: {
					{
						uint32_t _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->unknown));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			switch (level) {
				case EPM_PROTOCOL_DNET_NSP:
				break;

				case EPM_PROTOCOL_OSI_TP4:
				break;

				case EPM_PROTOCOL_OSI_CLNS:
				break;

				case EPM_PROTOCOL_TCP:
				break;

				case EPM_PROTOCOL_UDP:
				break;

				case EPM_PROTOCOL_IP:
				break;

				case EPM_PROTOCOL_NCADG:
				break;

				case EPM_PROTOCOL_NCACN:
				break;

				case EPM_PROTOCOL_NCALRPC:
				break;

				case EPM_PROTOCOL_UUID:
				break;

				case EPM_PROTOCOL_IPX:
				break;

				case EPM_PROTOCOL_SMB:
				break;

				case EPM_PROTOCOL_PIPE:
				break;

				case EPM_PROTOCOL_NETBIOS:
				break;

				case EPM_PROTOCOL_NETBEUI:
				break;

				case EPM_PROTOCOL_SPX:
				break;

				case EPM_PROTOCOL_NB_IPX:
				break;

				case EPM_PROTOCOL_DSP:
				break;

				case EPM_PROTOCOL_DDP:
				break;

				case EPM_PROTOCOL_APPLETALK:
				break;

				case EPM_PROTOCOL_VINES_SPP:
				break;

				case EPM_PROTOCOL_VINES_IPC:
				break;

				case EPM_PROTOCOL_STREETTALK:
				break;

				case EPM_PROTOCOL_HTTP:
				break;

				case EPM_PROTOCOL_UNIX_DS:
				break;

				case EPM_PROTOCOL_NULL:
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_rhs(struct ndr_print *ndr, const char *name, const union epm_rhs *r)
{
	int level;
	{
		uint32_t _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		level = ndr_print_get_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "epm_rhs");
		switch (level) {
			case EPM_PROTOCOL_DNET_NSP:
				ndr_print_epm_rhs_dnet_nsp(ndr, "dnet_nsp", &r->dnet_nsp);
			break;

			case EPM_PROTOCOL_OSI_TP4:
				ndr_print_epm_rhs_osi_tp4(ndr, "osi_tp4", &r->osi_tp4);
			break;

			case EPM_PROTOCOL_OSI_CLNS:
				ndr_print_epm_rhs_osi_clns(ndr, "osi_clns", &r->osi_clns);
			break;

			case EPM_PROTOCOL_TCP:
				ndr_print_epm_rhs_tcp(ndr, "tcp", &r->tcp);
			break;

			case EPM_PROTOCOL_UDP:
				ndr_print_epm_rhs_udp(ndr, "udp", &r->udp);
			break;

			case EPM_PROTOCOL_IP:
				ndr_print_epm_rhs_ip(ndr, "ip", &r->ip);
			break;

			case EPM_PROTOCOL_NCADG:
				ndr_print_epm_rhs_ncadg(ndr, "ncadg", &r->ncadg);
			break;

			case EPM_PROTOCOL_NCACN:
				ndr_print_epm_rhs_ncacn(ndr, "ncacn", &r->ncacn);
			break;

			case EPM_PROTOCOL_NCALRPC:
				ndr_print_epm_rhs_ncalrpc(ndr, "ncalrpc", &r->ncalrpc);
			break;

			case EPM_PROTOCOL_UUID:
				ndr_print_epm_rhs_uuid(ndr, "uuid", &r->uuid);
			break;

			case EPM_PROTOCOL_IPX:
				ndr_print_epm_rhs_ipx(ndr, "ipx", &r->ipx);
			break;

			case EPM_PROTOCOL_SMB:
				ndr_print_epm_rhs_smb(ndr, "smb", &r->smb);
			break;

			case EPM_PROTOCOL_PIPE:
				ndr_print_epm_rhs_pipe(ndr, "pipe", &r->pipe);
			break;

			case EPM_PROTOCOL_NETBIOS:
				ndr_print_epm_rhs_netbios(ndr, "netbios", &r->netbios);
			break;

			case EPM_PROTOCOL_NETBEUI:
				ndr_print_epm_rhs_netbeui(ndr, "netbeui", &r->netbeui);
			break;

			case EPM_PROTOCOL_SPX:
				ndr_print_epm_rhs_spx(ndr, "spx", &r->spx);
			break;

			case EPM_PROTOCOL_NB_IPX:
				ndr_print_epm_rhs_nb_ipx(ndr, "nb_ipx", &r->nb_ipx);
			break;

			case EPM_PROTOCOL_DSP:
				ndr_print_epm_rhs_atalk_stream(ndr, "atalk_stream", &r->atalk_stream);
			break;

			case EPM_PROTOCOL_DDP:
				ndr_print_epm_rhs_atalk_datagram(ndr, "atalk_datagram", &r->atalk_datagram);
			break;

			case EPM_PROTOCOL_APPLETALK:
				ndr_print_epm_rhs_appletalk(ndr, "appletalk", &r->appletalk);
			break;

			case EPM_PROTOCOL_VINES_SPP:
				ndr_print_epm_rhs_vines_spp(ndr, "vines_spp", &r->vines_spp);
			break;

			case EPM_PROTOCOL_VINES_IPC:
				ndr_print_epm_rhs_vines_ipc(ndr, "vines_ipc", &r->vines_ipc);
			break;

			case EPM_PROTOCOL_STREETTALK:
				ndr_print_epm_rhs_streettalk(ndr, "streettalk", &r->streettalk);
			break;

			case EPM_PROTOCOL_HTTP:
				ndr_print_epm_rhs_http(ndr, "http", &r->http);
			break;

			case EPM_PROTOCOL_UNIX_DS:
				ndr_print_epm_rhs_unix_ds(ndr, "unix_ds", &r->unix_ds);
			break;

			case EPM_PROTOCOL_NULL:
				ndr_print_epm_rhs_null(ndr, "null", &r->null);
			break;

			default:
				ndr_print_DATA_BLOB(ndr, "unknown", r->unknown);
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

static enum ndr_err_code ndr_push_epm_lhs(struct ndr_push *ndr, int ndr_flags, const struct epm_lhs *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_epm_protocol(ndr, NDR_SCALARS, r->protocol));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->lhs_data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_lhs(struct ndr_pull *ndr, int ndr_flags, struct epm_lhs *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_epm_protocol(ndr, NDR_SCALARS, &r->protocol));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->lhs_data));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_lhs(struct ndr_print *ndr, const char *name, const struct epm_lhs *r)
{
	ndr_print_struct(ndr, name, "epm_lhs");
	ndr->depth++;
	ndr_print_epm_protocol(ndr, "protocol", r->protocol);
	ndr_print_DATA_BLOB(ndr, "lhs_data", r->lhs_data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_floor(struct ndr_push *ndr, int ndr_flags, const struct epm_floor *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_lhs;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_lhs, 2, -1));
			NDR_CHECK(ndr_push_epm_lhs(_ndr_lhs, NDR_SCALARS, &r->lhs));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_lhs, 2, -1));
		}
		{
			struct ndr_push *_ndr_rhs;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_rhs, 2, -1));
			NDR_CHECK(ndr_push_set_switch_value(_ndr_rhs, &r->rhs, r->lhs.protocol));
			NDR_CHECK(ndr_push_epm_rhs(_ndr_rhs, NDR_SCALARS, &r->rhs));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_rhs, 2, -1));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_floor(struct ndr_pull *ndr, int ndr_flags, struct epm_floor *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_lhs;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_lhs, 2, -1));
			NDR_CHECK(ndr_pull_epm_lhs(_ndr_lhs, NDR_SCALARS, &r->lhs));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_lhs, 2, -1));
		}
		{
			struct ndr_pull *_ndr_rhs;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_rhs, 2, -1));
			NDR_CHECK(ndr_pull_set_switch_value(_ndr_rhs, &r->rhs, r->lhs.protocol));
			NDR_CHECK(ndr_pull_epm_rhs(_ndr_rhs, NDR_SCALARS, &r->rhs));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_rhs, 2, -1));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_floor(struct ndr_print *ndr, const char *name, const struct epm_floor *r)
{
	ndr_print_struct(ndr, name, "epm_floor");
	ndr->depth++;
	ndr_print_epm_lhs(ndr, "lhs", &r->lhs);
	ndr_print_set_switch_value(ndr, &r->rhs, r->lhs.protocol);
	ndr_print_epm_rhs(ndr, "rhs", &r->rhs);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_tower(struct ndr_push *ndr, int ndr_flags, const struct epm_tower *r)
{
	uint32_t cntr_floors_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 2));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_floors));
			for (cntr_floors_0 = 0; cntr_floors_0 < r->num_floors; cntr_floors_0++) {
				NDR_CHECK(ndr_push_epm_floor(ndr, NDR_SCALARS, &r->floors[cntr_floors_0]));
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_tower(struct ndr_pull *ndr, int ndr_flags, struct epm_tower *r)
{
	uint32_t cntr_floors_0;
	TALLOC_CTX *_mem_save_floors_0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 2));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_floors));
			NDR_PULL_ALLOC_N(ndr, r->floors, r->num_floors);
			_mem_save_floors_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->floors, 0);
			for (cntr_floors_0 = 0; cntr_floors_0 < r->num_floors; cntr_floors_0++) {
				NDR_CHECK(ndr_pull_epm_floor(ndr, NDR_SCALARS, &r->floors[cntr_floors_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_floors_0, 0);
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_tower(struct ndr_print *ndr, const char *name, const struct epm_tower *r)
{
	uint32_t cntr_floors_0;
	ndr_print_struct(ndr, name, "epm_tower");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		ndr->depth++;
		ndr_print_uint16(ndr, "num_floors", r->num_floors);
		ndr->print(ndr, "%s: ARRAY(%d)", "floors", (int)r->num_floors);
		ndr->depth++;
		for (cntr_floors_0=0;cntr_floors_0<r->num_floors;cntr_floors_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_floors_0) != -1) {
				ndr_print_epm_floor(ndr, "floors", &r->floors[cntr_floors_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static size_t ndr_size_epm_tower(const struct epm_tower *r, struct smb_iconv_convenience *ic, int flags)
{
	flags |= LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_epm_tower, ic);
}

static enum ndr_err_code ndr_push_epm_twr_t(struct ndr_push *ndr, int ndr_flags, const struct epm_twr_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_epm_tower(&r->tower, ndr->iconv_convenience, ndr->flags)));
		{
			struct ndr_push *_ndr_tower;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_tower, 4, -1));
			NDR_CHECK(ndr_push_epm_tower(_ndr_tower, NDR_SCALARS, &r->tower));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_tower, 4, -1));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_twr_t(struct ndr_pull *ndr, int ndr_flags, struct epm_twr_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tower_length));
		{
			struct ndr_pull *_ndr_tower;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_tower, 4, -1));
			NDR_CHECK(ndr_pull_epm_tower(_ndr_tower, NDR_SCALARS, &r->tower));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_tower, 4, -1));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_twr_t(struct ndr_print *ndr, const char *name, const struct epm_twr_t *r)
{
	ndr_print_struct(ndr, name, "epm_twr_t");
	ndr->depth++;
	ndr_print_uint32(ndr, "tower_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_epm_tower(&r->tower, ndr->iconv_convenience, ndr->flags):r->tower_length);
	ndr_print_epm_tower(ndr, "tower", &r->tower);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_entry_t(struct ndr_push *ndr, int ndr_flags, const struct epm_entry_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_full_ptr(ndr, r->tower));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen(r->annotation) + 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->annotation, strlen(r->annotation) + 1, sizeof(uint8_t), CH_DOS));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tower) {
			NDR_CHECK(ndr_push_epm_twr_t(ndr, NDR_SCALARS, r->tower));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_entry_t(struct ndr_pull *ndr, int ndr_flags, struct epm_entry_t *r)
{
	uint32_t _ptr_tower;
	TALLOC_CTX *_mem_save_tower_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tower));
		if (_ptr_tower) {
			NDR_PULL_ALLOC(ndr, r->tower);
		} else {
			r->tower = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__annotation_offset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__annotation_length));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->annotation, r->__annotation_length, sizeof(uint8_t), CH_DOS));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tower) {
			_mem_save_tower_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tower, 0);
			NDR_CHECK(ndr_pull_epm_twr_t(ndr, NDR_SCALARS, r->tower));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tower_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_entry_t(struct ndr_print *ndr, const char *name, const struct epm_entry_t *r)
{
	ndr_print_struct(ndr, name, "epm_entry_t");
	ndr->depth++;
	ndr_print_GUID(ndr, "object", &r->object);
	ndr_print_ptr(ndr, "tower", r->tower);
	ndr->depth++;
	if (r->tower) {
		ndr_print_epm_twr_t(ndr, "tower", r->tower);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "__annotation_offset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->__annotation_offset);
	ndr_print_uint32(ndr, "__annotation_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->annotation) + 1:r->__annotation_length);
	ndr_print_string(ndr, "annotation", r->annotation);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpc_if_id_t(struct ndr_push *ndr, int ndr_flags, const struct rpc_if_id_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->vers_major));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->vers_minor));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpc_if_id_t(struct ndr_pull *ndr, int ndr_flags, struct rpc_if_id_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->vers_major));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->vers_minor));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpc_if_id_t(struct ndr_print *ndr, const char *name, const struct rpc_if_id_t *r)
{
	ndr_print_struct(ndr, name, "rpc_if_id_t");
	ndr->depth++;
	ndr_print_GUID(ndr, "uuid", &r->uuid);
	ndr_print_uint16(ndr, "vers_major", r->vers_major);
	ndr_print_uint16(ndr, "vers_minor", r->vers_minor);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_twr_p_t(struct ndr_push *ndr, int ndr_flags, const struct epm_twr_p_t *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_full_ptr(ndr, r->twr));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->twr) {
			NDR_CHECK(ndr_push_epm_twr_t(ndr, NDR_SCALARS, r->twr));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_twr_p_t(struct ndr_pull *ndr, int ndr_flags, struct epm_twr_p_t *r)
{
	uint32_t _ptr_twr;
	TALLOC_CTX *_mem_save_twr_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_twr));
		if (_ptr_twr) {
			NDR_PULL_ALLOC(ndr, r->twr);
		} else {
			r->twr = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->twr) {
			_mem_save_twr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->twr, 0);
			NDR_CHECK(ndr_pull_epm_twr_t(ndr, NDR_SCALARS, r->twr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_twr_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_twr_p_t(struct ndr_print *ndr, const char *name, const struct epm_twr_p_t *r)
{
	ndr_print_struct(ndr, name, "epm_twr_p_t");
	ndr->depth++;
	ndr_print_ptr(ndr, "twr", r->twr);
	ndr->depth++;
	if (r->twr) {
		ndr_print_epm_twr_t(ndr, "twr", r->twr);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_Insert(struct ndr_push *ndr, int flags, const struct epm_Insert *r)
{
	uint32_t cntr_entries_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_ents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_ents));
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_SCALARS, &r->in.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_BUFFERS, &r->in.entries[cntr_entries_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.replace));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_Insert(struct ndr_pull *ndr, int flags, struct epm_Insert *r)
{
	uint32_t cntr_entries_0;
	TALLOC_CTX *_mem_save_entries_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_ents));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.entries));
		NDR_PULL_ALLOC_N(ndr, r->in.entries, ndr_get_array_size(ndr, &r->in.entries));
		_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.entries, 0);
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_SCALARS, &r->in.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_BUFFERS, &r->in.entries[cntr_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.replace));
		if (r->in.entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.entries, r->in.num_ents));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_Insert(struct ndr_print *ndr, const char *name, int flags, const struct epm_Insert *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "epm_Insert");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_Insert");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_ents", r->in.num_ents);
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->in.num_ents);
		ndr->depth++;
		for (cntr_entries_0=0;cntr_entries_0<r->in.num_ents;cntr_entries_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_entries_0) != -1) {
				ndr_print_epm_entry_t(ndr, "entries", &r->in.entries[cntr_entries_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "replace", r->in.replace);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_Insert");
		ndr->depth++;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_Delete(struct ndr_push *ndr, int flags, const struct epm_Delete *r)
{
	uint32_t cntr_entries_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_ents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_ents));
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_SCALARS, &r->in.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_BUFFERS, &r->in.entries[cntr_entries_0]));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_Delete(struct ndr_pull *ndr, int flags, struct epm_Delete *r)
{
	uint32_t cntr_entries_0;
	TALLOC_CTX *_mem_save_entries_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_ents));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.entries));
		NDR_PULL_ALLOC_N(ndr, r->in.entries, ndr_get_array_size(ndr, &r->in.entries));
		_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.entries, 0);
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_SCALARS, &r->in.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < r->in.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_BUFFERS, &r->in.entries[cntr_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		if (r->in.entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.entries, r->in.num_ents));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_Delete(struct ndr_print *ndr, const char *name, int flags, const struct epm_Delete *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "epm_Delete");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_Delete");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_ents", r->in.num_ents);
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->in.num_ents);
		ndr->depth++;
		for (cntr_entries_0=0;cntr_entries_0<r->in.num_ents;cntr_entries_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_entries_0) != -1) {
				ndr_print_epm_entry_t(ndr, "entries", &r->in.entries[cntr_entries_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_Delete");
		ndr->depth++;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_Lookup(struct ndr_push *ndr, int flags, const struct epm_Lookup *r)
{
	uint32_t cntr_entries_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.inquiry_type));
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.object));
		if (r->in.object) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.object));
		}
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.interface_id));
		if (r->in.interface_id) {
			NDR_CHECK(ndr_push_rpc_if_id_t(ndr, NDR_SCALARS, r->in.interface_id));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.vers_option));
		if (r->in.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_ents));
	}
	if (flags & NDR_OUT) {
		if (r->out.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		if (r->out.num_ents == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_ents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_ents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_ents));
		for (cntr_entries_0 = 0; cntr_entries_0 < *r->out.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_SCALARS, &r->out.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < *r->out.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_push_epm_entry_t(ndr, NDR_BUFFERS, &r->out.entries[cntr_entries_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_Lookup(struct ndr_pull *ndr, int flags, struct epm_Lookup *r)
{
	uint32_t _ptr_object;
	uint32_t _ptr_interface_id;
	uint32_t cntr_entries_0;
	TALLOC_CTX *_mem_save_object_0;
	TALLOC_CTX *_mem_save_interface_id_0;
	TALLOC_CTX *_mem_save_entry_handle_0;
	TALLOC_CTX *_mem_save_num_ents_0;
	TALLOC_CTX *_mem_save_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.inquiry_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object));
		if (_ptr_object) {
			NDR_PULL_ALLOC(ndr, r->in.object);
		} else {
			r->in.object = NULL;
		}
		if (r->in.object) {
			_mem_save_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.object, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_interface_id));
		if (_ptr_interface_id) {
			NDR_PULL_ALLOC(ndr, r->in.interface_id);
		} else {
			r->in.interface_id = NULL;
		}
		if (r->in.interface_id) {
			_mem_save_interface_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.interface_id, 0);
			NDR_CHECK(ndr_pull_rpc_if_id_t(ndr, NDR_SCALARS, r->in.interface_id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_interface_id_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.vers_option));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_ents));
		NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		*r->out.entry_handle = *r->in.entry_handle;
		NDR_PULL_ALLOC(ndr, r->out.num_ents);
		ZERO_STRUCTP(r->out.num_ents);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_ents);
		}
		_mem_save_num_ents_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_ents, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_ents));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_ents_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.entries));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.entries));
		if (ndr_get_array_length(ndr, &r->out.entries) > ndr_get_array_size(ndr, &r->out.entries)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.entries), ndr_get_array_length(ndr, &r->out.entries));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.entries, ndr_get_array_size(ndr, &r->out.entries));
		_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.entries, 0);
		for (cntr_entries_0 = 0; cntr_entries_0 < *r->out.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_SCALARS, &r->out.entries[cntr_entries_0]));
		}
		for (cntr_entries_0 = 0; cntr_entries_0 < *r->out.num_ents; cntr_entries_0++) {
			NDR_CHECK(ndr_pull_epm_entry_t(ndr, NDR_BUFFERS, &r->out.entries[cntr_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.entries, r->in.max_ents));
		}
		if (r->out.entries) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.entries, *r->out.num_ents));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_Lookup(struct ndr_print *ndr, const char *name, int flags, const struct epm_Lookup *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "epm_Lookup");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_Lookup");
		ndr->depth++;
		ndr_print_uint32(ndr, "inquiry_type", r->in.inquiry_type);
		ndr_print_ptr(ndr, "object", r->in.object);
		ndr->depth++;
		if (r->in.object) {
			ndr_print_GUID(ndr, "object", r->in.object);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "interface_id", r->in.interface_id);
		ndr->depth++;
		if (r->in.interface_id) {
			ndr_print_rpc_if_id_t(ndr, "interface_id", r->in.interface_id);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "vers_option", r->in.vers_option);
		ndr_print_ptr(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_ents", r->in.max_ents);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_Lookup");
		ndr->depth++;
		ndr_print_ptr(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "num_ents", r->out.num_ents);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_ents", *r->out.num_ents);
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)*r->out.num_ents);
		ndr->depth++;
		for (cntr_entries_0=0;cntr_entries_0<*r->out.num_ents;cntr_entries_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_entries_0) != -1) {
				ndr_print_epm_entry_t(ndr, "entries", &r->out.entries[cntr_entries_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_epm_Map(struct ndr_push *ndr, int flags, const struct epm_Map *r)
{
	uint32_t cntr_towers_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.object));
		if (r->in.object) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.object));
		}
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.map_tower));
		if (r->in.map_tower) {
			NDR_CHECK(ndr_push_epm_twr_t(ndr, NDR_SCALARS, r->in.map_tower));
		}
		if (r->in.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_towers));
	}
	if (flags & NDR_OUT) {
		if (r->out.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		if (r->out.num_towers == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_towers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_towers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_towers));
		for (cntr_towers_0 = 0; cntr_towers_0 < *r->out.num_towers; cntr_towers_0++) {
			NDR_CHECK(ndr_push_epm_twr_p_t(ndr, NDR_SCALARS, &r->out.towers[cntr_towers_0]));
		}
		for (cntr_towers_0 = 0; cntr_towers_0 < *r->out.num_towers; cntr_towers_0++) {
			NDR_CHECK(ndr_push_epm_twr_p_t(ndr, NDR_BUFFERS, &r->out.towers[cntr_towers_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_epm_Map(struct ndr_pull *ndr, int flags, struct epm_Map *r)
{
	uint32_t _ptr_object;
	uint32_t _ptr_map_tower;
	uint32_t cntr_towers_0;
	TALLOC_CTX *_mem_save_object_0;
	TALLOC_CTX *_mem_save_map_tower_0;
	TALLOC_CTX *_mem_save_entry_handle_0;
	TALLOC_CTX *_mem_save_num_towers_0;
	TALLOC_CTX *_mem_save_towers_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object));
		if (_ptr_object) {
			NDR_PULL_ALLOC(ndr, r->in.object);
		} else {
			r->in.object = NULL;
		}
		if (r->in.object) {
			_mem_save_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.object, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_map_tower));
		if (_ptr_map_tower) {
			NDR_PULL_ALLOC(ndr, r->in.map_tower);
		} else {
			r->in.map_tower = NULL;
		}
		if (r->in.map_tower) {
			_mem_save_map_tower_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.map_tower, 0);
			NDR_CHECK(ndr_pull_epm_twr_t(ndr, NDR_SCALARS, r->in.map_tower));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_map_tower_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_towers));
		NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		*r->out.entry_handle = *r->in.entry_handle;
		NDR_PULL_ALLOC(ndr, r->out.num_towers);
		ZERO_STRUCTP(r->out.num_towers);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_towers);
		}
		_mem_save_num_towers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_towers, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_towers));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_towers_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.towers));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.towers));
		if (ndr_get_array_length(ndr, &r->out.towers) > ndr_get_array_size(ndr, &r->out.towers)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.towers), ndr_get_array_length(ndr, &r->out.towers));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.towers, ndr_get_array_size(ndr, &r->out.towers));
		_mem_save_towers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.towers, 0);
		for (cntr_towers_0 = 0; cntr_towers_0 < *r->out.num_towers; cntr_towers_0++) {
			NDR_CHECK(ndr_pull_epm_twr_p_t(ndr, NDR_SCALARS, &r->out.towers[cntr_towers_0]));
		}
		for (cntr_towers_0 = 0; cntr_towers_0 < *r->out.num_towers; cntr_towers_0++) {
			NDR_CHECK(ndr_pull_epm_twr_p_t(ndr, NDR_BUFFERS, &r->out.towers[cntr_towers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_towers_0, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.towers) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.towers, r->in.max_towers));
		}
		if (r->out.towers) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.towers, *r->out.num_towers));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_Map(struct ndr_print *ndr, const char *name, int flags, const struct epm_Map *r)
{
	uint32_t cntr_towers_0;
	ndr_print_struct(ndr, name, "epm_Map");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_Map");
		ndr->depth++;
		ndr_print_ptr(ndr, "object", r->in.object);
		ndr->depth++;
		if (r->in.object) {
			ndr_print_GUID(ndr, "object", r->in.object);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "map_tower", r->in.map_tower);
		ndr->depth++;
		if (r->in.map_tower) {
			ndr_print_epm_twr_t(ndr, "map_tower", r->in.map_tower);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "max_towers", r->in.max_towers);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_Map");
		ndr->depth++;
		ndr_print_ptr(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "num_towers", r->out.num_towers);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_towers", *r->out.num_towers);
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "towers", (int)*r->out.num_towers);
		ndr->depth++;
		for (cntr_towers_0=0;cntr_towers_0<*r->out.num_towers;cntr_towers_0++) {
			char *idx_0=NULL;
			if (asprintf(&idx_0, "[%d]", cntr_towers_0) != -1) {
				ndr_print_epm_twr_p_t(ndr, "towers", &r->out.towers[cntr_towers_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_LookupHandleFree(struct ndr_push *ndr, int flags, const struct epm_LookupHandleFree *r)
{
	if (flags & NDR_IN) {
		if (r->in.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.entry_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_LookupHandleFree(struct ndr_pull *ndr, int flags, struct epm_LookupHandleFree *r)
{
	TALLOC_CTX *_mem_save_entry_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		*r->out.entry_handle = *r->in.entry_handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.entry_handle);
		}
		_mem_save_entry_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.entry_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.entry_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_LookupHandleFree(struct ndr_print *ndr, const char *name, int flags, const struct epm_LookupHandleFree *r)
{
	ndr_print_struct(ndr, name, "epm_LookupHandleFree");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_LookupHandleFree");
		ndr->depth++;
		ndr_print_ptr(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->in.entry_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_LookupHandleFree");
		ndr->depth++;
		ndr_print_ptr(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "entry_handle", r->out.entry_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_InqObject(struct ndr_push *ndr, int flags, const struct epm_InqObject *r)
{
	if (flags & NDR_IN) {
		if (r->in.epm_object == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.epm_object));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_InqObject(struct ndr_pull *ndr, int flags, struct epm_InqObject *r)
{
	TALLOC_CTX *_mem_save_epm_object_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.epm_object);
		}
		_mem_save_epm_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.epm_object, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.epm_object));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_epm_object_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_InqObject(struct ndr_print *ndr, const char *name, int flags, const struct epm_InqObject *r)
{
	ndr_print_struct(ndr, name, "epm_InqObject");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_InqObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "epm_object", r->in.epm_object);
		ndr->depth++;
		ndr_print_GUID(ndr, "epm_object", r->in.epm_object);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_InqObject");
		ndr->depth++;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_MgmtDelete(struct ndr_push *ndr, int flags, const struct epm_MgmtDelete *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.object_speced));
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.object));
		if (r->in.object) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.object));
		}
		NDR_CHECK(ndr_push_full_ptr(ndr, r->in.tower));
		if (r->in.tower) {
			NDR_CHECK(ndr_push_epm_twr_t(ndr, NDR_SCALARS, r->in.tower));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_MgmtDelete(struct ndr_pull *ndr, int flags, struct epm_MgmtDelete *r)
{
	uint32_t _ptr_object;
	uint32_t _ptr_tower;
	TALLOC_CTX *_mem_save_object_0;
	TALLOC_CTX *_mem_save_tower_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.object_speced));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object));
		if (_ptr_object) {
			NDR_PULL_ALLOC(ndr, r->in.object);
		} else {
			r->in.object = NULL;
		}
		if (r->in.object) {
			_mem_save_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.object, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tower));
		if (_ptr_tower) {
			NDR_PULL_ALLOC(ndr, r->in.tower);
		} else {
			r->in.tower = NULL;
		}
		if (r->in.tower) {
			_mem_save_tower_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.tower, 0);
			NDR_CHECK(ndr_pull_epm_twr_t(ndr, NDR_SCALARS, r->in.tower));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tower_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_MgmtDelete(struct ndr_print *ndr, const char *name, int flags, const struct epm_MgmtDelete *r)
{
	ndr_print_struct(ndr, name, "epm_MgmtDelete");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_MgmtDelete");
		ndr->depth++;
		ndr_print_uint32(ndr, "object_speced", r->in.object_speced);
		ndr_print_ptr(ndr, "object", r->in.object);
		ndr->depth++;
		if (r->in.object) {
			ndr_print_GUID(ndr, "object", r->in.object);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "tower", r->in.tower);
		ndr->depth++;
		if (r->in.tower) {
			ndr_print_epm_twr_t(ndr, "tower", r->in.tower);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_MgmtDelete");
		ndr->depth++;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_epm_MapAuth(struct ndr_push *ndr, int flags, const struct epm_MapAuth *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_epm_MapAuth(struct ndr_pull *ndr, int flags, struct epm_MapAuth *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_epm_MapAuth(struct ndr_print *ndr, const char *name, int flags, const struct epm_MapAuth *r)
{
	ndr_print_struct(ndr, name, "epm_MapAuth");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "epm_MapAuth");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "epm_MapAuth");
		ndr->depth++;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call epmapper_calls[] = {
	{
		"epm_Insert",
		sizeof(struct epm_Insert),
		(ndr_push_flags_fn_t) ndr_push_epm_Insert,
		(ndr_pull_flags_fn_t) ndr_pull_epm_Insert,
		(ndr_print_function_t) ndr_print_epm_Insert,
		false,
	},
	{
		"epm_Delete",
		sizeof(struct epm_Delete),
		(ndr_push_flags_fn_t) ndr_push_epm_Delete,
		(ndr_pull_flags_fn_t) ndr_pull_epm_Delete,
		(ndr_print_function_t) ndr_print_epm_Delete,
		false,
	},
	{
		"epm_Lookup",
		sizeof(struct epm_Lookup),
		(ndr_push_flags_fn_t) ndr_push_epm_Lookup,
		(ndr_pull_flags_fn_t) ndr_pull_epm_Lookup,
		(ndr_print_function_t) ndr_print_epm_Lookup,
		false,
	},
	{
		"epm_Map",
		sizeof(struct epm_Map),
		(ndr_push_flags_fn_t) ndr_push_epm_Map,
		(ndr_pull_flags_fn_t) ndr_pull_epm_Map,
		(ndr_print_function_t) ndr_print_epm_Map,
		false,
	},
	{
		"epm_LookupHandleFree",
		sizeof(struct epm_LookupHandleFree),
		(ndr_push_flags_fn_t) ndr_push_epm_LookupHandleFree,
		(ndr_pull_flags_fn_t) ndr_pull_epm_LookupHandleFree,
		(ndr_print_function_t) ndr_print_epm_LookupHandleFree,
		false,
	},
	{
		"epm_InqObject",
		sizeof(struct epm_InqObject),
		(ndr_push_flags_fn_t) ndr_push_epm_InqObject,
		(ndr_pull_flags_fn_t) ndr_pull_epm_InqObject,
		(ndr_print_function_t) ndr_print_epm_InqObject,
		false,
	},
	{
		"epm_MgmtDelete",
		sizeof(struct epm_MgmtDelete),
		(ndr_push_flags_fn_t) ndr_push_epm_MgmtDelete,
		(ndr_pull_flags_fn_t) ndr_pull_epm_MgmtDelete,
		(ndr_print_function_t) ndr_print_epm_MgmtDelete,
		false,
	},
	{
		"epm_MapAuth",
		sizeof(struct epm_MapAuth),
		(ndr_push_flags_fn_t) ndr_push_epm_MapAuth,
		(ndr_pull_flags_fn_t) ndr_pull_epm_MapAuth,
		(ndr_print_function_t) ndr_print_epm_MapAuth,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const epmapper_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\epmapper]", 
	"ncacn_ip_tcp:[135]", 
	"ncalrpc:[EPMAPPER]", 
};

static const struct ndr_interface_string_array epmapper_endpoints = {
	.count	= 3,
	.names	= epmapper_endpoint_strings
};

static const char * const epmapper_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array epmapper_authservices = {
	.count	= 1,
	.names	= epmapper_authservice_strings
};


const struct ndr_interface_table ndr_table_epmapper = {
	.name		= "epmapper",
	.syntax_id	= {
		{0xe1af8308,0x5d1f,0x11c9,{0x91,0xa4},{0x08,0x00,0x2b,0x14,0xa0,0xfa}},
		NDR_EPMAPPER_VERSION
	},
	.helpstring	= NDR_EPMAPPER_HELPSTRING,
	.num_calls	= 8,
	.calls		= epmapper_calls,
	.endpoints	= &epmapper_endpoints,
	.authservices	= &epmapper_authservices
};

