/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOG_DRIVER_H_
#define _GB2_LOG_DRIVER_H_

#include <core_api/Log.h>
#include <core_services/LogSettings.h>

namespace GB2 {

class LogDriver : public QObject {
    Q_OBJECT
public:
    LogDriver();
    virtual ~LogDriver() {}

    bool print_to_console;
    LogSettings* getSettings() {return &settings;}

private slots:
    void sl_onMessage(const LogMessage& msg);
    QString prepareText(const LogMessage& msg) const;

private:
    LogSettings settings;
};

} //namespace

#endif
