/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __ATI_STREAM_GPU_REGISTRY_H__
#define __ATI_STREAM_GPU_REGISTRY_H__

#include <QtCore/QHash>
#include "core_api.h"

namespace GB2 {

typedef int AtiStreamGpuId;

#define ATI_STREAM_GPU_REGISTRY_SETTINGS "/ati_stream_gpu_registry"
//stores settings for concrete GPU. The key for appending - textual representation of AtiStreamGpuId
#define ATISTREAM_GPU_REGISTRY_SETTINGS_GPU_SPECIFIC "/ati_stream_gpu_registry/gpu_specific"
#define ATISTREAM_GPU_SETTINGS_ENABLED "/enabled"

class GB2_COREAPI_EXPORT AtiStreamGpuModel {
public:
    AtiStreamGpuModel( const QString & _name, const AtiStreamGpuId & _id, quint64 _globalMemorySizeBytes, bool _enabled  = true) :
      name(_name), id(_id), globalMemorySizeBytes(_globalMemorySizeBytes), enabled(_enabled), acquired(false) {};

    QString getName() const {return name;}
    AtiStreamGpuId getId() const {return id;}
    quint64 getGlobalMemorySizeBytes() const {return globalMemorySizeBytes;}

    //TODO: BUG-816.
    //Now we can use only default GPU (with id 0)
//    bool isEnabled() const { return enabled;}
    bool isEnabled() const { return (id ? false : enabled); } 
//    void setEnabled(bool b) {enabled = b;}
    void setEnabled(bool b){if(id && b){assert(false); enabled=false; return;} enabled = b;}

    bool isAcquired() const {return acquired;}
    void setAcquired( bool a ) {acquired = a;}

    bool isReady() {return !isAcquired() && isEnabled(); }
private:
    //TODO: add another ati stream device properties
	QString name;
    AtiStreamGpuId id;
    quint64 globalMemorySizeBytes;
    bool enabled;
    bool acquired;
};

class GB2_COREAPI_EXPORT AtiStreamGpuRegistry {
public:
    ~AtiStreamGpuRegistry();

    void registerAtiStreamGpu( AtiStreamGpuModel * gpu );
    AtiStreamGpuModel * getGpuById( AtiStreamGpuId id ) const;
    QList<AtiStreamGpuModel*> getRegisteredGpus() const;

    AtiStreamGpuModel * getAnyEnabledGpu() const;

    AtiStreamGpuModel * acquireAnyReadyGpu();

    bool empty() const { return gpus.empty(); }

private:
    void saveGpusSettings() const;
    QHash< AtiStreamGpuId, AtiStreamGpuModel * > gpus;  
};

} //namespace

#endif //__ATI_STREAM_GPU_REGISTRY_H__
