/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MainWindow.h"

namespace GB2 {

//thread safe design in main thread model
static int windowCounter = 0;

MWMDIWindow::MWMDIWindow(const QString& _windowName)
: windowName(_windowName), windowId(++windowCounter) 
{ 
    setWindowTitle(windowName);
}

void MainWindow::setupToEngine(QScriptEngine *engine)
{
    MWMenuManager::setupToEngine(engine);
    qScriptRegisterMetaType(engine, toScriptValue, fromScriptValue);
};
QScriptValue MainWindow::toScriptValue(QScriptEngine *engine, MainWindow* const &in)
{ 
    return engine->newQObject(in); 
}

void MainWindow::fromScriptValue(const QScriptValue &object, MainWindow* &out) 
{
    out = qobject_cast<MainWindow*>(object.toQObject()); 
}

void MWMenuManager::setupToEngine(QScriptEngine *engine)
{
    qScriptRegisterMetaType(engine, toScriptValue, fromScriptValue);
};
QScriptValue MWMenuManager::toScriptValue(QScriptEngine *engine, MWMenuManager* const &in)
{ 
    return engine->newQObject(in); 
}

void MWMenuManager::fromScriptValue(const QScriptValue &object, MWMenuManager* &out) 
{
    out = qobject_cast<MWMenuManager*>(object.toQObject()); 
}

} //namespace
