/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_VIEW_H_
#define _GB2_PROJECT_VIEW_H_

#include "PluginModel.h"
#include "ServiceTypes.h"
#include "SelectionModel.h"
#include "DocumentModel.h"

class QMenu;
class QAction;

namespace GB2 {

class DocumentSelection;
class GObjectSelection;

class GB2_COREAPI_EXPORT ProjectView : public Service {
	Q_OBJECT
public:
    ProjectView(const QString& sname, const QString& sdesc) 
		: Service(Service_ProjectView, sname, sdesc, QList<ServiceType>()<<Service_Project)  
	{
    }

	virtual const DocumentSelection* getDocumentSelection() const = 0;
	
	virtual const GObjectSelection* getGObjectSelection() const = 0;

//	virtual QAction* getAddNewDocumentAction() const = 0;
	
	virtual QAction* getAddExistingDocumentAction() const = 0;

    virtual void highlightItem(Document*) = 0;

signals:
	void si_onDocTreePopupMenuRequested(QMenu& m);
};

}//namespace
#endif
