/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_ALG_REGISTRY_H_
#define _GB2_SMITH_WATERMAN_ALG_REGISTRY_H_

#include <QList>
#include <QString>
#include <QMutex>
#include <QObject>

#include <core_api/core_api.h>
#include <util_smith_waterman/SmithWatermanTaskFactory.h>

namespace GB2 {

struct NamedSmithWatermanTaskFactory {
	QString alg_id;
	SmithWatermanTaskFactory* alg;
};

class GB2_COREAPI_EXPORT SmithWatermanTaskFactoryRegistry: public QObject {
	Q_OBJECT
public:	
	SmithWatermanTaskFactoryRegistry(QObject* pOwn = 0);
	~SmithWatermanTaskFactoryRegistry();

	bool registerAlgorithm(SmithWatermanTaskFactory* alg, const QString& alg_id);
    bool hadRegistered(const QString& alg_id);
	SmithWatermanTaskFactory* getAlgorithm(const QString& alg_id);
	QStringList getListAlgNames();
private:
	QMutex mutex;
	QList<NamedSmithWatermanTaskFactory> alg_list;

	SmithWatermanTaskFactoryRegistry(const SmithWatermanTaskFactoryRegistry& m);
	SmithWatermanTaskFactoryRegistry& operator=(const SmithWatermanTaskFactoryRegistry& m);

	QList<NamedSmithWatermanTaskFactory>::iterator findAlgorithm(const QString& alg_id);
};

} // namespace

#endif
