/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FASTQ_FORMAT_H_
#define _GB2_FASTQ_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>
#include <QtCore/QStringList>

namespace GB2 {

class IOAdapter;

class GB2_COREAPI_EXPORT FastqFormat : public DocumentFormat {
    Q_OBJECT
public:
    FastqFormat(QObject* p) : DocumentFormat(p), fn(tr("FASTQ")) {}

    virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::FASTQ;}
    virtual const QString& getFormatName() const {return fn;}
    virtual QStringList getSupportedDocumentFileExtensions() {return QStringList("fastq");}

    virtual Document* loadExistingDocument(IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs);
    virtual Document* loadExistingDocument( IOAdapter* io, TaskStateInfo& ti, const QVariantMap& formatSettings );

    virtual bool isObjectOpSupported(const Document* d , DocumentFormat::DocObjectOp op, GObjectType t) const;
    virtual bool isDataFormatSupported(const char* data, int size) const;
    virtual bool checkConstraints(const DocumentFormatConstraints& c) const;
private:
    QString fn;
};

}//namespace

#endif
