/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UNLOADED_OBJECT_H_
#define _GB2_UNLOADED_OBJECT_H_

#include <core_api/GObject.h>
#include "GObjectTypes.h"

namespace GB2 {

class GB2_COREAPI_EXPORT UnloadedObjectInfo {
public:
    UnloadedObjectInfo(GObject* obj = NULL);
    QString         name;
    GObjectType     type;
    QVariantMap     hints;
    
    bool isValid() const {return !name.isEmpty() && !type.isEmpty() && type != GObjectTypes::UNLOADED;}
};

class GB2_COREAPI_EXPORT UnloadedObject: public GObject {
    Q_OBJECT
public:
    UnloadedObject(const QString& objectName, const GObjectType& loadedObjectType, const QVariantMap& hintsMap = QVariantMap());
    UnloadedObject(const UnloadedObjectInfo& info);

    virtual GObject* clone() const;
    
    GObjectType getLoadedObjectType() const {return loadedObjectType;}
    void setLoadedObjectType(const GObjectType& lot);

protected:
    GObjectType loadedObjectType;
};

}//namespace

#endif
