/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_G_SCRIPT_RUNNER_
#define _GB2_G_SCRIPT_RUNNER_

#include <QObject>
#include <QStringList>
#include <QtScript>
#include <core_api/core_api.h>
#include <core_api/Task.h>
#include <core_api/PluginModel.h>

namespace GB2{

class GB2_COREAPI_EXPORT GScript: public QObject {
    public:
        QString text;
        QStringList    bindingsList;
        bool separateThreads;
        bool exitOnException;
        bool exitOnEnding;

    };


class GB2_COREAPI_EXPORT GScriptRunner: public QObject {
    Q_OBJECT
public:
    GScriptRunner(QString scriptFileName);

    void runScript(QString scriptFileName);
    Task* createScriptTask(GScript* script); 

    static GScript* parseScriptFile(QString scriptFileName);
    static bool setupBindings(QScriptEngine *engine,QString bindingName);
public slots:
    void sl_runSerialScript();
private slots:    
    void sl_runScript();
    void sl_checkStateScriptEngine();

private:
    QString         scriptFileName;
    QScriptEngine*  runEngine;
    GScript*        script;
    QTimer*         checkStateTimer;
};

class GB2_COREAPI_EXPORT GScriptTask: public Task {
    Q_OBJECT
public:
    GScriptTask(GScript* _script);
    void prepare();
    void run();
    ReportResult report();

private:
    QStringList*    bindingsList;
    QScriptEngine*  runEngine;
    QString         scriptFileName;
    GScript*        script;
};

}//namespace
#endif
