/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_PART_TO_SEQUENCE_CONTROLLER_H_
#define _GB2_ADD_PART_TO_SEQUENCE_CONTROLLER_H_

#include "ui/ui_AddPartToSequenceDialog.h"

#include <core_api/LRegion.h>
#include <util_gui/SeqPasterWidgetController.h>
#include <util_gui/DialogUtils.h>
#include <util_tasks/AddPartToSequenceTask.h>


namespace GB2{

class GB2_COREAPI_EXPORT AddPartToSequenceDialogController : public QDialog, public Ui_AddPartToSequenceDialog {
    Q_OBJECT
public:
    AddPartToSequenceDialogController(LRegion _source, DNAAlphabet *_alph, QWidget *p = NULL, int _pos = 0);
    virtual void accept();

    DNASequence getSequenceToInsert(){return w->getSequence();};
    bool modifyCurrentDocument(){return !saveToAnotherBox->isChecked();};
    QString getNewDocumentPath(){return filepathEdit->text();};
    int getPosToInsert(){return pos;};
    AddPartToSequenceTask::AnnotationStrategyForAdd getStrategy();
    bool mergeAnnotations(){return (mergeAnnotationsBox->isChecked() && !modifyCurrentDocument());};
    DocumentFormatId getDocumentFormatId(){return formatBox->itemData(formatBox->currentIndex()).toString();};
private slots:
    void sl_browseButtonClicked();
    void sl_indexChanged(int);
    void sl_mergeAnnotationsToggled(bool);

private:
    void addSeqpasterWidget();

    QString filter;
    int pos;
    LRegion source;
    SeqPasterWidgetController *w;
};

}//ns

#endif

