/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BASE_DOC_FORMAT_CONFIG_H_
#define _GB2_BASE_DOC_FORMAT_CONFIG_H_

#include <core_api/core_api.h>
#include <core_api/DocumentFormatConfigurators.h>

namespace GB2 {

class GB2_COREAPI_EXPORT BaseDocumentFormatConfigurators  {
public:
    static void initBuiltInConfigurators();

    static void loadDefaultFormatSettings(const DocumentFormatId& format, QVariantMap& formatSettings);
    static void saveDefaultFormatSettings(const DocumentFormatId& format, const QVariantMap& formatSettings);

};

class GB2_COREAPI_EXPORT MultiPartDocFormatConfigurator : public DocumentFormatConfigurator {
    Q_OBJECT
public:
    MultiPartDocFormatConfigurator(DocumentFormatId id) : DocumentFormatConfigurator(id) {};

    virtual void configure(QVariantMap& info);


};


}//namespace
#endif
