/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CopyDocumentDialogController.h"

#include "util_gui/DialogUtils.h"

#include <core_services/AppContextImpl.h>
#include <core_api/GObject.h>

#include <QFileDialog>
#include <QFileInfo>
#include <QDir>
#include <QObject>

namespace GB2{

CopyDocumentDialogController::CopyDocumentDialogController(const QString &_filter, Document* d, QWidget *p)
: QDialog(p), filter(_filter) {
    setupUi(this);
    QFileInfo fi(d->getURL());
    fileName = (fi.absoluteDir()).absolutePath() + "/" + fi.baseName() + "_copy." + fi.suffix();

    fileNameEdit->setText(fileName);

    DocumentFormatRegistry *dfr =  AppContext::getDocumentFormatRegistry();
    ids = dfr->getRegisteredFormats();
    QList<DocumentFormat*> allWritableFormats;
    foreach(DocumentFormatId id, ids){
        DocumentFormat *format = dfr->getFormatById(id);
        DocumentFormatConstraints c;
        c.mustSupportWrite = true;
        if(format->checkConstraints(c)){
            allWritableFormats.append(format);
        }
    }
    
    QString selected;
    foreach(DocumentFormat *f ,allWritableFormats){
        bool isWritableData = false;
        foreach(GObject *gobj, d->getObjects()){
            if(f->isObjectOpSupported(d, DocumentFormat::DocObjectOp_Add, gobj->getGObjectType())){
                isWritableData = true;
            }
        }
        if(isWritableData){
            QIcon i;
            formatCombo->addItem(i, f->getFormatName());
            selected = f->getFormatName();
        }
    }
    formatCombo->setEditable(false);

    addToProjCheck->setChecked(true);

    connect(formatCombo, SIGNAL(currentIndexChanged(const QString &)), SLOT(sl_currentIndexChanged(const QString &)));
    connect(browseButton, SIGNAL(clicked()), SLOT(sl_browseButtonClicked()));
    connect(fileNameEdit, SIGNAL(textChanged(const QString&)), SLOT(sl_textChanged(const QString&)));

    sl_currentIndexChanged(formatCombo->currentText());
}

void CopyDocumentDialogController::accept(){
    QDialog::accept();
}

void CopyDocumentDialogController::reject(){
    QDialog::reject();
}

void CopyDocumentDialogController::sl_browseButtonClicked(){
    LastOpenDirHelper h;
    QString newPath = QFileDialog::getSaveFileName(this, tr("Select file to save..."), h.dir, filter);
    if(!newPath.isEmpty()){
        fileNameEdit->setText(newPath);
    }
}

void CopyDocumentDialogController::sl_textChanged(const QString& newText){
    fileName = newText;
}

void CopyDocumentDialogController::sl_currentIndexChanged(const QString & text){
    DocumentFormatRegistryImpl dfr;
    foreach(DocumentFormatId id, ids){
        DocumentFormat *df = dfr.getFormatById(id);
        QString selectedFormatName = df->getFormatName();
        if(selectedFormatName == text){
            selectedId = id;
            filter = DialogUtils::prepareDocumentsFileFilter(selectedId, false);
            QString extension = (df->getSupportedDocumentFileExtensions()).first();
            QFileInfo fi(fileName);
            int sufLen = fileName.length() - fi.suffix().length();
            fileNameEdit->setText(fileName.left(sufLen).append(extension));
            return;
        }
    }
}

}//ns
