/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateAnnotationDialog.h"
#include "CreateAnnotationWidgetController.h"

#include <core_api/AppContext.h>
#include <core_api/DocumentFormats.h>
#include <core_api/IOAdapter.h>
#include <core_api/ProjectModel.h>
#include <gobjects/GObjectRelationRoles.h>


#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>

namespace GB2 {

CreateAnnotationDialog::CreateAnnotationDialog(QWidget* p, CreateAnnotationModel& m) : QDialog(p), model(m){
    c = new CreateAnnotationWidgetController(m, this);
    
    this->setObjectName("new_annotation_dialog");

    QHBoxLayout* hl = new QHBoxLayout();
    hl->addStretch(1);
    createButton = new QPushButton(tr("create_button"), this);
    createButton->setObjectName("create_button");
    hl->addWidget(createButton);
    cancelButton = new QPushButton(tr("cancel_button"), this);
    cancelButton->setObjectName("cancel_button");
    hl->addWidget(cancelButton);

    QVBoxLayout* vl = new QVBoxLayout();
    vl->setObjectName("new_annotation_dialog_layout");
//    vl->addWidget(new QLabel("header", this));
    vl->addWidget(c->getWidget());
    vl->addLayout(hl);
    vl->setSizeConstraint(QLayout::SetFixedSize);
    setLayout(vl);

    connect(createButton, SIGNAL(clicked(bool)), SLOT(sl_onCreateClicked(bool)));
    connect(cancelButton, SIGNAL(clicked(bool)), SLOT(sl_onCancelClicked(bool)));

    c->annotationNameEdit->setFocus();
    setWindowTitle(tr("Create annotation"));
}

void CreateAnnotationDialog::sl_onCreateClicked(bool) {
    QString err = c->validate();
    if (!err.isEmpty()) {
        QMessageBox::warning(this, tr("invalid_state_info"), err);
        return;
    } 
    c->prepareAnnotationObject();
    model = c->getModel();
    accept();
}

void CreateAnnotationDialog::sl_onCancelClicked(bool) {
    reject();
}



} // namespace
