/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SCALE_BAR_H_
#define _GB2_SCALE_BAR_H_

#include <core_api/core_api.h>

#include <QtGui/QSlider>
#include <QtGui/QToolButton>

namespace GB2 {

class GB2_COREAPI_EXPORT ScaleBar : public QWidget {
	Q_OBJECT
public:
    ScaleBar(QWidget* parent = 0);
    QSlider* slider() const {return scaleBar;}
    int value() const {return scaleBar->value();}
    void setValue(int v) {scaleBar->setValue(v);}

signals:
    void valueChanged(int);

private slots:
	void sl_minusButtonClicked();
	void sl_plusButtonClicked();

protected:

    QSlider*					scaleBar;
	QToolButton*				minusButton;
	QToolButton*				plusButton;
};

} // namespace

#endif
