/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADV_SYNC_VIEW_MANAGER_H_
#define _GB2_ADV_SYNC_VIEW_MANAGER_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QAction>
#include <QtGui/QMenu>
#include <QtGui/QToolBar>
#include <QtGui/QToolButton>

namespace GB2 {

class AnnotatedDNAView;
class ADVSequenceWidget;
class ADVSingleSequenceWidget;

//Support for synchronous operation for ADVSingleSequenceViews: sync& lock scale, toggle visibility
class ADVSyncViewManager : public QObject {
    Q_OBJECT
public:
    ADVSyncViewManager(AnnotatedDNAView* v);
    ~ADVSyncViewManager();

    void updateToolbar1(QToolBar* tb);
    void updateToolbar2(QToolBar* tb);
private slots:
    void sl_rangeChanged();
    void sl_sequenceWidgetAdded(ADVSequenceWidget* w);
    void sl_sequenceWidgetRemoved(ADVSequenceWidget* w);

    void sl_lock();
    void sl_sync();

    void sl_toggleVisualMode();
    void updateVisualMode();

private:
    enum SyncMode {
        SyncMode_Start,
        SyncMode_SeqSel,
        SyncMode_AnnSel
    };

    void sync(bool lock, SyncMode mode);

    int offsetBySeqSel(ADVSingleSequenceWidget* w) const;
    int offsetByAnnSel(ADVSingleSequenceWidget* w) const;

    SyncMode detectSyncMode() const;
    int findSelectedAnnotationPos(ADVSingleSequenceWidget* w) const;

    void unlock();
    void updateEnabledState();
    

    QList<ADVSingleSequenceWidget*> getViewsFromADV() const;

    AnnotatedDNAView*                   adv;

    QAction*                            lockByStartPosAction;
    QAction*                            lockBySeqSelAction;
    QAction*                            lockByAnnSelAction;
    QAction*                            syncByStartPosAction;
    QAction*                            syncBySeqSelAction;
    QAction*                            syncByAnnSelAction;

    QToolButton*                        syncButton;
    QToolButton*                        lockButton;
    QMenu*                              syncMenu;
    QMenu*                              lockMenu;

    QAction*                            syncButtonTBAction;
    QAction*                            lockButtonTBAction;

    bool                                recursion;
    QList<ADVSingleSequenceWidget*>     views;

    // visual mode vars
    QAction*                            toggleViewButtonAction;
    QToolButton*                        toggleViewButton;
    QMenu*                              toggleViewButtonMenu;
    QAction*                            toggleAllAction;
    QAction*                            togglePanAction;
    QAction*                            toggleDetAction;
};

} //namespace
#endif
