/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_SAVE_DOCUMENT_STREAMING_TASK_H_
#define _GB2_SAVE_DOCUMENT_STREAMING_TASK_H_

#include <core_api/Task.h>

namespace GB2 {

class Document;
class StateLock;
class IOAdapter;

class GB2_COREAPI_EXPORT SaveDocumentStreamingTask : public Task {
    Q_OBJECT
public:
    // io - opened io adapter
    SaveDocumentStreamingTask( Document* doc, IOAdapter* io );
    ~SaveDocumentStreamingTask();
    
    virtual void prepare();
    
    virtual void run();
    
    ReportResult report();
    
    Document* getDocument() const;
    
private:
    StateLock*  lock;
    Document*   doc;
    IOAdapter*  io;
    
}; // SaveDocumentStreamingTask

} // GB2

#endif // _GB2_SAVE_DOCUMENT_STREAMING_TASK_H_
