/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_TRANSPORT_H_
#define _GB2_WORKFLOW_TRANSPORT_H_

#include <workflow/Datatype.h>

#include <QtCore/QVariant>

namespace GB2 {

namespace Workflow {

class Message;
class CommunicationChannel;

class WCOREAPI_EXPORT Message {
public:
    Message(DataTypePtr _t, const QVariant& d) : id(nextid()), t(_t), data(d) {}
    int getId() const {return id;}
    DataTypePtr getType() const {return t;}
    QVariant getData() const {return data;}
private:
    int id;
    DataTypePtr t;
    QVariant data;
    static int nextid();
};

class WCOREAPI_EXPORT CommunicationChannel {
public:
    virtual Message get() = 0;
    virtual void put(const Message& m) = 0;
    virtual int hasMessage() const = 0;
    virtual int hasRoom(const DataType* t = NULL) const = 0;
    virtual bool isEnded() const = 0;
    virtual void setEnded() = 0;
    virtual ~CommunicationChannel() {};
    virtual int capacity() const = 0;
    virtual void setCapacity(int) = 0;

//    virtual void setConverter(DataTypePtr from, DataTypePtr to, DataTypeConvertion* dc) = 0;
};

class WCOREAPI_EXPORT CommunicationSubject {
public:
    virtual bool addCommunication(const QString& portId, CommunicationChannel* ch) = 0;
    virtual CommunicationChannel* getCommunication(const QString& portId) = 0;
    virtual ~CommunicationSubject() {};
    //virtual QList<CommunicationChannel*> getCommunications() = 0;
};

}//Workflow namespace
}//GB2 namespace


#endif
