/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_MAP_EDITOR_H_
#define _GB2_WORKFLOW_MAP_EDITOR_H_

#include <workflow/ConfigurationEditor.h>

class QTableWidget;
class QTextEdit;

namespace GB2 {

class WCOREAPI_EXPORT TypeMapEditor : public QObject, public ConfigurationEditor {
    Q_OBJECT
public:
    TypeMapEditor(Configuration* cfg, const QString& prop, DataTypePtr from, DataTypePtr to);
    virtual ~TypeMapEditor() {}
    virtual QWidget* getWidget();
    virtual void commit();
private slots:
    void sl_showDoc();
protected:
    bool isInfoMode() const {return from == to;}
    virtual QWidget* createGUI(DataTypePtr from, DataTypePtr to);
protected:
    Configuration* cfg;
    const QString propertyName;
    DataTypePtr from, to;
    QTableWidget* table;
    QTextEdit* doc;
};

class WCOREAPI_EXPORT DescriptorListDelegate : public QItemDelegate
{
    Q_OBJECT
public:
    DescriptorListDelegate(QObject *parent = 0) : QItemDelegate(parent) {}
    virtual ~DescriptorListDelegate() {}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
        const QModelIndex &index) const;

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
        const QModelIndex &index) const;

    //void updateEditorGeometry(QWidget *editor,
      //  const QStyleOptionViewItem &option, const QModelIndex &index) const;
};

namespace Workflow {
    class BusPort;
}

class WCOREAPI_EXPORT BusPortEditor : public TypeMapEditor {
    Q_OBJECT
public:
    BusPortEditor(Workflow::BusPort* p);
    virtual ~BusPortEditor() {}
protected:
    virtual QWidget* createGUI(DataTypePtr from, DataTypePtr to);
    Workflow::BusPort* port;
private slots:
    void handleDataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
};

}//namespace GB2

#endif
