/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef QTSCRIPTSHELL_QSTANDARDITEM_H
#define QTSCRIPTSHELL_QSTANDARDITEM_H

#include <qstandarditemmodel.h>

#include <QtScript/qscriptvalue.h>

class QtScriptShell_QStandardItem : public QStandardItem
{
public:
    QtScriptShell_QStandardItem();
    QtScriptShell_QStandardItem(const QIcon&  icon, const QString&  text);
    QtScriptShell_QStandardItem(const QStandardItem&  other);
    QtScriptShell_QStandardItem(const QString&  text);
    QtScriptShell_QStandardItem(int  rows, int  columns = 1);
    ~QtScriptShell_QStandardItem();

    QStandardItem*  clone() const;
    QVariant  data(int  role = Qt::UserRole + 1) const;
    void setData(const QVariant&  value, int  role = Qt::UserRole + 1);
    int  type() const;

    QScriptValue __qtscript_self;
};

#endif // QTSCRIPTSHELL_QSTANDARDITEM_H
