/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AnnotatorPlugin.h"
#include "CollocationsDialogController.h"

#include "AnnotatorTests.h"

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVUtils.h>
#include <gobjects/AnnotationTableObject.h>

#include <QtGui/QMenu>
#include <QtGui/QMessageBox>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>

#include <core_api/AppContext.h>

#include "CollocationWorker.h"

namespace GB2 {


extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    AnnotatorPlugin * plug = new AnnotatorPlugin();
	return plug;
}

AnnotatorPlugin::AnnotatorPlugin() : Plugin(tr("dna_annotator_plugin"), tr("dna_annotator_plugin_desc")), viewCtx(NULL)
{
    if (AppContext::getMainWindow()) {
        viewCtx = new AnnotatorViewContext(this);
        viewCtx->init();
    }
    LocalWorkflow::CollocationWorkerFactory::init();

	//Annotator test
	GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
	XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
	assert(xmlTestFormat!=NULL);
	
    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = AnnotatorTests::createTestFactories();


	foreach(XMLTestFactory* f, l->qlist) { 
		bool res = xmlTestFormat->registerTestFactory(f);
		Q_UNUSED(res);
		assert(res);
	}
}

AnnotatorViewContext::AnnotatorViewContext(QObject* p) : GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID) {

}

void AnnotatorViewContext::initViewContext(GObjectView* v) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":annotator/images/regions.png"), tr("find_annotation_collocations"), 30);
    connect(a, SIGNAL(triggered()), SLOT(sl_showCollocationDialog()));
}

void AnnotatorViewContext::sl_showCollocationDialog() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    assert(av);

    QSet<QString> allNames;

    foreach(AnnotationTableObject* ao, av->getAnnotationObjects()) {
        foreach(Annotation* a, ao->getAnnotations()) {
            allNames.insert(a->getAnnotationName());
        }
    }
    if (allNames.isEmpty()) {
        QMessageBox::warning(av->getWidget(), tr("warning"),tr("no_annotations_found"));
        return;
    }
        
    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    if (seqCtx == NULL) { 
        return;
    }
    CollocationsDialogController d(allNames.toList(), seqCtx);
    d.exec();
}

QList<XMLTestFactory*> AnnotatorTests::createTestFactories() {
	QList<XMLTestFactory*> res;
	res.append(GTest_AnnotatorSearch::createFactory());
	return res;
}

}//namespace
