/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtOpenGL>
#include <time.h>


#include <datatype/BioStruct3D.h>
#include <core_api/Log.h>
#include <document_format/PDBFormat.h>

#include "GraphicUtils.h"
#include "BioStruct3DGLWidget.h"
#include "BioStruct3DColorScheme.h"
#include "BallAndStickGLRenderer.h"


namespace GB2 { 

const QString BallAndStickGLRenderer::ID(QObject::tr("Ball-and-stick"));
unsigned int DisplayLists::atomDL = -1;


void BallAndStickGLRenderer::drawBioStruct3D(  )
{

    modelIndexList = glWidget->getActiveModelIndexList();
    drawBonds(colorScheme);
    drawAtoms(colorScheme);

}


void BallAndStickGLRenderer::drawAtoms( const BioStruct3DColorScheme* colorScheme )
{
	
    // Draw atoms as spheres

    foreach (const SharedMolecule mol, bioStruct.moleculeMap) {
        foreach (int index, modelIndexList) {
            const Molecule3DModel& model = mol->models.at(index);
            foreach(const SharedAtom atom, model.atoms) {
                Vector3D pos = atom->coord3d;
		        Color4f atomColor = colorScheme->getAtomColor(atom);
		        glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, atomColor.getConstData());
 		        glPushMatrix();
 		        glTranslatef(pos.x, pos.y, pos.z);
                glCallList(atomDL);
                glPopMatrix();
	        }
        }
    }

}

void BallAndStickGLRenderer::drawBonds( const BioStruct3DColorScheme* colorScheme )
{
    GLUquadricObj* pObj = gluNewQuadric();
    float bondThickness = 0.15f;
    gluQuadricNormals(pObj, GLU_SMOOTH);
    foreach (const SharedMolecule mol, bioStruct.moleculeMap) {
        foreach (int index, modelIndexList) {
            const Molecule3DModel& model = mol->models.at(index);
            foreach (Bond bond, model.bonds) {
                const SharedAtom a1 = bond.getAtom1();
                const SharedAtom a2 = bond.getAtom2();
                Vector3D middle = (a1->coord3d + a2->coord3d) / 2;
                glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, colorScheme->getAtomColor(a1).getConstData());
                glDrawCylinder(pObj, a1->coord3d, middle, bondThickness);
                glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, colorScheme->getAtomColor(a2).getConstData());
                glDrawCylinder(pObj, middle, a2->coord3d, bondThickness);
            }
        }
    
    }
}

BallAndStickGLRenderer::BallAndStickGLRenderer( const BioStruct3D& struc, const BioStruct3DColorScheme* s )
    : BioStruct3DGLRenderer(struc,s)
{
     atomDL = DisplayLists::getAtomDisplayList();
}
} //namespace
