/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ENZYMES_IO_H_
#define _GB2_ENZYMES_IO_H_

#include "EnzymeModel.h"

#include <core_api/Task.h>

#include <QtCore/QObject>
#include <QtCore/QList>

namespace GB2 {

class IOAdapterFactory;

enum EnzymeFileFormat {
    EnzymeFileFormat_Unknown,
    EnzymeFileFormat_Bairoch
};

class EnzymesIO : public QObject {
    Q_OBJECT
public:
    static QList<SEnzymeData> readEnzymes(const QString& url, TaskStateInfo& ti);
    static QString getFileDialogFilter();

    static SEnzymeData findEnzymeById(const QString& id, const QList<SEnzymeData>& enzymes);

private:
    static EnzymeFileFormat detectFileFormat(const QString& url);
    static QList<SEnzymeData> readBairochFile(const QString& url, IOAdapterFactory* iof, TaskStateInfo& ti);
};

class LoadEnzymeFileTask : public Task {
    Q_OBJECT
public:
    LoadEnzymeFileTask(const QString& url);
    void run();
    void cleanup() {enzymes.clear();}

    QString url;
    QList<SEnzymeData> enzymes;
};

} //namespace

#endif
