/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FIND_ENZYMES_TASK_H_
#define _GB2_FIND_ENZYMES_TASK_H_

#include "EnzymeModel.h"
#include "FindEnzymesAlgorithm.h"

#include <limits>

#include <core_api/Task.h>
#include <core_api/LRegion.h>
#include <datatype/DNASequence.h>
#include <util_tasks/SequenceWalkerTask.h>

#include <gobjects/AnnotationTableObject.h>

#include <QtCore/QObject>
#include <QtCore/QList>
#include <QtCore/QMutex>

namespace GB2 {

class FindEnzymesAlgResult {
public:
    FindEnzymesAlgResult() {pos = -1;}
    FindEnzymesAlgResult(const SEnzymeData& _enzyme, int _pos) : enzyme(_enzyme), pos(_pos){}
    SEnzymeData enzyme;
    int         pos;
};

class FindEnzymesTask;

class FindEnzymesToAnnotationsTask : public Task {
    Q_OBJECT
public:
    FindEnzymesToAnnotationsTask(AnnotationTableObject* aobj, const QString& groupName, const DNASequence& seq, 
        LRegion& region, const QList<SEnzymeData>& enzymes, int maxResults = 0x7FFFFFFF,  int _minHitCount = 1, int _maxHitCount = INT_MAX);

    ReportResult report();
private:
    int maxHitCount;
    int minHitCount;
    QList<SEnzymeData>                  enzymes;
    QPointer<AnnotationTableObject>     aObj;
    QString                             groupName;
    FindEnzymesTask*                    fTask;
};

class FindEnzymesTask : public Task, public FindEnzymesAlgListener {
    Q_OBJECT
public:
    FindEnzymesTask(const DNASequence& seq, LRegion& region, const QList<SEnzymeData>& enzymes, int maxResults = 0x7FFFFFFF);

    QList<FindEnzymesAlgResult>  getResults() const {return results;}

    virtual void onResult(int pos, const SEnzymeData& enzyme);

    ReportResult report();
    
    QList<SharedAnnotationData> getResultsAsAnnotations(const QString& enzymeId = QString()) const;

    void cleanup();

private:
    void registerResult(const FindEnzymesAlgResult& r);

    int                                 maxResults;
    QList<FindEnzymesAlgResult>         results;
    QMutex                              resultsLock;
    
    QString                             group;
    QPointer<AnnotationTableObject*>    aObj;
};


class FindSingleEnzymeTask: public Task, public FindEnzymesAlgListener,  public SequenceWalkerCallback {
    Q_OBJECT
public:
    FindSingleEnzymeTask(const DNASequence& seq, LRegion& region, const SEnzymeData& enzyme, 
                        FindEnzymesAlgListener* l = NULL, int maxResults = 0x7FFFFFFF);
    
    QList<FindEnzymesAlgResult>  getResults() const {return results;}
    virtual void onResult(int pos, const SEnzymeData& enzyme);
    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& ti);
    void cleanup();
private:
    DNASequence                 seq;
    LRegion                     region;
    SEnzymeData                 enzyme;
    int                         maxResults; 
    FindEnzymesAlgListener*     resultListener;
    QList<FindEnzymesAlgResult> results;
    QMutex                      resultsLock;
};

} //namespace

#endif
