/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "PerfMonitorPlugin.h"
#include "PerfMonitorView.h"

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>

#include<QtGui/QMenu>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin * GB2_PLUGIN_INIT_FUNC() {
    if (AppContext::getMainWindow()) {
        PerfMonitorPlugin * plug = new PerfMonitorPlugin();
        return plug;
    }
    return NULL;
}

PerfMonitorPlugin::PerfMonitorPlugin() : Plugin( tr("Performance Monitor"), tr("Shows performance counters") ) {
    windowId = 0;
    openWindowAction = new QAction(tr("Show counters"), this);
    openWindowAction->setIcon(QIcon(":perf_monitor/images/mon.png"));
    connect(openWindowAction, SIGNAL(triggered()), SLOT(sl_openWindow()));

    QMenu* toolsMenu = AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu(MWMENU_TOOLS);
    toolsMenu->addAction(openWindowAction);
}

void PerfMonitorPlugin::sl_openWindow() {
    MWMDIManager* mdi = AppContext::getMainWindow()->getMDIManager();
    MWMDIWindow* mdiWindow = mdi->getWindowById(windowId);
    if (mdiWindow==NULL) {
        mdiWindow = new PerfMonitorView();
        windowId = mdiWindow->getId();
        mdi->addMDIWindow(mdiWindow);
    }
    mdi->activateWindow(mdiWindow);

}

} //namespace
