/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_REQUEST_TASK_H_
#define _GB2_REMOTE_REQUEST_TASK_H_

#include <core_api/Task.h>
#include <datatype/AnnotationData.h>

#include "RemoteRequestPlugin.h"

#define ULOG_CAT_PLUGIN_REMOTE_REQUEST "Plugin: Remote request"

namespace GB2 {

class DNATranslation;
class AnnotationTableObject;

struct RemoteRequestTaskSettings {
    RemoteRequestTaskSettings() : script(0), maxrl(0), minrl(0), complT(0), aminoT(0) {}

    Script *            script;
    int                 maxrl;
    int                 minrl;
    SendSelectionStrand strand;
    DNATranslation *    complT;
    DNATranslation *    aminoT;
    QByteArray          query;
};

class RemoteRequestToAnnotationsTask : public Task {
    Q_OBJECT
public:
    RemoteRequestToAnnotationsTask( Script * script, int maxrl, int minrl, SendSelectionStrand strand, DNATranslation * complT, 
        DNATranslation * aminoT, const QByteArray & query, int qoffs, AnnotationTableObject* ao, const QString & group );
    
    QList<Task*> onSubTaskFinished(Task* subTask);

private:
    int                 offsInGlobalSeq;
    QPointer<AnnotationTableObject>  aobj;
    QString             group;
    Task*               queryTask;
};


class RemoteRequestTask : public Task {
    Q_OBJECT
public:
    RemoteRequestTask( const RemoteRequestTaskSettings & cfg );
    void run();
    void cleanup();

    QList<SharedAnnotationData> getResultedAnnotations() const;
private:
    struct Query {
        Query() : complement(false), amino(false), offs(0){}
        QByteArray seq;
        bool complement;     //seq is complemented
        bool amino;     //seq is translated
        int offs;       //translation frame offset
    };
    void  prepareQueries();
    void  prepareEngine();
    void  createAnnotations(const Query & q);

    RemoteRequestTaskSettings cfg;
    QScriptEngine * engine;
    QList<Query>        queries;
    QList<SharedAnnotationData> resultAnnotations;
};

} //namespace

#endif 
