/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __REMOTE_REQUEST_WORKER_H__
#define __REMOTE_REQUEST_WORKER_H__

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>

#include "RemoteRequestTask.h"

namespace GB2 {
namespace LocalWorkflow {

class DNATranslation;

class RemoteRequestPromter : public PrompterBase<RemoteRequestPromter> {
    Q_OBJECT
public:
    RemoteRequestPromter( Actor * p = 0 ) : PrompterBase<RemoteRequestPromter>(p) {};
protected:
    QString composeRichDoc();
};


class RemoteRequestWorker : public BaseWorker {
    Q_OBJECT
public:
    RemoteRequestWorker( Actor * p ) : BaseWorker(p) {};

    virtual void init();
    virtual bool isReady();
    virtual Task * tick();
    virtual bool isDone();
    virtual void cleanup();

protected:
    IntegralBus * seqPort;
    IntegralBus * outPort;
private:
    RemoteRequestTaskSettings taskCfg;

private slots:
    void sl_onTaskFinished( Task * t );
};

class RemoteRequestWorkerFactory : public DomainFactory {
public:
    const static QString ACTOR;
    RemoteRequestWorkerFactory() : DomainFactory( ACTOR ) {};
    static void init();
    virtual Worker * createWorker( Actor * a );
};

} //ns LocalWorkflow
} //ns GB2

#endif
