/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SW_ALGORITHM_TASK_H_
#define _GB2_SW_ALGORITHM_TASK_H_

#include <core_api/Task.h>
#include <datatype/DNASequence.h>
#include <util_tasks/SequenceWalkerTask.h>
#include <util_smith_waterman/SmithWatermanSettings.h>
#include <util_smith_waterman/SubstMatrix.h>

#include "SmithWatermanAlgorithm.h"
#include "PairAlignSequences.h"

#include <QtCore/QVector>
#include <QtCore/QMutex>

namespace GB2 {    

    enum AlgType {classic, sse2, cuda, atistream};

class CudaGpuModel;
class AtiStreamGpuModel;

class SWAlgorithmTask : public Task, public SequenceWalkerCallback {
    Q_OBJECT        
public:    

    SWAlgorithmTask(const SmithWatermanSettings& s,
        const QString& taskName, AlgType algType);    

    void prepare();

    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& ti);        

    QList<PairAlignSequences> & getResult();        
    ReportResult report();

private:
    void addResult(QList<PairAlignSequences> & res, int sPos, 
        bool _isDNAComplemented, bool _isAminoTranslated);
    int calculateMatrixLength(const QByteArray & searchSeq, const QByteArray & patternSeq, int gapOpent, int gapExtension, int maxScore, int minScore);
    void removeResultFromOverlap(QList<PairAlignSequences> & res);
    int calculateMaxScore(const QByteArray & seq, SubstMatrix const * substitutionMatrix);

    void setupTask(int maxScore);

    QList<PairAlignSequences> pairAlignSequences;
    int minScore;

    QMutex lock;

    AlgType algType;
    

    SmithWatermanSettings sWatermanConfig;
    union {
        CudaGpuModel * cudaGpu;
        AtiStreamGpuModel * atiGpu;
    } gpuModel;
};

}

#endif
