/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowSettingsController.h"
#include "WorkflowViewController.h"
#include "WorkflowViewItems.h"

#include <workflow_support/WorkflowSettings.h>

//#include <core_api/Log.h>

namespace GB2
{
//static LogCategory log(ULOG_CAT_USER_INTERFACE);

WorkflowSettingsPageController::WorkflowSettingsPageController(QObject* p) 
: AppSettingsGUIPageController(tr("Workflow Designer"), WorkflowSettingsPageId, p) {}


AppSettingsGUIPageState* WorkflowSettingsPageController::getSavedState() {
    WorkflowSettingsPageState* state = new WorkflowSettingsPageState();
    state->showGrid = WorkflowSettings::showGrid();
    state->snap2grid = WorkflowSettings::snap2Grid();
    state->lockRun = WorkflowSettings::monitorRun();
    state->failFast = WorkflowSettings::failFast();
    state->style = WorkflowSettings::defaultStyle();
    state->font = WorkflowSettings::defaultFont();
    return state;
}

void WorkflowSettingsPageController::saveState(AppSettingsGUIPageState* s) {
    WorkflowSettingsPageState* state = qobject_cast<WorkflowSettingsPageState*>(s);
    WorkflowSettings::setShowGrid(state->showGrid);
    WorkflowSettings::setSnap2Grid(state->snap2grid);
    WorkflowSettings::setMonitorRun(state->lockRun);
    WorkflowSettings::setFailFast(state->failFast);
    WorkflowSettings::setDefaultStyle(state->style);
    WorkflowSettings::setDefaultFont(state->font);
}

AppSettingsGUIPageWidget* WorkflowSettingsPageController::createWidget(AppSettingsGUIPageState* state) {
    WorkflowSettingsPageWidget* r = new WorkflowSettingsPageWidget(this);
    r->setState(state);
    return r;
}

WorkflowSettingsPageWidget::WorkflowSettingsPageWidget(WorkflowSettingsPageController* ) {
    setupUi(this);
    styleCombo->addItem(GB2::WorkflowView::tr("Minimal"), ItemStyles::SIMPLE);
    styleCombo->addItem(GB2::WorkflowView::tr("Extended"), ItemStyles::EXTENDED);
}

void WorkflowSettingsPageWidget::setState(AppSettingsGUIPageState* s) {
    WorkflowSettingsPageState* state = qobject_cast<WorkflowSettingsPageState*>(s);
    gridBox->setChecked(state->showGrid);
    snapBox->setChecked(state->snap2grid);
    lockBox->setChecked(state->lockRun);
    failBox->setChecked(state->failFast);
    int idx = styleCombo->findData(state->style);
    if (idx < 0) idx = 1; 
    styleCombo->setCurrentIndex(idx);
    fontCombo->setCurrentFont(state->font);
}

AppSettingsGUIPageState* WorkflowSettingsPageWidget::getState(QString& ) const {
    WorkflowSettingsPageState* state = new WorkflowSettingsPageState();
    state->showGrid = gridBox->isChecked();
    state->snap2grid = snapBox->isChecked();
    state->lockRun = lockBox->isChecked();
    state->failFast = failBox->isChecked();
    state->style = styleCombo->itemData(styleCombo->currentIndex()).toString();
    state->font = fontCombo->currentFont();

    return state;
}

} //namespace
