/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/AppContext.h>
#include <molecular_geometry/MolecularSurfaceFactoryRegistry.h>
#include <SES.h>
#include <SAS.h>

#include "BallPlugin.h"

namespace GB2
{

extern "C" Q_DECL_EXPORT GB2::Plugin* GB2_PLUGIN_INIT_FUNC()
{
    BallPlugin* plug = new BallPlugin();
    return plug;
}

BallPlugin::BallPlugin():
    Plugin(tr("BALL"),tr("A port of BALL framework for molecular surface calculation"))
{
    AppContext::getMolecularSurfaceFactoryRegistry()->registerSurfaceFactory(new SolventExcludedSurfaceFactory(),QString("SES"));
    AppContext::getMolecularSurfaceFactoryRegistry()->registerSurfaceFactory(new SolventAccessibleSurfaceFactory(),QString("SAS"));
}

} // namespace
