/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMM_SEARCH_H_
#define _GB2_UHMM_SEARCH_H_

#include <core_api/LRegion.h>
#include <QtCore/QObject>
#include <float.h>

struct plan7_s;

namespace GB2 {

class TaskStateInfo;

enum HMMSearchAlgo {
    HMMSearchAlgo_Conservative,
    HMMSearchAlgo_SSEOptimized,
    HMMSearchAlgo_CellOptimized
};

class UHMMSearchSettings {
public:
    UHMMSearchSettings() : globE(10), eValueNSeqs(1), domE(0.9999999),  domT(-FLT_MAX), searchChunkSize(1000000), extraLen(-1), 
        alg(HMMSearchAlgo_Conservative) {}

    float   globE;
    int     eValueNSeqs;
    float	domE;
    float	domT;
    int     searchChunkSize;
    int     extraLen; //-1 -> auto
    HMMSearchAlgo alg;
};

class UHMMSearchResult {
public:
    UHMMSearchResult(const LRegion& _r, float sc, float eval) : r(_r), score(sc), evalue(eval){}
    LRegion r;
    float   score;
    float   evalue;
};

class UHMMSearch : public QObject {
    Q_OBJECT

public:
    static QList<UHMMSearchResult> search(plan7_s* hmm, const char* seq, int seqLen, const UHMMSearchSettings& s, TaskStateInfo& si);

};

} //namespace

#endif
