/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Muscle4Task.h"
#include "Muscle4Adapter.h"
#include "Muscle4TaskLocalStorage.h"
#include <core_api/DocumentModel.h>
#include <core_api/Counter.h>

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

namespace GB2 {


void Muscle4TaskSettings::reset() {
}

Muscle4Task::Muscle4Task(const MAlignment& ma, const Muscle4TaskSettings& _config) 
:Task(tr("MUSCLE 4 alignment"), TaskFlags_FOSCOE), config(_config), inputMA(ma)
{
    GCOUNTER( cvar, tvar, "Muscle4Task" );
}

void Muscle4Task::run() {
    assert(!hasErrors());
    doAlign(false); 

    if (!hasErrors() && !isCanceled()) {
        assert(resultMA.alphabet!=NULL);
        assert(resultMA.isNormalized());
    }
 }

void Muscle4Task::doAlign(bool refine) {
	Muscle4Adapter::align(inputMA, resultMA, stateInfo);
}

void Muscle4Task::doAddUnalignedToProfile() {
}

void Muscle4Task::doProfile2Profile() {
 }

Task::ReportResult Muscle4Task::report() {
    return ReportResult_Finished; 
}

Muscle4AddSequencesToProfileTask::Muscle4AddSequencesToProfileTask(MAlignmentObject* _obj, const QString& fileWithSequencesOrProfile, MMode _mode) 
: Task("", TaskFlags_NR_FOSCOE), maObj(_obj), mode(_mode)
{
}

QList<Task*> Muscle4AddSequencesToProfileTask::onSubTaskFinished(Task* subTask) {
    QList<Task*> res;
    return res;
}

Task::ReportResult Muscle4AddSequencesToProfileTask::report() {
    return ReportResult_Finished;
}

//////////////////////////////////////////////////////////////////////////
// MuscleGObjectTask

Muscle4GObjectTask::Muscle4GObjectTask(MAlignmentObject* _obj, const Muscle4TaskSettings& _config) 
: Task("", TaskFlags_NR_FOSCOE), obj(_obj), lock(NULL), muscleTask(NULL), config(_config)
{
    QString aliName = obj->getDocument()->getName();
    QString tn;
    tn = tr("MUSCLE align '%1'").arg(aliName);
    setTaskName(tn);
    setUseDescriptionFromSubtask(true);
    setVerboseLogMode(true);
}

Muscle4GObjectTask::~Muscle4GObjectTask() {
    assert(lock == NULL);
}

void Muscle4GObjectTask::prepare() {
    assert(true);
	if (obj.isNull()) {
        stateInfo.setError(tr("object_removed"));
        return;
    }
    if (obj->isStateLocked()) {
        stateInfo.setError(tr("object_is_state_locked"));
        return;
    }

    lock = new StateLock("muscle4_lock");
    obj->lockState(lock);
    muscleTask = new Muscle4Task(obj->getMAlignment(), config);

    addSubTask(muscleTask);
}

Task::ReportResult Muscle4GObjectTask::report() {
    if (lock!=NULL) {
        obj->unlockState(lock);
        delete lock;
        lock = NULL;
    }
    propagateSubtaskError();
    if (hasErrors() || isCanceled()) {
        return ReportResult_Finished;
    }
    assert(!obj.isNull());
    if (obj->isStateLocked()) {
        stateInfo.setError(tr("object_is_state_locked"));
        return ReportResult_Finished;
    }
    obj->setMAlignment(muscleTask->resultMA); 

    return ReportResult_Finished;
}

} //namespace
