/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Muscle4TaskLocalStorage.h"
#include "Muscle4Context.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>


GB2::Muscle4Context *getMuscle4Context() {
    return GB2::Muscle4TaskLocalData::current();
}
GB2::MatrixContainer *getMatrixContainer() {
    return GB2::Muscle4TaskLocalData::matrixContainer();
}

int getMuscle4WorkerID() {
    return GB2::Muscle4TaskLocalData::currentWorkerID();
}

namespace GB2 {

QThreadStorage<Muscle4ContextTLSRef*> Muscle4TaskLocalData::contextStorage;
QThreadStorage<MatrixContainerRef*> Muscle4TaskLocalData::matrixStorage;

class Muscle4Context* Muscle4TaskLocalData::current(){
    Muscle4ContextTLSRef* ref = contextStorage.localData();
    if (ref!=NULL) {
        return ref->ctx;
    }
    return NULL;
}

class MatrixContainer* Muscle4TaskLocalData::matrixContainer(){
    MatrixContainerRef* ref = matrixStorage.localData();
    if (ref!=NULL) {
        return ref->mtx;
    }
    return NULL;
}

unsigned Muscle4TaskLocalData::currentWorkerID() {
    Muscle4ContextTLSRef* ref = contextStorage.localData();
    if (ref!=NULL) {
        return ref->workerID;
    }
    return -1;

} 

void Muscle4TaskLocalData::bindContext(Muscle4Context *ctx, int workerID) {
    contextStorage.setLocalData(new Muscle4ContextTLSRef(ctx, workerID));
}

void Muscle4TaskLocalData::bindContainer(MatrixContainer *mtx, int workerID) {
    matrixStorage.setLocalData(new MatrixContainerRef(mtx, workerID));
}

void Muscle4TaskLocalData::detachContext() {
    Muscle4ContextTLSRef* ref = contextStorage.localData();
    ref->ctx = NULL;
    contextStorage.setLocalData(NULL);
}

void Muscle4TaskLocalData::detachMatrix() {
	MatrixContainerRef* ref = matrixStorage.localData();
	ref->mtx = NULL;
	matrixStorage.setLocalData(NULL);
}

}//namespace
