/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE4_WORKER_H_
#define _GB2_MUSCLE4_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>
#include "Muscle4Task.h"

namespace GB2 {

namespace LocalWorkflow {

class Muscle4Prompter : public PrompterBase<Muscle4Prompter> {
    Q_OBJECT
public:
    Muscle4Prompter(Actor* p = 0) : PrompterBase<Muscle4Prompter>(p) {}
protected:
    QString composeRichDoc();
};

class Muscle4Worker : public BaseWorker {
    Q_OBJECT
public:
    Muscle4Worker(Actor* a) : BaseWorker(a), input(NULL), output(NULL) {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}
private slots:
    void sl_taskFinished();

protected:
    CommunicationChannel *input, *output;
    QString resultName,transId;
    Muscle4TaskSettings cfg;
}; 

class Muscle4WorkerFactory : public DomainFactory {
public:
    static const QString ACTOR_ID;
    static void init();
    Muscle4WorkerFactory() : DomainFactory(ACTOR_ID) {}
    virtual Worker* createWorker(Actor* a) {return new Muscle4Worker(a);}
};

}//Workflow namespace
}//GB2 namespace

#endif
