/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "hit.h"
#include <algorithm>
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

#define TRACE	0

void GetUncoveredSegs(vector<BPData> &BPs, unsigned SeqLength,
  vector<SegData> &Segs)
	{
	Segs.clear();

	sort(BPs.begin(), BPs.end());

	unsigned Start = 0;
	int Depth = 0;
	for (unsigned i = 0; i < SIZE(BPs); ++i)
		{
		const BPData &BP = BPs[i];
		if (BP.lo)
			{
			if (Depth == 0 && BP.Pos > Start)
				{
				SegData Seg;
				Seg.Lo = Start;
				Seg.Hi = BP.Pos - 1;
				Seg.Strand = true;
				Segs.push_back(Seg);
				}
			Start = BP.Pos;
			++Depth;
			}
		else
			{
			Start = BP.Pos + 1;
			--Depth;
			}
		}
	asserta(Depth == 0);
	asserta(Start <= SeqLength);
	if (Start < SeqLength)
		{
		SegData Seg;
		Seg.Lo = Start;
		Seg.Hi = SeqLength - 1;
		Seg.Strand = true;
		Segs.push_back(Seg);
		}
	}

void AppendBPs(const vector<HitData> &Hits, vector<BPData> &BPs, bool DoA)
	{
	const unsigned HitCount = SIZE(Hits);
	for (unsigned i = 0; i < HitCount; ++i)
		{
		const HitData &Hit = Hits[i];

		BPData BP;
		BP.Pos = DoA ? Hit.LoA : Hit.LoB;
		BP.lo = true;
		BPs.push_back(BP);

		BP.Pos = DoA ? Hit.HiA : Hit.HiB;
		BP.lo = false;
		BPs.push_back(BP);
		}
	}
