/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "mx.h"
#include "best.h"
#include "seqdb.h"
#include "params.h"
#include "hit.h"
#include <algorithm>
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

void LogLocalAln(SeqDB &DB, unsigned IdA, unsigned IdB,
  unsigned Starti, unsigned Startj, const string &Path);

//#define		m(x)	static Mx<float> g_Fwd##x; static Mx<char> g_TB##x;
	//static Mx<float> g_FwdM3; 
	//static Mx<char> g_TBM3;

	//static Mx<float> g_FwdD3; 
	//static Mx<char> g_TBD3;

	//static Mx<float> g_FwdI3; 
	//static Mx<char> g_TBI3;


//	m(M)
//	m(D)
//	m(I)
//#undef m

float SWAff(HitData &Hit)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	Mx<float> &Simf = GetSimMxf();

	const float * const *SimMx = Simf.GetData();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

/*#define		m(x)	g_Fwd##x.Alloc("SAff_Fwd"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	\
					g_TB##x.Alloc("SWAff_TB"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	\
					float **Fwd##x = g_Fwd##x.GetData();											\
					char **TB##x = g_TB##x.GetData();
	m(M)
	m(D)
	m(I)
#undef m*/

	ctx->g_FwdM3.Alloc("SAff_FwdM3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);
	ctx->g_TBM3.Alloc("SWAff_TBM3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	
	float **FwdM3 = ctx->g_FwdM3.GetData();											
	char **TBM3 = ctx->g_TBM3.GetData();

	ctx->g_FwdD3.Alloc("SAff_FwdD3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);
	ctx->g_TBD3.Alloc("SWAff_TBD3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	
	float **FwdD3 = ctx->g_FwdD3.GetData();											
	char **TBD3 = ctx->g_TBD3.GetData();

	ctx->g_FwdI3.Alloc("SAff_FwdI3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);
	ctx->g_TBI3.Alloc("SWAff_TBI3", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	
	float **FwdI3 = ctx->g_FwdI3.GetData();											
	char **TBI3 = ctx->g_TBI3.GetData();




	for (unsigned i = 0; i <= LA; ++i)
		{
		FwdM3[i][0] = 0;
		FwdD3[i][0] = LOG_ZERO;
		FwdI3[i][0] = LOG_ZERO;
		TBM3[i][0] = 'S';
		TBD3[i][0] = '?';
		TBI3[i][0] = '?';
		}

	for (unsigned j = 0; j <= LB; ++j)
		{
		FwdM3[0][j] = 0;
		FwdD3[0][j] = LOG_ZERO;
		FwdI3[0][j] = LOG_ZERO;
		TBM3[0][j] = 'S';
		TBD3[0][j] = '?';
		TBI3[0][j] = '?';
		}

// Main loop
	float BestScore = LOG_ZERO;
	unsigned Besti = UINT_MAX;
	unsigned Bestj = UINT_MAX;
	for (unsigned i = 0; i < LA; ++i)
		{
		const float *SimMxRow = SimMx[i+1];
		for (unsigned j = 0; j < LB; ++j)
			{
		// xM
			{
			float Match = SimMxRow[j+1];
			float MM = FwdM3[i][j] + Match;
			float DM = FwdD3[i][j] + Match;
			float IM = FwdI3[i][j] + Match;
			float SM = 0;
			float Score;
			Best4(MM, DM, IM, SM, 'M', 'D', 'I', 'S', Score, TBM3[i+1][j+1]);
			FwdM3[i+1][j+1] = Score;
			if (Score > BestScore)
				{
				BestScore = Score;
				Besti = i+1;
				Bestj = j+1;
				}
			}
			
		// xD
			{
			float MD = FwdM3[i][j+1] + ctx->TransMD;
			float DD = FwdD3[i][j+1] + ctx->TransDD;
			Best2(MD, DD, 'M', 'D', FwdD3[i+1][j+1], TBD3[i+1][j+1]);
			}
			
		// xI
			{
			float MI = FwdM3[i+1][j] + ctx->TransMI;
			float II = FwdI3[i+1][j] + ctx->TransII;
			Best2(MI, II, 'M', 'I', FwdI3[i+1][j+1], TBI3[i+1][j+1]);
			}
			}
		}

	if (ctx->opt_trace)
		{
		ctx->g_FwdM3.LogMe();
		ctx->g_FwdD3.LogMe();
		ctx->g_FwdI3.LogMe();
		ctx->g_TBM3.LogMe();
		ctx->g_TBD3.LogMe();
		ctx->g_TBI3.LogMe();
		}

	if (Besti == UINT_MAX)
		{
		Hit.LoA = 0;
		Hit.LoB = 0;
		Hit.HiA = 0;
		Hit.HiB = 0;
		Hit.Score = LOG_ZERO;
		Hit.User = UINT_MAX;
		Hit.Path.clear();
		return LOG_ZERO;
		}

	Hit.HiA = Besti - 1;
	Hit.HiB = Bestj - 1;

	unsigned i = Besti;
	unsigned j = Bestj;
	char State = 'M';
	if (ctx->opt_trace)
		{
		Log("BestScore=%g\n", BestScore);
		Log("Besti,j=%u,%u\n", Besti, Bestj);
		Log("    i      j  State\n");
		Log("-----  -----  -----\n");
		}
	Hit.Path.clear();
	for (;;)
		{
		switch (State)
			{
		case 'M':
			{
			State = TBM3[i][j];
			--i;
			--j;
			break;
			}
		case 'D':
			{
			State = TBD3[i][j];
			--i;
			break;
			}
		case 'I':
			{
			State = TBI3[i][j];
			--j;
			break;
			}
		default:
			asserta(false);
			}

		if (ctx->opt_trace)
			Log("%5u  %5u  %5c\n", i, j, State);

		if (State == 'S')
			break;

		Hit.Path.push_back(State);
		}

	Hit.LoA = i+1;
	Hit.LoB = j+1;
	reverse(Hit.Path.begin(), Hit.Path.end());
	Hit.LogMe(true);
	return BestScore;
	}

void SWAff(SeqDB &	DB)
	{
	string Model;
	GetLocalModel(DB, Model);
	SetModel(Model);

	const unsigned SeqCount = DB.GetSeqCount();
	for (unsigned IdA = 0; IdA < SeqCount; ++IdA)
		{
		for (unsigned IdB = IdA + 1; IdB < SeqCount; ++IdB)
			{
			SetSimMx(DB, IdA, IdB);

			HitData Hit;
			SWAff(Hit);
			LogLocalAln(DB, IdA, IdB, Hit.LoA, Hit.LoB, Hit.Path);

			DB.RevComp(IdB);

			SetSimMx(DB, IdA, IdB);

			SWAff(Hit);
			LogLocalAln(DB, IdA, IdB, Hit.LoA, Hit.LoB, Hit.Path);

			DB.RevComp(IdB);
			}
		}
	}
