#!/usr/bin/perl

use CGI;
use DBI;
use Storable qw( thaw );
use Data::Dumper;
use Compress::Zlib;

my $cgi = new CGI;
my $dbh = DBI->connect( "DBI:mysql:database=jolicloud_hardware;host=localhost",
        "jolihardware", "" );

print "Content-type: text/plain\n\n";

if ( $cgi->param( 'data' ) ) {
    my $info = thaw( uncompress( $cgi->param( 'data' ) ) );
    my $uuid = $info->{ 'uuid' };
    my $devId = -1;

    if ( $uuid eq "" ) {
        die "UUID Missing!";
    }

    my $sth = $dbh->prepare( "select id from devices where uuid = ?" );
    $sth->execute( $uuid ) || die $sth->errstr;
    if ( $sth->rows ) {
        my $data = $sth->fetchrow_hashref;
        $devId = $data->{ 'id' };
    }
    $sth->finish;

    if ( $devId eq -1 ) {
        $dbh->do( "insert into devices ( uuid, created ) values ( ?, now() )",
                undef, $uuid );
        $devId = $dbh->last_insert_id( undef, undef, "devices", "id" );
    }
    else {
        $dbh->do( "update devices set updated = now() where id = ?",
                undef, $devId);
    }

    while ( my ( $table, $inData ) = each %{ $info } ) {

        if ( $table eq "amixer" ) {
            &UpdateAmixer( $devId, $inData );
        }
        if ( $table eq "cpuinfo" ) {
            &UpdateCpuInfo( $devId, $inData );
        }
        elsif ( $table eq "dmi" ) {
            &UpdateDmi( $devId, $inData );
        }
        elsif ( $table eq "lsmod" ) {
            &UpdateLsmod( $devId, $inData );
        }
        elsif ( $table eq "lspci" ) {
            &UpdateLspci( $devId, $inData );
        }
        elsif ( $table eq "lsusb" ) {
            &UpdateLsusb( $devId, $inData );
        }
    }
}

print "OK";

$dbh->disconnect();



sub UpdateAmixer
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_amixer
            where device_id = ?" );
    $sth->execute( $devId );
    while ( my $data = $sth->fetchrow_hashref ) {
        $dbData->{ delete $data->{ 'control' } } = $data;
    }
    $sth->finish;

    my @dbControls = keys( %{ $dbData } );
    my @inControls = keys( %{ $inData } );

    foreach my $control ( @inControls ) {
        my $inControl = $inData->{ $control };
        my $dbControl = $dbData->{ $control };
        if ( $dbData->{ $control } ) {
            $dbh->do( "update devices_amixer set control = ?,
                    capabilities = ?, limits = ?, front_left = ?,
                    front_right = ?, items = ?, item0 = ?, updated =
                    now() where id = ?", undef, $control,
                    $inControl->{ 'Capabilities' },
                    $inControl->{ 'Limits' },
                    $inControl->{ 'Front Left' },
                    $inControl->{ 'Front Right' },
                    $inControl->{ 'Items' },
                    $inControl->{ 'Item0' }, $dbControl->{ 'id' } );
        }
        else {
            $dbh->do( "insert into devices_amixer
                    ( device_id, control, capabilities, limits,
                    front_left, front_right, items, item0, updated )
                    values ( ?, ?, ?, ?, ?, ?, ?, ?, now() )",
                    undef, $devId, $control,
                    $inControl->{ 'Capabilities' },
                    $inControl->{ 'Limits' },
                    $inControl->{ 'Front Left' },
                    $inControl->{ 'Front Right' },
                    $inControl->{ 'Items' },
                    $inControl->{ 'Item0' } );
        }
    }
}



sub UpdateCpuInfo
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_cpuinfo
            where device_id = ?" );
    $sth->execute( $devId );
    $dbData = $sth->fetchrow_hashref;
    $sth->finish;

    if ( $dbData->{ 'id' } ) {
        # Do not routinely update the cpuinfo table
    }
    else {
        $dbh->do( "insert into devices_cpuinfo
                ( device_id, processors, vendor_id, cpu_family, model,
                model_name, stepping, mhz, bogomips, flags ) values
                ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ",
                undef, $devId,
                $inData->{ 'processors' },
                $inData->{ 'vendor_id' },
                $inData->{ 'cpu family' },
                $inData->{ 'model' },
                $inData->{ 'model name' },
                $inData->{ 'stepping' },
                $inData->{ 'cpu MHz' }, 
                $inData->{ 'bogomips' }, 
                $inData->{ 'flags' } );
    }
}



sub UpdateDmi
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_dmi where device_id = ?" );
    $sth->execute( $devId );
    $dbData = $sth->fetchrow_hashref;
    $sth->finish;

    if ( $dbData->{ 'id' } ) {
        # Do not routinely update the dmi table
    }
    else {
        $dbh->do( "insert into devices_dmi
                ( device_id, bios_date, bios_vendor, bios_version,
                board_asset_tag, board_name, board_serial, board_vendor,
                board_version, chassis_asset_tag, chassis_serial,
                chassis_type, chassis_vendor, chassis_version,
                product_name, product_serial, product_version, sys_vendor )
                values
                ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ",
                undef, $devId,
                $inData->{ 'bios_date' },
                $inData->{ 'bios_vendor' },
                $inData->{ 'bios_version' },
                $inData->{ 'board_asset_tag' },
                $inData->{ 'board_name' },
                $inData->{ 'board_serial' },
                $inData->{ 'board_vendor' },
                $inData->{ 'board_version' },
                $inData->{ 'chassis_asset_tag' },
                $inData->{ 'chassis_serial' },
                $inData->{ 'chassis_type' },
                $inData->{ 'chassis_vendor' },
                $inData->{ 'chassis_version' },
                $inData->{ 'product_name' },
                $inData->{ 'product_serial' },
                $inData->{ 'product_version' },
                $inData->{ 'sys_vendor' } );
    }
}



sub UpdateLsmod
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_lsmod
            where device_id = ?" );
    $sth->execute( $devId );
    while ( my $data = $sth->fetchrow_hashref ) {
        $dbData->{ $data->{ 'module' } } = $data;
    }
    $sth->finish;

    my @dbModules = keys( %{ $dbData } );
    my @inModules = keys( %{ $inData } );

    foreach my $module ( @inModules ) {
        my $inModule = $inData->{ $module };
        my $dbModule = $dbData->{ $module };

        if ( $dbData->{ $module } ) {
            $inModule->{ 'active' } = 2;
        }
        else {
            $dbh->do( "insert into devices_lsmod
                    ( device_id, module )
                    values ( ?, ? )",
                    undef, $devId, $module );
            $inModule->{ 'active' } = 1;
        }
    }

    # Delete the modules from the database that aren't "active"
    foreach my $module ( @dbModules ) {
        my $inModule = $inData->{ $module };
        my $dbModule = $dbData->{ $module };

        if ( ! $inModule->{ 'active' } ) {
            $dbh->do( "delete from devices_lsmod where id = ?",
                    undef, $dbModule->{ 'id' } );
        }
    }

}



sub UpdateLspci
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_lspci
            where device_id = ?" );
    $sth->execute( $devId );
    while ( my $data = $sth->fetchrow_hashref ) {
        $dbData->{ delete $data->{ 'slot' } } = $data;
    }
    $sth->finish;

    my @dbSlots = keys( %{ $dbData } );
    my @inSlots = keys( %{ $inData } );

    foreach my $slot ( @inSlots ) {
        my $inSlot = $inData->{ $slot };
        my $dbSlot = $dbData->{ $slot };

        if ( $dbData->{ $slot } ) {
            $dbh->do( "update devices_lspci set
                    slot = ?, class = ?, device = ?, vendor = ?,
                    sdevice = ?, svendor = ?, driver = ?, modules = ?
                    where id = ?",
                    undef, $slot,
                    $inSlot->{ 'class' },
                    $inSlot->{ 'device' },
                    $inSlot->{ 'vendor' },
                    $inSlot->{ 'sdevice' },
                    $inSlot->{ 'svendor' },
                    $inSlot->{ 'driver' },
                    $inSlot->{ 'modules' },
                    $dbData->{ $slot }->{ 'id' },
                    );
        }
        else {
            $dbh->do( "insert into devices_lspci
                    ( device_id, slot, class, device, vendor, sdevice, svendor,
                    driver, modules )
                    values ( ?, ?, ?, ?, ?, ?, ?, ?, ? )",
                    undef, $devId, $slot,
                    $inSlot->{ 'class' },
                    $inSlot->{ 'device' },
                    $inSlot->{ 'vendor' },
                    $inSlot->{ 'sdevice' },
                    $inSlot->{ 'svendor' },
                    $inSlot->{ 'driver' },
                    $inSlot->{ 'modules' },
                    );
        }
    }
}



sub UpdateLsusb
{
    my ( $devId, $inData ) = @_;
    my $dbData = {};

    my $sth = $dbh->prepare( "select * from devices_lsusb
            where device_id = ?" );
    $sth->execute( $devId );
    while ( my $data = $sth->fetchrow_hashref ) {
        $dbData->{ $data->{ 'product' } }->{ $data->{ 'vendor' } } = $data;
    }
    $sth->finish;

    foreach my $inUSB ( @{ $inData } ) {
        if ( $dbData->{ $inUSB->{ 'product' } }->{ $inUSB->{ 'vendor' } } ) {
        }
        else {
            $dbh->do( "insert into devices_lsusb ( device_id, product, vendor )
                    values ( ?, ?, ? )",
                    undef, $devId,
                    $inUSB->{ 'product' },
                    $inUSB->{ 'vendor' } );
        }
    }
}

$dbh->disconnect();
