#!/usr/bin/perl

use CGI;
use DBI;

my $cgi = new CGI;
my $dbh = DBI->connect( "DBI:mysql:database=jolicloud_hardware;host=localhost",
        "jolihardware", "" );

my $uuid = $cgi->param( 'uuid' );

print "Content-type: text/html\n\n";

print "<form method=get action='" . $ENV{ 'SCRIPT_URL' } . "'>\n";
print "jsh-uuid: <input type=text name=uuid value='$uuid'> <input type=submit>\n";
print "</form>\n";

if ( $uuid ) {
    my $sth = $dbh->prepare( "select id from devices where uuid = ?" );
    $sth->execute( $uuid );
    my $data = $sth->fetchrow_hashref();
    my $devId = $data->{ 'id' };
    $sth->finish;

    print "<hr>";
    if ( $devId ) { 
        print "Found device ID: $devId<br>\n";
        print "<h2>dmi</h2>\n";
        &PrintDmi( $devId );
        print "<h2>lspci</h2>\n";
        &PrintLspci( $devId );
        print "<h2>amixer</h2>\n";
        &PrintAmixer( $devId );
        print "<h2>lsmod</h2>\n";
        &PrintLsmod( $devId );
        print "<h2>lsusb</h2>\n";
        &PrintLsusb( $devId );
    }
    else {
        print "Error: cannot find device<br>\n";
    }
}


$dbh->disconnect;


sub PrintLspci
{
    my $id = shift;
    my @cols = qw( class vendor device svendor sdevice driver modules );
    my $sql = "select " . join(',', @cols ) . " from devices_lspci where device_id = ?";

    &DataTable( $sql, $id, @cols );
}


sub PrintLsmod
{
    my $id = shift;
    my @cols = qw( module );
    my $sql = "select " . join(',', @cols ) . " from devices_lsmod where device_id = ?";

    &DataTable( $sql, $id, @cols );


}


sub PrintLsusb
{
    my $id = shift;
    my @cols = qw( vendor product );
    my $sql = "select " . join(',', @cols ) . " from devices_lsusb where device_id = ?";

    &DataTable( $sql, $id, @cols );
}


sub PrintAmixer
{
    my $id = shift;
    my @cols = qw( control capabilities limits front_left front_right items item0 );
    my $sql = "select " . join(',', @cols ) . " from devices_amixer where device_id = ?";

    &DataTable( $sql, $id, @cols );
}


sub PrintDmi
{
    my $id = shift;
    my @cols = qw( bios_version board_name board_serial board_vendor product_name product_serial );
    my $sql = "select " . join(',', @cols ) . " from devices_dmi where device_id = ?";

    &DataTable( $sql, $id, @cols );
}



sub DataTable
{
    my ( $sql, $id, @cols ) = @_;
    my @rows;

    my $sth = $dbh->prepare( $sql );

    $sth->execute( $id );
    while ( my $data = $sth->fetchrow_hashref ) {
        push( @rows, $data );
    }
    $sth->finish;

    print "<table border=1>\n";
    print "  <tr>\n";
    foreach my $col ( @cols ) {
        print "    <th>$col</th>\n";
    }
    print "  </tr>\n";
    foreach my $row ( @rows ) {
        print "  <tr>\n";
        foreach my $col ( @cols ) {
            print "    <td>$row->{ $col }</td>\n";
        }
        print "  </tr>\n";
    }
    print "  </table>\n";
}
