/*
 * Copyright (C) 2008 Martin Willi
 * Hochschule fuer Technik Rapperswil
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <library.h>
#include <daemon.h>

/*******************************************************************************
 * RSA key generation and signature
 ******************************************************************************/
bool test_rsa_gen()
{
	char buf[] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
	chunk_t data = chunk_from_buf(buf), sig, crypt, plain;
	private_key_t *private;
	public_key_t *public;
	u_int key_size;
	
	for (key_size = 512; key_size <= 2048; key_size *= 2)
	{
		private = lib->creds->create(lib->creds, CRED_PRIVATE_KEY, KEY_RSA,
									 BUILD_KEY_SIZE, key_size, BUILD_END);
		if (!private)
		{
			DBG1(DBG_CFG, "generating %d bit RSA key failed");
			return FALSE;
		}
		public = private->get_public_key(private);
		if (!public)
		{
			DBG1(DBG_CFG, "generating public from private key failed");
			return FALSE;
		}
		if (!private->sign(private, SIGN_RSA_EMSA_PKCS1_SHA1, data, &sig))
		{
			DBG1(DBG_CFG, "creating RSA signature failed");
			return FALSE;
		}
		if (!public->verify(public, SIGN_RSA_EMSA_PKCS1_SHA1, data, sig))
		{
			DBG1(DBG_CFG, "verifying RSA signature failed");
			return FALSE;
		}
		sig.ptr[sig.len-1]++;
		if (public->verify(public, SIGN_RSA_EMSA_PKCS1_SHA1, data, sig))
		{
			DBG1(DBG_CFG, "verifying faked RSA signature succeeded!");
			return FALSE;
		}
		free(sig.ptr);
		if (!public->encrypt(public, data, &crypt))
		{
			DBG1(DBG_CFG, "encrypting data with RSA failed");
			return FALSE;
		}
		if (!private->decrypt(private, crypt, &plain))
		{
			DBG1(DBG_CFG, "decrypting data with RSA failed");
			return FALSE;
		}
		if (!chunk_equals(data, plain))
		{
			DBG1(DBG_CFG, "decrpyted data invalid, expected %B, got %B", &
				 data, &plain);
			return FALSE;
		}
		chunk_clear(&crypt);
		chunk_clear(&plain);
		public->destroy(public);
		private->destroy(private);
	}
	return TRUE;
}


/*******************************************************************************
 * Load a subjectPubkeyInfo wrapped key (RSA in this case)
 ******************************************************************************/
static char public_any[] = {
  0x30,0x82,0x01,0x20,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
  0x01,0x05,0x00,0x03,0x82,0x01,0x0d,0x00,0x30,0x82,0x01,0x08,0x02,0x82,0x01,0x01,
  0x00,0xc6,0x68,0x99,0x1d,0xc8,0x06,0xdb,0xcf,0x1c,0x66,0xbb,0x91,0xc3,0xd4,0x10,
  0xb2,0x08,0xa9,0xc5,0x71,0x39,0x1c,0xbe,0x5b,0x1d,0xce,0xfd,0x1b,0xfa,0xec,0x04,
  0x89,0x9f,0x79,0xc8,0x46,0x00,0xd2,0x71,0xfb,0x22,0x16,0x52,0x2f,0xda,0xbf,0x0f,
  0xe7,0x16,0xb1,0xd7,0x6a,0xa5,0xa5,0xfc,0xee,0xff,0x84,0x4c,0x81,0x3f,0xab,0x84,
  0x0e,0xed,0x4a,0x26,0x59,0xd0,0x9b,0xb5,0xe1,0xec,0x61,0xc4,0xd3,0x15,0x4c,0x29,
  0x51,0xa0,0xde,0x33,0x07,0x58,0x6c,0x36,0x1b,0x18,0x61,0xd9,0x56,0x18,0x39,0x54,
  0x8b,0xd2,0xea,0x4e,0x87,0x28,0x58,0xb9,0x88,0x3d,0x30,0xbc,0xfc,0x6d,0xad,0xab,
  0x43,0x26,0x09,0x48,0x4e,0x6e,0x8a,0x8b,0x88,0xb3,0xf0,0x29,0x25,0x79,0xb6,0xb6,
  0x71,0x3c,0x93,0x59,0xd2,0x36,0x94,0xd5,0xfc,0xf3,0x62,0x2b,0x69,0xa3,0x7a,0x47,
  0x4e,0x53,0xa2,0x35,0x1b,0x26,0x89,0xaa,0x09,0xfd,0x56,0xd7,0x75,0x2a,0xd4,0x91,
  0xc0,0xf2,0x78,0xd7,0x05,0xca,0x12,0x1d,0xd9,0xd4,0x81,0x23,0xb2,0x3c,0x38,0xd9,
  0xb4,0xdc,0x21,0xe0,0xe5,0x2d,0xd4,0xbe,0x61,0x39,0x8a,0x46,0x90,0x46,0x73,0x31,
  0xba,0x48,0xbb,0x51,0xbb,0x91,0xd5,0x62,0xad,0xd1,0x53,0x5b,0x85,0xc9,0x1d,0xa7,
  0xf6,0xa0,0xe1,0x0e,0x6c,0x22,0x5d,0x29,0x9a,0xe7,0x0f,0xe8,0x0a,0x50,0xa7,0x19,
  0x11,0xc2,0x8b,0xe0,0x8a,0xfd,0x2b,0x94,0x31,0x7a,0x78,0x9c,0x9b,0x75,0x63,0x49,
  0xa9,0xe5,0x58,0xe6,0x3a,0x99,0xcb,0x2b,0xdd,0x0e,0xdc,0x7d,0x1b,0x98,0x80,0xc3,
  0x9f,0x02,0x01,0x23,
};

bool test_rsa_load_any()
{
	chunk_t chunk = chunk_from_buf(public_any);
	public_key_t *public;
	
	public = lib->creds->create(lib->creds, CRED_PUBLIC_KEY, KEY_ANY,
								BUILD_BLOB_ASN1_DER, chunk,
								BUILD_END);
	if (!public || public->get_keysize(public) != 256)
	{
		return FALSE;
	}
	public->destroy(public);
	return TRUE;
}

