/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "via_driver.h"
#include "via_regs.h"
#include "drm.h"
#include "agpctl.h"

unsigned long NULL_COMMAND_INV[4] = {
    0xCC000000, 
    0xCD000000, 
    0xCE000000, 
    0xCF000000
};

void AddWaitCmdInv(volatile unsigned int ** ppCmd, unsigned int ChipID, unsigned int Flags)
{
    unsigned int cmd = 0;
    volatile unsigned int *pCmd;
    pCmd = *ppCmd;
    switch(ChipID)
    {
        case PCI_CHIP_VT3336:
        case PCI_CHIP_VT3364:
            {
                if(Flags & FLAG_WAIT_2D_IDLE)
                {
                    cmd |=UMA_HW_WAIT_2D_IDLE;
                }
                if(Flags & FLAG_WAIT_3D_IDLE)
                {
                    cmd |= UMA_HW_WAIT_3D_IDLE;
                }
                if(cmd)
                {
                    ADDCmdHeader4_INVI(pCmd, INV_REG_23D_WAIT, 1, 0);
                    *pCmd++ = cmd;
                    *pCmd++ = H5_HC_DUMMY;
                    *pCmd++ = H5_HC_DUMMY;
                    *pCmd++ = H5_HC_DUMMY;
                }
            }
            break;
        case PCI_CHIP_VT3353:
        case PCI_CHIP_VT3409:
            {
                if(Flags & FLAG_WAIT_2D_IDLE)
                {
                    cmd |=INV_CR_WAIT_2D_IDLE;
                }
                if(Flags & FLAG_WAIT_3D_IDLE)
                {
                    cmd |= INV_CR_WAIT_3D_IDLE;
                }
                if(cmd)
                {
                    ADDCmdHeader0_INVI(pCmd, 1);
                    ADD2DCmd_INVI(pCmd, INV_CR_WAIT_ENGINE_IDLE,   cmd);
                    *pCmd++ = H5_HC_DUMMY;
                    *pCmd++ = H5_HC_DUMMY;
                }
            }
            break;
    }
    *ppCmd = pCmd;
}


void Command_CRSync_2D3D(ViaCommandBuffer * cb, unsigned int ChipID, unsigned int Flags)
{
#if 0
    unsigned int cmd = 0;

    switch(ChipID)
    {
        case PCI_CHIP_VT3336:
        case PCI_CHIP_VT3364:
            {
                if(Flags & FLAG_WAIT_2D_IDLE)
                {
                    cmd |=UMA_HW_WAIT_2D_IDLE;
                }
                if(Flags & FLAG_WAIT_3D_IDLE)
                {
                    cmd |= UMA_HW_WAIT_3D_IDLE;
                }
                if(cmd)
                {
                    BEGIN_HEADER5_VIDEOAGP(1);
                    OUT_RING_QW(INV_REG_23D_WAIT, cmd);
                    END_HEADER5_VIDEOAGP;
                }
            }
            break;
        case PCI_CHIP_VT3353:
        case PCI_CHIP_VT3409:
            {
                if(Flags & FLAG_WAIT_2D_IDLE)
                {
                    cmd |= INV_CR_WAIT_2D_IDLE;
                }
                if(Flags & FLAG_WAIT_3D_IDLE)
                {
                    cmd |= INV_CR_WAIT_3D_IDLE;
                }
                if(cmd)
                {
                    BEGIN_HEADER0_2D_H5(1);
                    OUT_RING_QW(INV_CR_WAIT_ENGINE_IDLE,cmd);
                }
            }
            break;
        default:
            break;
    }
#endif    
}

void Command_CRSync_Video(ViaCommandBuffer * cb, unsigned int ChipID, unsigned int Flags)
{
    unsigned int cmd = 0;

    switch(ChipID)
    {
        case PCI_CHIP_VT3336:
        case PCI_CHIP_VT3364:
        case PCI_CHIP_VT3353:
        case PCI_CHIP_VT3409:
            {
                if(Flags & FLAG_WAIT_2D_IDLE)
                {
                    cmd |= UMA_HW_WAIT_2D_IDLE;
                }
                if(Flags & FLAG_WAIT_3D_IDLE)
                {
                    cmd |= UMA_HW_WAIT_3D_IDLE;
                }
                if(cmd)
                {
                    BEGIN_HEADER5_VIDEOAGP(1);
                    OUT_RING_QW(INV_REG_23D_WAIT, cmd);
                    END_HEADER5_VIDEOAGP;
                }
            }
            break;
        default:
            break;
    }
}

int viaQuerryBranchAgpBufferInfo(VIAPtr pVia)
{
    static int need_query_agp_branch = 1;
    int ret;

    if(need_query_agp_branch)
    {
        memset(&pVia->umdBranchQuery, 0x00, sizeof(drm_umd_branch_query_t));
        
        do {
            ret = drmCommandWriteRead(pVia->drmFD, DRM_S3G_QUERY_BRANCH,
            &pVia->umdBranchQuery, sizeof(drm_umd_branch_query_t));
        } while (ret == -EAGAIN);
        
        if(ret == 0)
        {
            need_query_agp_branch = 0;
        }
    }
    return (int)(pVia->umdBranchQuery.branch_buf_enabled);
}
unsigned long *viaRequestBranchAgpBuffer(VIAPtr  pVia)
{
    int ret;

    if(pVia->umdBranchQuery.branch_buf_enabled)
    {
        memset(&pVia->umdBranchBuf, 0x00, sizeof(drm_umd_branch_buf_t));

        do {
        ret = drmCommandWriteRead(pVia->drmFD, DRM_S3G_BRANCH_BUF_REQUEST,
        &pVia->umdBranchBuf, sizeof(drm_umd_branch_buf_t));
        } while (ret == -EAGAIN);

        if(ret == 0)
        {
            if((pVia->umdBranchBuf.id >= pVia->umdBranchQuery.branch_buf_num) ||
            (pVia->umdBranchBuf.size != pVia->umdBranchQuery.branch_buf_size) ||
            (pVia->umdBranchBuf.offset >= pVia->agpTexSize) ||
            (pVia->umdBranchBuf.status != prepared ))
            {
                /* reset the flag of support_agp_branch because of some error info return by DRM ioctl */
                pVia->umdBranchQuery.branch_buf_enabled = FALSE;
            }
            else
            {
                pVia->umdBranchBuf.user_virtual = 
                    (void *)(pVia->agpTexMappedAddr + pVia->umdBranchBuf.offset);
                pVia->umdBranchBuf.cmd_size = 0;
            }
        }
        else
        {
            /* reset the flag of support_agp_branch because of request branch agp buffer fail */
            pVia->umdBranchQuery.branch_buf_enabled = FALSE;
        }
    }

    return (pVia->umdBranchQuery.branch_buf_enabled)? 
                (unsigned long *)(pVia->umdBranchBuf.user_virtual) : NULL;
}

int viaFlushBranchAgpBuffer(VIAPtr pVia)
{
    int ret;
    unsigned int * pBuf;

    if(pVia->umdBranchQuery.branch_buf_enabled)
    {
        pBuf = (unsigned int *)pVia->umdBranchBuf.user_virtual;
        while(pVia->umdBranchBuf.cmd_size & 3) {
            pBuf[pVia->umdBranchBuf.cmd_size++] = H5_HC_DUMMY;
        }
	    
        do {
        ret = drmCommandWrite(pVia->drmFD, DRM_S3G_BRANCH_BUF_FLUSH,
            &pVia->umdBranchBuf, sizeof(drm_umd_branch_buf_t));
        } while (ret == -EAGAIN);
    }

    return (pVia->umdBranchQuery.branch_buf_enabled)? TRUE : FALSE;
}

int viaFlushPCIECache(VIAPtr pVia, unsigned long offset, unsigned long size)
{
    int ret;
    drm_umd_cflush_pages_t  PCIe_cflush;

    PCIe_cflush.offset = offset;
    PCIe_cflush.size = size;

    do {
    ret = drmCommandWrite(pVia->drmFD, DRM_S3G_FLUSH_PCIE_CACHE,
    &PCIe_cflush, sizeof(drm_umd_cflush_pages_t));
    } while (ret == -EAGAIN);

    return ret;
}

