/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __AGPCTL_H__
#define __AGPCTL_H__
#include "via_drm.h"

extern int viaQuerryBranchAgpBufferInfo(VIAPtr pVia);
extern unsigned long *viaRequestBranchAgpBuffer(VIAPtr  pVia);
extern int viaFlushBranchAgpBuffer(VIAPtr pVia);
extern int viaFlushPCIECache(VIAPtr pVia, unsigned long offset, unsigned long size);

/*
 *  Hardware Capabilities
 */
#define UMA_HW_WAIT_3D_IDLE             0x80000000
#define UMA_HW_WAIT_2D_IDLE             0x40000000
#define INV_CR_WAIT_2D_IDLE             0x00400000
#define INV_CR_WAIT_3D_IDLE             0x00800000
#define INV_CR_2D_3D_COMMAND_START      0x00000000
#define INV_CR_3D_COMMAND_END_AND_WAIT  0x20000000
#define INV_CR_2D_COMMAND_END_AND_WAIT  0x30000000

#define FLAG_2D_3D_COMMAND_BEGIN 0x1
#define FLAG_2D_COMMAND_BEGIN_WAIT 0x1
#define FLAG_3D_COMMAND_BEGIN_WAIT 0x2

#define FLAG_WAIT_2D_IDLE 0x1
#define FLAG_WAIT_3D_IDLE 0x2

/*The following macro is for H2*/
#define HC_DUMMY		0xCCCCCCCC
#define HC_HEADER2		0xF210F110

#define HC_ParaType_NotTex      0x0001

#define ADD2DCmd_H2(pCmd, dwAddr, dwCmd)                  \
{                                                         \
    *(pCmd)++ = ( ((dwAddr) >> 2) | 0xF0000000 );         \
    *(pCmd)++ = (dwCmd);                                  \
}

#define Add2DHdr4Cmd_H2(pCmd, dwCount, id)                                         \
{                                                                                  \
    *(pCmd)++ = ((0xF6000000) | (((dwCount) << 9) & 0x1FFFE00) | ((id) & 0x1FF));  \
}

#define ALIGN_H2_CMD(_buf, _size)  do{                    \
    switch (_size & 0x7){                                 \
        case 2:                                           \
            _buf[_size++] = HC_HEADER2;                   \
            _buf[_size++] = (HC_ParaType_NotTex << 16) ;  \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            break;                                        \
        case 4:                                           \
            _buf[_size++] = HC_HEADER2;                   \
            _buf[_size++] = (HC_ParaType_NotTex << 16) ;  \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            break;                                        \
        case 6:                                           \
             _buf[_size++] = HC_HEADER2;                  \
            _buf[_size++] = (HC_ParaType_NotTex << 16) ;  \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            _buf[_size++] = HC_DUMMY;                     \
            break;                                        \
        case 0:                                           \
            break;                                        \
    }                                                     \
    }while(0)

#define ALIGN_H2_DATA(_buf, _size)                        \
do {                                                      \
    if(_size & 0x1)                                       \
    {                                                     \
        _buf[_size + 1] = _buf[_size];                    \
        _size++;                                          \
    }                                                     \
}while(0)

#define FLUSH_DMA_H2(pVia, _buf, _size)                   \
do{                                                       \
   int ret;                                               \
   drm_via_cmdbuffer_t bufI;                              \
   bufI.size=_size;                                       \
   bufI.buf= (char *)_buf;                                \
   do {                                                   \
        ret = drmCommandWrite(pVia->drmFD, DRM_VIA_CMDBUFFER, \
        &bufI, sizeof(bufI));                             \
    } while (ret == -EAGAIN);                             \
}while(0)                                                   

/*The following macro is for INV*/
/* NULL Command*/
extern DWORD NULL_COMMAND_INV[];

#define INV_HSWFlag_ADDR_ENCODE(x)   0xCC000000

#define INV_AGPHeader0              0xFE000000
#define INV_AGPHeader1              0xFE010000
#define INV_AGPHeader4              0xFE040000
#define H5_HC_DUMMY		0xCC000000

/* Transmission IO Space*/
#define INV_REG_23D_WAIT            0x326C
/*INV CR wait command*/
#define INV_CR_WAIT_ENGINE_IDLE             0x0000006C
#define INV_CR_2D_3D_ENGINE_STATE           0x00000060

#define ADDCmdHeader4_INVI(pCmd, dwAddr, dwCount, id)           \
{                                                               \
    while ( ((unsigned long)(pCmd)) & 0xF )                     \
    {                                                           \
        *(pCmd)++ = NULL_COMMAND_INV[((unsigned long)(pCmd)) & 0x3];\
    }                                                           \
    *(pCmd)++ = INV_AGPHeader4 | (dwAddr);                      \
    *(pCmd)++ = (dwCount);                                      \
    *(pCmd)++ = (id);                                           \
    *(pCmd)++ = 0;                                              \
}

#define ADDCmdHeader0_INVI(pCmd, dwCount);                      \
{                                                               \
    while ( ((unsigned long)(pCmd)) & 0xF )                     \
    {                                                           \
        *(pCmd)++ = NULL_COMMAND_INV[((unsigned long)(pCmd)) & 0x3];\
    }                                                           \
    *(pCmd)++ = INV_AGPHeader0;                                 \
    *(pCmd)++ = (dwCount);                                      \
    *(pCmd)++ = 0;                                              \
    *(pCmd)++ = (DWORD)INV_HSWFlag_ADDR_ENCODE(pCmd);           \
}

#define ADDCmdHeader1_INVI(pCmd, dwCount, dwAddr);              \
{                                                               \
    while ( ((unsigned long)(pCmd)) & 0xF )                     \
    {                                                           \
        *(pCmd)++ = H5_HC_DUMMY;                                \
    }                                                           \
    *(pCmd)++ = INV_AGPHeader1 | (dwAddr);                      \
    *(pCmd)++ = (dwCount);                                      \
    *(pCmd)++ = 0;                                              \
    *(pCmd)++ = (DWORD)INV_HSWFlag_ADDR_ENCODE(pCmd);           \
}

#define ADD2DCmd_INVI(pCmd, dwAddr, dwCmd)                  \
{                                                           \
    *(pCmd)++ = (dwAddr);                                   \
    *(pCmd)++ = (dwCmd);                                    \
}


#define FLUSH_DMA_INV(pVia, buf, size)                      \
do{                                                         \
     drm_s3g_flush_t bufI;                                  \
    int ret;                                                \
    bufI.dma_cmd_type = flush_dma_buffer;                   \
    bufI.cmd_size = size;                                   \
    bufI.usermode_dma_buf = buf;                            \
    do {                                                    \
        ret = drmCommandWrite(pVia->drmFD, DRM_S3G_FLUSH,   \
            &bufI, sizeof(bufI));                           \
    } while (ret == -EAGAIN);                               \
}while(0)

#define  FLUSE_AGP_CMD(pVia, IsH2, buf, size)               \
do{                                                         \
    unsigned int _n = size;                                 \
    volatile unsigned int*_pb = buf;                        \
    if(!(pVia->IsPCI)){                                     \
        if(IsH2)                                            \
        {                                                   \
            ALIGN_H2_CMD(_pb, _n);                          \
            FLUSH_DMA_H2(pVia, buf, 4*_n);                  \
        }                                                   \
        else                                                \
        {                                                   \
            while(_n&3){                                    \
                _pb[_n++] = H5_HC_DUMMY;                    \
            }                                               \
            FLUSH_DMA_INV(pVia, buf, _n);                   \
        }                                                   \
    }                                                       \
}while(0)
#endif
