/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*************************************************************************
 *
 *  File:       hw.h
 *  Content:    migration from frame buffer device driver's function.
 *
 ************************************************************************/

#ifndef __HW_H__
#define __HW_H__ 1

/* MISC */
#define ARRAY_SIZE(x)   (sizeof(x)/sizeof(*(x)))

/* Sequencer Registers */
#define SR01    0x01
#define SR10    0x10
#define SR12    0x12
#define SR15    0x15
#define SR16    0x16
#define SR17    0x17
#define SR18    0x18
#define SR1A    0x1A
#define SR1B    0x1B
#define SR1C    0x1C
#define SR1D    0x1D
#define SR1E    0x1E
#define SR1F    0x1F
#define SR19    0x19
#define SR20    0x20
#define SR21    0x21
#define SR22    0x22
#define SR26    0x26
#define SR2A    0x2A
#define SR2C    0x2C
#define SR2D    0x2D
#define SR2E    0x2E

#define SR39    0x39
#define SR3D    0x3D
#define SR3E    0x3E
#define SR3F    0x3F
#define SR40    0x40
#define SR42    0x42
#define SR43    0x43
#define SR44    0x44
#define SR45    0x45
#define SR46    0x46
#define SR47    0x47
#define SR48    0x48
#define SR49    0x49
#define SR4A    0x4A
#define SR4B    0x4B
#define SR4C    0x4C
#define SR4F    0x4F
#define SR50    0x50
#define SR52    0x52
#define SR57    0x57
#define SR58    0x58
#define SR59    0x59
#define SR5D    0x5D
#define SR5E    0x5E
#define SR65    0x65

/* VT3353 New Registers */
#define SR70    0x70
#define SR71    0x71
#define SR72    0x72
#define SR73    0x73
#define SR74    0x74
#define SR75    0x75


/* CRT Controller Registers */
#define CR00    0x00
#define CR01    0x01
#define CR02    0x02
#define CR03    0x03
#define CR04    0x04
#define CR05    0x05
#define CR06    0x06
#define CR07    0x07
#define CR08    0x08
#define CR09    0x09
#define CR0A    0x0A
#define CR0B    0x0B
#define CR0C    0x0C
#define CR0D    0x0D
#define CR0E    0x0E
#define CR0F    0x0F
#define CR10    0x10
#define CR11    0x11
#define CR12    0x12
#define CR13    0x13
#define CR14    0x14
#define CR15    0x15
#define CR16    0x16
#define CR17    0x17
#define CR18    0x18


/* Extend CRT Controller Registers */
#define CR30    0x30
#define CR31    0x31
#define CR32    0x32
#define CR33    0x33
#define CR34    0x34
#define CR35    0x35
#define CR36    0x36
#define CR37    0x37
#define CR38    0x38
#define CR39    0x39
#define CR3A    0x3A
#define CR3B    0x3B
#define CR3C    0x3C
#define CR3D    0x3D
#define CR3E    0x3E
#define CR3F    0x3F
#define CR40    0x40
#define CR41    0x41
#define CR42    0x42
#define CR43    0x43
#define CR44    0x44
#define CR45    0x45
#define CR46    0x46
#define CR47    0x47
#define CR48    0x48
#define CR49    0x49
#define CR4A    0x4A
#define CR4B    0x4B
#define CR4C    0x4C
#define CR4D    0x4D
#define CR4E    0x4E
#define CR4F    0x4F
#define CR50    0x50
#define CR51    0x51
#define CR52    0x52
#define CR53    0x53
#define CR54    0x54
#define CR55    0x55
#define CR56    0x56
#define CR57    0x57
#define CR58    0x58
#define CR59    0x59
#define CR5A    0x5A
#define CR5B    0x5B
#define CR5C    0x5C
#define CR5D    0x5D
#define CR5E    0x5E
#define CR5F    0x5F
#define CR60    0x60
#define CR61    0x61
#define CR62    0x62
#define CR63    0x63
#define CR64    0x64
#define CR65    0x65
#define CR66    0x66
#define CR67    0x67
#define CR68    0x68
#define CR69    0x69
#define CR6A    0x6A
#define CR6B    0x6B
#define CR6C    0x6C
#define CR6D    0x6D
#define CR6E    0x6E
#define CR6F    0x6F
#define CR70    0x70
#define CR71    0x71
#define CR72    0x72
#define CR73    0x73
#define CR74    0x74
#define CR75    0x75
#define CR76    0x76
#define CR77    0x77
#define CR78    0x78
#define CR79    0x79
#define CR7A    0x7A
#define CR7B    0x7B
#define CR7C    0x7C
#define CR7D    0x7D
#define CR7E    0x7E
#define CR7F    0x7F
#define CR80    0x80
#define CR81    0x81
#define CR82    0x82
#define CR83    0x83
#define CR84    0x84
#define CR85    0x85
#define CR86    0x86
#define CR87    0x87
#define CR88    0x88
#define CR89    0x89
#define CR8A    0x8A
#define CR8B    0x8B
#define CR8C    0x8C
#define CR8D    0x8D
#define CR8E    0x8E
#define CR8F    0x8F
#define CR90    0x90
#define CR91    0x91
#define CR92    0x92
#define CR93    0x93
#define CR94    0x94
#define CR95    0x95
#define CR96    0x96
#define CR97    0x97
#define CR98    0x98
#define CR99    0x99
#define CR9A    0x9A
#define CR9B    0x9B
#define CR9C    0x9C
#define CR9D    0x9D
#define CR9E    0x9E
#define CR9F    0x9F
#define CRA0    0xA0
#define CRA1    0xA1
#define CRA2    0xA2
#define CRA3    0xA3
#define CRA4    0xA4
#define CRA5    0xA5
#define CRA6    0xA6
#define CRA7    0xA7
#define CRA8    0xA8
#define CRA9    0xA9
#define CRAA    0xAA
#define CRAB    0xAB
#define CRAC    0xAC
#define CRD0    0xD0
#define CRD1    0xD1
#define CRD2    0xD2
#define CRD3    0xD3
#define CRD4    0xD4
#define CRD5    0xD5
#define CRD6    0xD6
#define CRD7    0xD7
#define CRD8    0xD8
#define CRD9    0xD9
#define CRDA    0xDA
#define CRDB    0xDB
#define CRDC    0xDC
#define CRDD    0xDD
#define CRDE    0xDE
#define CRDF    0xDF
#define CRE0    0xE0
#define CRE1    0xE1
#define CRE2    0xE2
#define CRE3    0xE3
#define CRE4    0xE4
#define CRE5    0xE5
#define CRE6    0xE6
#define CRE7    0xE7
#define CRE8    0xE8
#define CRE9    0xE9
#define CREA    0xEA
#define CREB    0xEB
#define CREC    0xEC
#define CRED    0xED
#define CREE    0xEE
#define CREF    0xEF
#define CRF0    0xF0
#define CRF1    0xF1
#define CRF2    0xF2
#define CRF3    0xF3
#define CRF4    0xF4
#define CRF5    0xF5
#define CRF6    0xF6
#define CRF7    0xF7
#define CRF8    0xF8
#define CRF9    0xF9
#define CRFA    0xFA
#define CRFB    0xFB
#define CRFC    0xFC
#define CRFD    0xFD
#define CRFE    0xFE
#define CRFF    0xFF

/* Definition Refresh Rate */
#define REFRESH_43      43
#define REFRESH_47      47
#define REFRESH_50      50
#define REFRESH_60      60
#define REFRESH_70      70
#define REFRESH_75      75
#define REFRESH_85      85
#define REFRESH_90      90
#define REFRESH_100     100
#define REFRESH_120     120
#define REFRESH_160     160

/* Definition Sync Polarity*/
#define NEGATIVE        1
#define POSITIVE        0

/* 640x480@60 Sync Polarity (DMT Mode) */
#define M640X480_R60_HSP        NEGATIVE
#define M640X480_R60_VSP        NEGATIVE

/* 640x480@75 Sync Polarity (DMT Mode) */
#define M640X480_R75_HSP        NEGATIVE
#define M640X480_R75_VSP        NEGATIVE

/* 640x480@85 Sync Polarity (DMT Mode) */
#define M640X480_R85_HSP        NEGATIVE
#define M640X480_R85_VSP        NEGATIVE

/* 640x480@100 Sync Polarity (GTF Mode) */
#define M640X480_R100_HSP       NEGATIVE
#define M640X480_R100_VSP       POSITIVE

/* 640x480@120 Sync Polarity (GTF Mode) */
#define M640X480_R120_HSP       NEGATIVE
#define M640X480_R120_VSP       POSITIVE

/* 640x480@160 Sync Polarity (CVT Mode)*/
#define M640X480_R160_HSP       NEGATIVE
#define M640X480_R160_VSP       POSITIVE

/* 720x480@60 Sync Polarity  (GTF Mode) */
#define M720X480_R60_HSP        NEGATIVE
#define M720X480_R60_VSP        POSITIVE

/* 720x576@60 Sync Polarity  (GTF Mode) */
#define M720X576_R60_HSP        NEGATIVE
#define M720X576_R60_VSP        POSITIVE

/* 800x480@60 Sync Polarity  (CVT Mode) */
#define M800X480_R60_HSP        NEGATIVE
#define M800X480_R60_VSP        POSITIVE

/* 800x600@60 Sync Polarity (DMT Mode) */
#define M800X600_R60_HSP        POSITIVE
#define M800X600_R60_VSP        POSITIVE

/* 800x600@75 Sync Polarity (DMT Mode) */
#define M800X600_R75_HSP        POSITIVE
#define M800X600_R75_VSP        POSITIVE

/* 800x600@85 Sync Polarity (DMT Mode) */
#define M800X600_R85_HSP        POSITIVE
#define M800X600_R85_VSP        POSITIVE

/* 800x600@100 Sync Polarity (GTF Mode) */
#define M800X600_R100_HSP       NEGATIVE
#define M800X600_R100_VSP       POSITIVE

/* 800x600@120 Sync Polarity (GTF Mode) */
#define M800X600_R120_HSP       NEGATIVE
#define M800X600_R120_VSP       POSITIVE

/* 800x600@160 Sync Polarity (CVT Mode) */
#define M800X600_R160_HSP       NEGATIVE
#define M800X600_R160_VSP       POSITIVE

/* 848x480@60 Sync Polarity  (CVT Mode) */
#define M848X480_R60_HSP        NEGATIVE
#define M848X480_R60_VSP        POSITIVE

/* 852x480@60 Sync Polarity  (GTF Mode) */
#define M852X480_R60_HSP        NEGATIVE
#define M852X480_R60_VSP        POSITIVE

/* 960x600@60 Sync Polarity (CVT Mode) */
#define M960X600_R60_HSP        POSITIVE
#define M960X600_R60_VSP        POSITIVE

/* 1000x600@60 Sync Polarity (GTF Mode) */
#define M1000X600_R60_HSP       NEGATIVE
#define M1000X600_R60_VSP       POSITIVE

/* 1024x512@60 Sync Polarity (GTF Mode) */
#define M1024X512_R60_HSP       NEGATIVE
#define M1024X512_R60_VSP       POSITIVE

/* 1024x576@60 Sync Polarity (GTF Mode) */
#define M1024X576_R60_HSP       POSITIVE
#define M1024X576_R60_VSP       POSITIVE

/*1024x600@60 Sync Polarity (GTF Mode)*/
#define M1024X600_R60_HSP       NEGATIVE            
#define M1024X600_R60_VSP       POSITIVE

/* 1024x768@60 Sync Polarity (DMT Mode) */
#define M1024X768_R60_HSP       NEGATIVE
#define M1024X768_R60_VSP       NEGATIVE

/* 1024x768@75 Sync Polarity (DMT Mode) */
#define M1024X768_R75_HSP       POSITIVE
#define M1024X768_R75_VSP       POSITIVE

/* 1024x768@85 Sync Polarity (DMT Mode) */
#define M1024X768_R85_HSP       POSITIVE
#define M1024X768_R85_VSP       POSITIVE

/* 1024x768@100 Sync Polarity (GTF Mode) */
#define M1024X768_R100_HSP      NEGATIVE
#define M1024X768_R100_VSP      POSITIVE

/* 1024x768@120 Sync Polarity (CVT Mode) */
#define M1024X768_R120_HSP      NEGATIVE
#define M1024X768_R120_VSP      POSITIVE

/* 1088x612@60 Sync Polarity (CVT Mode) */
#define M1088X612_R60_HSP       NEGATIVE
#define M1088X612_R60_VSP       POSITIVE

/* 1152x720@60 Sync Polarity (CVT Mode) */
#define M1152X720_R60_HSP       NEGATIVE
#define M1152X720_R60_VSP       POSITIVE

/* 1152x864@60 Sync Polarity (CVT Mode) */
#define M1152X864_R60_HSP       POSITIVE
#define M1152X864_R60_VSP       POSITIVE

/* 1152x864@70 Sync Polarity (CVT Mode) */
#define M1152X864_R70_HSP       POSITIVE
#define M1152X864_R70_VSP       POSITIVE

/* 1152x864@75 Sync Polarity (DMT Mode) */
#define M1152X864_R75_HSP       POSITIVE
#define M1152X864_R75_VSP       POSITIVE

/* 1200x720@60 Sync Polarity (GTF Mode) */
#define M1200X720_R60_HSP       NEGATIVE
#define M1200X720_R60_VSP       POSITIVE

/* 1280x600@60 Sync Polarity (GTF Mode) */
#define M1280x600_R60_HSP       NEGATIVE
#define M1280x600_R60_VSP       POSITIVE

/* 1280x720@50 Sync Polarity  (GTF Mode) */
#define M1280X720_R50_HSP       NEGATIVE
#define M1280X720_R50_VSP       POSITIVE

/* 1280x720@60 Sync Polarity  (GTF Mode) */
#define M1280X720_R60_HSP       POSITIVE
#define M1280X720_R60_VSP       POSITIVE

/* 1280x768@50 Sync Polarity  (GTF Mode) */
#define M1280X768_R50_HSP       NEGATIVE
#define M1280X768_R50_VSP       POSITIVE

/* 1280x768@60 Sync Polarity  (GTF Mode) */
#define M1280X768_R60_HSP       NEGATIVE
#define M1280X768_R60_VSP       POSITIVE

/* 1280x800@60 Sync Polarity  (CVT Mode) */
#define M1280X800_R60_HSP       NEGATIVE
#define M1280X800_R60_VSP       POSITIVE

/* 1280x854@60 Sync Polarity  (CVT Mode) */
#define M1280X854_R60_HSP       NEGATIVE
#define M1280X854_R60_VSP       POSITIVE

/* 1280x960@60 Sync Polarity (DMT Mode) */
#define M1280X960_R60_HSP       POSITIVE
#define M1280X960_R60_VSP       POSITIVE

/* 1280x1024@60 Sync Polarity (DMT Mode) */
#define M1280X1024_R60_HSP      POSITIVE
#define M1280X1024_R60_VSP      POSITIVE

/* 1280x1024@75 Sync Polarity (DMT Mode) */
#define M1280X1024_R75_HSP      POSITIVE
#define M1280X1024_R75_VSP      POSITIVE

/* 1280x1024@85 Sync Polarity (DMT Mode) */
#define M1280X1024_R85_HSP      POSITIVE
#define M1280X1024_R85_VSP      POSITIVE

/* 1360x768@60 Sync Polarity (CVT Mode) */
#define M1360X768_R60_HSP       POSITIVE
#define M1360X768_R60_VSP       POSITIVE

/* 1368x768@50 Sync Polarity (GTF Mode) */
#define M1368X768_R50_HSP       NEGATIVE
#define M1368X768_R50_VSP       POSITIVE

/* 1368x768@60 Sync Polarity (GTF Mode) */
#define M1368X768_R60_HSP       POSITIVE
#define M1368X768_R60_VSP       POSITIVE

/* 1400x1050@60 Sync Polarity (CVT Mode) */
#define M1400X1050_R60_HSP      NEGATIVE
#define M1400X1050_R60_VSP      POSITIVE

/* 1440x900@60 Sync Polarity (CVT Mode) */
#define M1440X900_R60_HSP       NEGATIVE
#define M1440X900_R60_VSP       POSITIVE

/* 1440x1050@60 Sync Polarity (GTF Mode) */
#define M1440X1050_R60_HSP      NEGATIVE
#define M1440X1050_R60_VSP      POSITIVE

/* 1600x900@60 Sync Polarity (CVT Mode) */
#define M1600X900_R60_HSP       NEGATIVE
#define M1600X900_R60_VSP       POSITIVE

/* 1600x1024@60 Sync Polarity (GTF Mode) */
#define M1600X1024_R60_HSP      NEGATIVE
#define M1600X1024_R60_VSP      POSITIVE

/* 1600x1200@60 Sync Polarity (DMT Mode) */
#define M1600X1200_R60_HSP      POSITIVE
#define M1600X1200_R60_VSP      POSITIVE

/* 1600x1200@75 Sync Polarity (DMT Mode) */
#define M1600X1200_R75_HSP      POSITIVE
#define M1600X1200_R75_VSP      POSITIVE

/* 1600x1200@85 Sync Polarity */
#define M1600X1200_R85_HSP      POSITIVE
#define M1600X1200_R85_VSP      POSITIVE

/* 1680x600@60 Sync Polarity (GTF Mode) */
#define M1680x600_R60_HSP       NEGATIVE
#define M1680x600_R60_VSP       POSITIVE

/* 1680x1050@60 Sync Polarity (CVT Mode) */
#define M1680x1050_R60_HSP      NEGATIVE
#define M1680x1050_R60_VSP      NEGATIVE

/* 1792x1344@60 Sync Polarity (DMT Mode) */
#define M1792x1344_R60_HSP      NEGATIVE
#define M1792x1344_R60_VSP      POSITIVE

/* 1856x1392@60 Sync Polarity (DMT Mode) */
#define M1856x1392_R60_HSP      NEGATIVE
#define M1856x1392_R60_VSP      POSITIVE

/* 1920x1080@60 Sync Polarity (CVT Mode) */
/*#define M1920X1080_R60_HSP      NEGATIVE
#define M1920X1080_R60_VSP      POSITIVE*/

/* 1920x1080@60 Sync Polarity */
#define M1920X1080_R60_HSP      POSITIVE
#define M1920X1080_R60_VSP      POSITIVE

/* 1920x1080@60 Sync Polarity (CVT Reduce Blanking Mode) */
#define M1920X1080_RB_R60_HSP  POSITIVE            
#define M1920X1080_RB_R60_VSP  NEGATIVE

/* 1920x1200@60 Sync Polarity (CVT Mode) */
#define M1920X1200_R60_HSP      NEGATIVE
#define M1920X1200_R60_VSP      POSITIVE

/* 1920x1200@60 Sync Polarity (CVT Mode) */
#define M1920X1200_RB_R60_HSP  POSITIVE            
#define M1920X1200_RB_R60_VSP  NEGATIVE

/* 1920x1440@60 Sync Polarity (DMT Mode) */
#define M1920X1440_R60_HSP      NEGATIVE
#define M1920X1440_R60_VSP      POSITIVE

/* 1920x1440@75 Sync Polarity (DMT Mode) */
#define M1920X1440_R75_HSP      NEGATIVE
#define M1920X1440_R75_VSP      POSITIVE

/* 1920x1440@85 Sync Polarity (CVT Mode) */
#define M1920X1440_R85_HSP      NEGATIVE
#define M1920X1440_R85_VSP      POSITIVE

/* 2048x1536@60 Sync Polarity (CVT Mode) */
#define M2048x1536_R60_HSP      NEGATIVE
#define M2048x1536_R60_VSP      POSITIVE

/* 2048x1536@75 Sync Polarity */
#define M2048X1536_R75_HSP      NEGATIVE
#define M2048X1536_R75_VSP      POSITIVE

/* 720X400@60 Sync Polarity (CVT Mode) */
#define M720X400_R90_HSP        NEGATIVE
#define M720X400_R90_VSP        POSITIVE

/* 832X624@60 Sync Polarity (CVT Mode) */
#define M832X624_R60_HSP        NEGATIVE
#define M832X624_R60_VSP        POSITIVE

/* define PLL index: */
#define CLK_22_000M     22000000
#define CLK_25_175M     25175000
#define CLK_26_719M     26719000
#define CLK_26_880M     26880000
#define CLK_27_000M     27000000
#define CLK_29_581M     29581000
#define CLK_29_829M     29829000
#define CLK_31_490M     31490000
#define CLK_31_500M     31500000
#define CLK_31_728M     31728000
#define CLK_32_668M     32688000
#define CLK_36_000M     36000000
#define CLK_40_000M     40000000
#define CLK_41_291M     41291000
#define CLK_43_163M     43163000
#define CLK_45_250M     45250000    /* 45.46MHz */
#define CLK_46_000M     46000000
#define CLK_46_980M     46980000
#define CLK_46_996M     46996000
#define CLK_48_000M     48000000
#define CLK_48_875M     48875000
#define CLK_49_500M     49500000
#define CLK_52_406M     52406000
#define CLK_52_977M     52977000
#define CLK_56_250M     56250000
#define CLK_60_466M     60466000
#define CLK_61_500M     61500000
#define CLK_65_000M     65000000
#define CLK_66_750M     66750000    /* 67.116MHz */
#define CLK_65_178M     65178000
#define CLK_67_295M     67295000
#define CLK_68_179M     68179000
#define CLK_68_369M     68369310
#define CLK_69_924M     69924000
#define CLK_70_159M     70159000
#define CLK_72_000M     72000000
#define CLK_73_023M     73023000
#define CLK_74_250M     74250000
#define CLK_74_481M     74481000
#define CLK_78_750M     78750000
#define CLK_79_466M     79466000
#define CLK_80_136M     80136000
#define CLK_81_627M     81627000
#define CLK_83_375M     83375000
#define CLK_83_527M     83527000
#define CLK_83_950M     83950000
#define CLK_84_537M     84537000
#define CLK_84_750M     84750000    /* 84.537Mhz */
#define CLK_85_500M     85500000
#define CLK_85_860M     85860000
#define CLK_85_909M     85909000
#define CLK_88_750M     88750000
#define CLK_89_489M     89489000
#define CLK_94_500M     94500000
#define CLK_96_648M     96648000
#define CLK_97_750M     97750000
#define CLK_101_000M    101000000
#define CLK_106_500M    106500000
#define CLK_108_000M    108000000
#define CLK_110_125M    110125000
#define CLK_112_000M    112000000
#define CLK_113_309M    113309000
#define CLK_115_000M    115000000
#define CLK_118_840M    118840000
#define CLK_119_000M    119000000
#define CLK_121_750M    121750000   /* 121.704MHz */
#define CLK_122_614M    122614000 
#define CLK_126_266M    126266000
#define CLK_130_250M    130250000   /* 130.250MHz */
#define CLK_135_000M    135000000
#define CLK_136_700M    136700000
#define CLK_137_750M    137750000
#define CLK_138_400M    138400000
#define CLK_144_300M    144300000
#define CLK_146_760M    146760000
#define CLK_148_500M    148500000
#define CLK_153_920M    153920000
#define CLK_156_000M    156000000
#define CLK_156_867M    156867000
#define CLK_157_500M    157500000
#define CLK_162_000M    162000000
#define CLK_172_798M    172798000
#define CLK_187_000M    187000000
#define CLK_193_295M    193295000
#define CLK_202_500M    202500000
#define CLK_204_000M    204000000
#define CLK_218_500M    218500000
#define CLK_229_500M    229500000
#define CLK_234_000M    234000000
#define CLK_267_250M    267250000
#define CLK_297_500M    297500000
#define CLK_339_500M    339500000
#define CLK_340_772M    340772000


/*K800 PLL value*/
#define K800_PLL_22_000M     0x00000000
#define K800_PLL_25_175M     0x00539001
#define K800_PLL_26_719M     0x00759002
#define K800_PLL_26_880M     0x001C8C80
#define K800_PLL_27_000M     0x00000000
/*#define K800_PLL_29_581M     0x00000000*/
/*#define K800_PLL_29_581M     0x00619081*/ /* 29.710 Mhz  */
#define K800_PLL_29_581M     0x00A49003 /* 29.531 Mhz  */
#define K800_PLL_29_829M     0x00A51003
#define K800_PLL_31_490M     0x006F9001
#define K800_PLL_31_500M     0x008B9002
#define K800_PLL_31_728M     0x00AF9003
#define K800_PLL_32_668M     0x00909002
#define K800_PLL_36_000M     0x009F9002
#define K800_PLL_40_000M     0x00578C02
#define K800_PLL_41_291M     0x00438C01
#define K800_PLL_43_163M     0x00778C03
#define K800_PLL_45_250M     0x007D8C83       /* 45.46MHz */
#define K800_PLL_46_000M     0x00658C02
#define K800_PLL_46_996M     0x00818C83
#define K800_PLL_48_000M     0x00848C83
#define K800_PLL_48_875M     0x00508C81
#define K800_PLL_49_500M     0x00518C01
#define K800_PLL_52_406M     0x00738C02
#define K800_PLL_52_977M     0x00928C83
#define K800_PLL_56_250M     0x007C8C02
#define K800_PLL_60_466M     0x00A78C83
#define K800_PLL_61_500M     0x00AA8C83
#define K800_PLL_65_000M     0x006B8C01
#define K800_PLL_65_178M     0x00B48C83
#define K800_PLL_66_750M     0x00948C82       /* 67.116MHz */
#define K800_PLL_67_295M     0x00BA8C83
#define K800_PLL_68_179M     0x00708C01
#define K800_pLL_68_369M     0x00BD8C83
#define K800_PLL_69_924M     0x00C18C83
#define K800_PLL_70_159M     0x00C28C83
#define K800_PLL_72_000M     0x009F8C82 
#define K800_PLL_73_023M     0x00CA0C03
#define K800_PLL_74_250M     0x00A48C82
#define K800_PLL_74_481M     0x007B8C81
#define K800_PLL_78_750M     0x00408801
#define K800_PLL_79_466M     0x006D8883
#define K800_PLL_80_136M     0x00428801
#define K800_PLL_81_627M     0x00700803
#define K800_PLL_83_375M     0x005B0882
#define K800_PLL_83_527M     0x00448881
#define K800_PLL_83_950M     0x00738803
#define K800_PLL_84_537M     0x00740803
#define K800_PLL_84_750M     0x00748883       /* 84.477MHz */
#define K800_PLL_85_500M     0x00768883
#define K800_PLL_85_860M     0x00768883
#define K800_PLL_85_909M     0x00760803
#define K800_PLL_88_750M     0x007A8883 
#define K800_PLL_89_489M     0x007B0803
#define K800_PLL_94_500M     0x00828803
#define K800_PLL_96_648M     0x00850803
#define K800_PLL_97_750M     0x00878883       
#define K800_PLL_101_000M    0x008B8883       
#define K800_PLL_106_500M    0x00758882        /* 106.491463 MHz */
#define K800_PLL_108_000M    0x00778882
#define K800_PLL_110_125M    0x00798882
#define K800_PLL_112_000M    0x00000000
#define K800_PLL_113_309M    0x005D8881
#define K800_PLL_115_000M    0x009F0803
#define K800_PLL_118_840M    0x00A48883
#define K800_PLL_119_000M    0x00838882       
#define K800_PLL_121_750M    0x00A88883       /* 121.704MHz */
#define K800_PLL_122_614M    0x00878882
#define K800_PLL_126_266M    0x00AF0803
#define K800_PLL_130_250M    0x00B48883        /* 130.250 */
#define K800_PLL_135_000M    0x001A4081
#define K800_PLL_136_700M    0x00BD8883
#define K800_PLL_137_750M    0x00BF0803
#define K800_PLL_138_400M    0x00998882
#define K800_PLL_144_300M    0x00778881
#define K800_PLL_146_760M    0x00CC8883
#define K800_PLL_148_500M    0x00518880			/* 148.5Mhz */
#define K800_PLL_153_920M    0x00548482
#define K800_PLL_156_000M    0x006B8483
#define K800_PLL_156_867M    0x006C0403
#define K800_PLL_157_500M    0x00142080
#define K800_PLL_162_000M    0x006F8483
#define K800_PLL_172_798M    0x00778483 
#define K800_PLL_187_000M    0x00818483       
#define K800_PLL_193_295M    0x004F8481
#define K800_PLL_202_500M    0x00538481
#define K800_PLL_204_000M    0x008D8483
#define K800_PLL_218_500M    0x00788482
#define K800_PLL_229_500M    0x009F0403
#define K800_PLL_234_000M    0x00608401
#define K800_PLL_267_250M    0x006E8481
#define K800_PLL_297_500M    0x00A48402
#define K800_PLL_339_500M    0x005D0002
#define K800_PLL_340_772M    0x00750003


/* PLL for VT3324 */
#define CX700_22_000M     0x00481001
#define CX700_25_175M     0x008B1003
#define CX700_26_719M     0x00931003
#define CX700_26_880M     0x00941003
#define CX700_27_000M     0x00959003
/*#define CX700_29_581M     0x00619081*/ /* 29.710 Mhz  */
#define CX700_29_581M     0x00A49003 /* 29.531 Mhz  */
#define CX700_29_829M     0x00A51003
#define CX700_31_490M     0x00AE1003
#define CX700_31_500M     0x00AE1003
#define CX700_31_728M     0x00AF1003
#define CX700_32_668M     0x00B51003
#define CX700_36_000M     0x00C81003
#define CX700_40_000M     0x006E0C03
#define CX700_41_291M     0x00710C03
#define CX700_43_163M     0x00770C03
#define CX700_45_250M     0x007D0C03       /* 45.46MHz */
#define CX700_46_000M     0x007F0C03
#define CX700_46_996M     0x00818C83
#define CX700_48_000M     0x00840C03
#define CX700_48_875M     0x00508C81
#define CX700_49_500M     0x00880C03
#define CX700_52_406M     0x00730C02
#define CX700_52_977M     0x00920C03
#define CX700_56_250M     0x009B0C03
#define CX700_60_466M     0x00460C00
#define CX700_61_500M     0x00AA0C03
#define CX700_65_000M     0x006B0C01
#define CX700_65_178M     0x006B0C01
#define CX700_66_750M     0x00940C02    /*67.116MHz */
#define CX700_67_295M     0x00BA0C03
#define CX700_68_179M     0x00BC0C03
#define CX700_68_369M     0x00BD0C03
#define CX700_69_924M     0x00C10C03
#define CX700_70_159M     0x00C20C03
#define CX700_72_000M     0x009F0C02
#define CX700_73_023M     0x00CA0C03
#define CX700_74_250M     0x00A40C02
#define CX700_74_481M     0x00CE0C03
#define CX700_78_750M     0x006C0803
#define CX700_79_466M     0x006D0803
#define CX700_80_136M     0x006E0803
#define CX700_81_627M     0x00700803
#define CX700_83_375M     0x005B0882
#define CX700_83_527M     0x00448881
#define CX700_83_950M     0x00730803
#define CX700_84_537M     0x00740803
#define CX700_84_750M     0x00740803       /* 84.537Mhz */
#define CX700_85_500M     0x00760803         /* 85.909080 MHz*/
#define CX700_85_860M     0x00760803
#define CX700_85_909M     0x00760803
#define CX700_88_750M     0x00AC8885
#define CX700_89_489M     0x007B0803
#define CX700_94_500M     0x00820803
#define CX700_96_648M     0x00850803
#define CX700_97_750M     0x00870803       
#define CX700_101_000M    0x008B0803       
#define CX700_106_500M    0x00750802
#define CX700_108_000M    0x00950803
#define CX700_110_125M    0x00980803
#define CX700_112_000M    0x009B0803
#define CX700_113_309M    0x005D0801
#define CX700_115_000M    0x009F0803
#define CX700_118_840M    0x00A40803
#define CX700_119_000M    0x00830802
#define CX700_121_750M    0x00420800       /* 121.704MHz */
#define CX700_122_614M    0x00870802       
#define CX700_126_266M    0x008B0802
#define CX700_130_250M    0x00B40803        /* 130.250 */
#define CX700_135_000M    0x00950802
#define CX700_136_700M    0x00BD0803
#define CX700_137_750M    0x00BF0803
#define CX700_138_400M    0x00720801
#define CX700_144_300M    0x00778881
#define CX700_146_760M    0x00CC0803
#define CX700_148_500M	  0x00A48802  
#define CX700_153_920M    0x00540402
#define CX700_156_000M    0x006B0403 
#define CX700_156_867M    0x006C0403
#define CX700_157_500M    0x006C0403
#define CX700_162_000M    0x006F0403
#define CX700_172_798M    0x00770403
#define CX700_187_000M    0x00810403       
#define CX700_193_295M    0x00850403
#define CX700_202_500M    0x008C0403
#define CX700_204_000M    0x008D0403
#define CX700_218_500M    0x00970403
#define CX700_229_500M    0x009F0403
#define CX700_234_000M    0x00A20403
#define CX700_267_250M    0x00B90403
#define CX700_297_500M    0x00CE0403
#define CX700_339_500M    0x005D0002
#define CX700_340_772M    0x00750003


/* PLL for VX855 */
#define VX855_22_000M     0x007B1005
#define VX855_25_175M     0x008D1005
#define VX855_26_719M     0x00961005
#define VX855_26_880M     0x00961005
#define VX855_27_000M     0x00971005
#define VX855_29_581M     0x00A51005
#define VX855_29_829M     0x00641003
#define VX855_31_490M     0x00B01005
#define VX855_31_500M     0x00B01005
#define VX855_31_728M     0x008E1004
#define VX855_32_668M     0x00921004
#define VX855_36_000M     0x00A11004
#define VX855_40_000M     0x00700C05
#define VX855_41_291M     0x00730C05
#define VX855_43_163M     0x00790C05
#define VX855_45_250M     0x007F0C05      /* 45.46MHz */
#define VX855_46_000M     0x00670C04
#define VX855_46_996M     0x00690C04
#define VX855_48_000M     0x00860C05
#define VX855_48_875M     0x00890C05
#define VX855_49_500M     0x00530C03
#define VX855_52_406M     0x00580C03
#define VX855_52_977M     0x00940C05
#define VX855_56_250M     0x009D0C05
#define VX855_60_466M     0x00A90C05
#define VX855_61_500M     0x00AC0C05
#define VX855_65_000M     0x006D0C03
#define VX855_65_178M     0x00B60C05
#define VX855_66_750M     0x00700C03    /*67.116MHz */
#define VX855_67_295M     0x00BC0C05
#define VX855_68_179M     0x00BF0C05
#define VX855_68_369M     0x00BF0C05
#define VX855_69_924M     0x00C30C05
#define VX855_70_159M     0x00C30C05
#define VX855_72_000M     0x00A10C04
#define VX855_73_023M     0x00CC0C05
#define VX855_74_250M     0x00A60C04
#define VX855_74_481M     0x00D10C05
#define VX855_78_750M     0x006E0805
#define VX855_79_466M     0x006F0805
#define VX855_80_136M     0x00700805
#define VX855_81_627M     0x00720805
#define VX855_83_375M     0x00750805
#define VX855_83_527M     0x00750805
#define VX855_83_950M     0x00750805
#define VX855_84_537M     0x00760805
#define VX855_84_750M     0x00760805     /* 84.537Mhz */
#define VX855_85_500M     0x00760805        /* 85.909080 MHz*/
#define VX855_85_860M     0x00760805
#define VX855_85_909M     0x00760805
#define VX855_88_750M     0x007C0805
#define VX855_89_489M     0x007D0805
#define VX855_94_500M     0x00840805
#define VX855_96_648M     0x00870805
#define VX855_97_750M     0x00890805      
#define VX855_101_000M    0x008D0805      
#define VX855_106_500M    0x00950805
#define VX855_108_000M    0x00970805
#define VX855_110_125M    0x00990805
#define VX855_112_000M    0x009D0805
#define VX855_113_309M    0x009F0805
#define VX855_115_000M    0x00A10805
#define VX855_118_840M    0x00A60805
#define VX855_119_000M    0x00A70805
#define VX855_121_750M    0x00AA0805       /* 121.704MHz */
#define VX855_122_614M    0x00AC0805      
#define VX855_126_266M    0x00B10805
#define VX855_130_250M    0x00B60805      /* 130.250 */
#define VX855_135_000M    0x00BD0805
#define VX855_136_700M    0x00BF0805
#define VX855_137_750M    0x00C10805
#define VX855_138_400M    0x00C20805
#define VX855_144_300M    0x00CA0805
#define VX855_146_760M    0x00CE0805
#define VX855_148_500M	  0x00D00805
#define VX855_153_920M    0x00540402
#define VX855_156_000M    0x006C0405
#define VX855_156_867M    0x006E0405
#define VX855_157_500M    0x006E0405
#define VX855_162_000M    0x00710405
#define VX855_172_798M    0x00790405
#define VX855_187_000M    0x00830405      
#define VX855_193_295M    0x00870405
#define VX855_202_500M    0x008E0405
#define VX855_204_000M    0x008F0405
#define VX855_218_500M    0x00990405
#define VX855_229_500M    0x00A10405
#define VX855_234_000M    0x00A40405
#define VX855_267_250M    0x00BB0405
#define VX855_297_500M    0x00D00405
#define VX855_339_500M    0x00770005
#define VX855_340_772M    0x00770005

/* Define Bit Field */
/*Fix me: Should share with video BIT define!!*/
#ifndef BIT0
#define BIT0    0x01
#endif
#ifndef BIT1
#define BIT1    0x02
#endif
#ifndef BIT2
#define BIT2    0x04
#endif
#ifndef BIT3
#define BIT3    0x08
#endif
#ifndef BIT4
#define BIT4    0x10
#endif
#ifndef BIT5
#define BIT5    0x20
#endif
#ifndef BIT6
#define BIT6    0x40
#endif
#ifndef BIT7
#define BIT7    0x80
#endif

/* Definition CRTC Timing Index */
#define H_TOTAL_INDEX               0
#define H_ADDR_INDEX                1
#define H_BLANK_START_INDEX         2
#define H_BLANK_END_INDEX           3
#define H_SYNC_START_INDEX          4
#define H_SYNC_END_INDEX            5
#define V_TOTAL_INDEX               6
#define V_ADDR_INDEX                7
#define V_BLANK_START_INDEX         8
#define V_BLANK_END_INDEX           9
#define V_SYNC_START_INDEX          10
#define V_SYNC_END_INDEX            11
#define H_TOTAL_SHADOW_INDEX        12
#define H_BLANK_END_SHADOW_INDEX    13
#define V_TOTAL_SHADOW_INDEX        14
#define V_ADDR_SHADOW_INDEX         15
#define V_BLANK_SATRT_SHADOW_INDEX  16
#define V_BLANK_END_SHADOW_INDEX    17
#define V_SYNC_SATRT_SHADOW_INDEX   18
#define V_SYNC_END_SHADOW_INDEX     19


/***************************************************/
/* Definition IGA1 Design Method of CRTC Registers */
/***************************************************/
#define IGA1_HOR_TOTAL_FORMULA(x)           ((x)/8)-5
#define IGA1_HOR_ADDR_FORMULA(x)            ((x)/8)-1
#define IGA1_HOR_BLANK_START_FORMULA(x)     ((x)/8)-1
#define IGA1_HOR_BLANK_END_FORMULA(x,y)     ((x+y)/8)-1
#define IGA1_HOR_SYNC_START_FORMULA(x)      ((x)/8)-1
#define IGA1_HOR_SYNC_END_FORMULA(x,y)      ((x+y)/8)-1

#define IGA1_VER_TOTAL_FORMULA(x)           (x)-2
#define IGA1_VER_ADDR_FORMULA(x)            (x)-1
#define IGA1_VER_BLANK_START_FORMULA(x)     (x)-1
#define IGA1_VER_BLANK_END_FORMULA(x,y)     (x+y)-1
#define IGA1_VER_SYNC_START_FORMULA(x)      (x)-1
#define IGA1_VER_SYNC_END_FORMULA(x,y)      (x+y)-1

/***************************************************/
/* Definition IGA2 Design Method of CRTC Registers */
/***************************************************/
#define IGA2_HOR_TOTAL_FORMULA(x)           (x)-1
#define IGA2_HOR_ADDR_FORMULA(x)            (x)-1
#define IGA2_HOR_BLANK_START_FORMULA(x)     (x)-1
#define IGA2_HOR_BLANK_END_FORMULA(x,y)     (x+y)-1
#define IGA2_HOR_SYNC_START_FORMULA(x)      (x)-1
#define IGA2_HOR_SYNC_END_FORMULA(x,y)      (x+y)-1

#define IGA2_VER_TOTAL_FORMULA(x)           (x)-1
#define IGA2_VER_ADDR_FORMULA(x)            (x)-1
#define IGA2_VER_BLANK_START_FORMULA(x)     (x)-1
#define IGA2_VER_BLANK_END_FORMULA(x,y)     (x+y)-1
#define IGA2_VER_SYNC_START_FORMULA(x)      (x)-1
#define IGA2_VER_SYNC_END_FORMULA(x,y)      (x+y)-1

/**********************************************************/
/* Definition IGA2 Design Method of CRTC Shadow Registers */
/**********************************************************/
#define IGA2_HOR_TOTAL_SHADOW_FORMULA(x)           (x/8)-5
#define IGA2_HOR_BLANK_END_SHADOW_FORMULA(x,y)     ((x+y)/8)-1
#define IGA2_VER_TOTAL_SHADOW_FORMULA(x)           (x)-2
#define IGA2_VER_ADDR_SHADOW_FORMULA(x)            (x)-1
#define IGA2_VER_BLANK_START_SHADOW_FORMULA(x)     (x)-1
#define IGA2_VER_BLANK_END_SHADOW_FORMULA(x,y)     (x+y)-1
#define IGA2_VER_SYNC_START_SHADOW_FORMULA(x)      (x)
#define IGA2_VER_SYNC_END_SHADOW_FORMULA(x,y)      (x+y)

/* Define Register Number for IGA1 CRTC Timing */
#define IGA1_HOR_TOTAL_REG_NUM          2           /* location: {CR00,0,7},{CR36,3,3} */
#define IGA1_HOR_ADDR_REG_NUM           1           /* location: {CR01,0,7} */
#define IGA1_HOR_BLANK_START_REG_NUM    1           /* location: {CR02,0,7} */
#define IGA1_HOR_BLANK_END_REG_NUM      3           /* location: {CR03,0,4},{CR05,7,7},{CR33,5,5} */
#define IGA1_HOR_SYNC_START_REG_NUM     2           /* location: {CR04,0,7},{CR33,4,4} */
#define IGA1_HOR_SYNC_END_REG_NUM       1           /* location: {CR05,0,4} */
#define IGA1_VER_TOTAL_REG_NUM          4           /* location: {CR06,0,7},{CR07,0,0},{CR07,5,5},{CR35,0,0} */
#define IGA1_VER_ADDR_REG_NUM           4           /* location: {CR12,0,7},{CR07,1,1},{CR07,6,6},{CR35,2,2} */
#define IGA1_VER_BLANK_START_REG_NUM    4           /* location: {CR15,0,7},{CR07,3,3},{CR09,5,5},{CR35,3,3} */
#define IGA1_VER_BLANK_END_REG_NUM      1           /* location: {CR16,0,7} */
#define IGA1_VER_SYNC_START_REG_NUM     4           /* location: {CR10,0,7},{CR07,2,2},{CR07,7,7},{CR35,1,1} */
#define IGA1_VER_SYNC_END_REG_NUM       1           /* location: {CR11,0,3} */

/* Define Register Number for IGA1 Shadow CRTC Timing */
#define IGA2_SHADOW_HOR_TOTAL_REG_NUM       2       /* location: {CR6D,0,7},{CR71,3,3} */
#define IGA2_SHADOW_HOR_BLANK_END_REG_NUM   1       /* location: {CR6E,0,7}            */
#define IGA2_SHADOW_VER_TOTAL_REG_NUM       2       /* location: {CR6F,0,7},{CR71,0,2} */
#define IGA2_SHADOW_VER_ADDR_REG_NUM        2       /* location: {CR70,0,7},{CR71,4,6} */
#define IGA2_SHADOW_VER_BLANK_START_REG_NUM 2       /* location: {CR72,0,7},{CR74,4,6} */
#define IGA2_SHADOW_VER_BLANK_END_REG_NUM   2       /* location: {CR73,0,7},{CR74,0,2} */
#define IGA2_SHADOW_VER_SYNC_START_REG_NUM  2       /* location: {CR75,0,7},{CR76,4,6} */
#define IGA2_SHADOW_VER_SYNC_END_REG_NUM    1       /* location: {CR76,0,3}            */

/* Define Register Number for IGA2 CRTC Timing */
#define IGA2_HOR_TOTAL_REG_NUM          2           /* location: {CR50,0,7},{CR55,0,3} */
#define IGA2_HOR_ADDR_REG_NUM           2           /* location: {CR51,0,7},{CR55,4,6} */
#define IGA2_HOR_BLANK_START_REG_NUM    2           /* location: {CR52,0,7},{CR54,0,2} */
#define IGA2_HOR_BLANK_END_REG_NUM      3           /* location: CLE266: {CR53,0,7},{CR54,3,5} => CLE266's CR5D[6] is reserved, so it may have problem to set 1600x1200 on IGA2. */
                                                    /*           Others: {CR53,0,7},{CR54,3,5},{CR5D,6,6} */
#define IGA2_HOR_SYNC_START_REG_NUM     4           /* location: {CR56,0,7},{CR54,6,7},{CR5C,7,7} */
                                                    /*           VT3314 and Later: {CR56,0,7},{CR54,6,7},{CR5C,7,7}, {CR5D,7,7} */
#define IGA2_HOR_SYNC_END_REG_NUM       2           /* location: {CR57,0,7},{CR5C,6,6} */
#define IGA2_VER_TOTAL_REG_NUM          2           /* location: {CR58,0,7},{CR5D,0,2} */
#define IGA2_VER_ADDR_REG_NUM           2           /* location: {CR59,0,7},{CR5D,3,5} */
#define IGA2_VER_BLANK_START_REG_NUM    2           /* location: {CR5A,0,7},{CR5C,0,2} */
#define IGA2_VER_BLANK_END_REG_NUM      2           /* location: {CR5E,0,7},{CR5C,3,5} */
#define IGA2_VER_SYNC_START_REG_NUM     2           /* location: {CR5E,0,7},{CR5F,5,7} */
#define IGA2_VER_SYNC_END_REG_NUM       1           /* location: {CR5F,0,4} */

/* Define Offset and Fetch Count Register*/
#define IGA1_OFFSET_REG_NUM             2                                 /* location: {CR13,0,7},{CR35,5,7} */
#define IGA1_OFFSER_ALIGN_BYTE          8                                 /* 8 bytes alignment. */
#define IGA1_OFFSET_FORMULA(x,y)        (x*y)/IGA1_OFFSER_ALIGN_BYTE      /* x: H resolution, y: color depth */

#define IGA1_FETCH_COUNT_REG_NUM        2                                 /* location: {SR1C,0,7},{SR1D,0,1} */
#define IGA1_FETCH_COUNT_ALIGN_BYTE     16                                /* 16 bytes alignment. */
#define IGA1_FETCH_COUNT_PATCH_VALUE    4
#define IGA1_FETCH_COUNT_FORMULA(x,y)   ((x*y)/IGA1_FETCH_COUNT_ALIGN_BYTE)+ IGA1_FETCH_COUNT_PATCH_VALUE




#define IGA2_OFFSET_REG_NUM             3           /* location: {CR66,0,07},{CR67,0,1}, {CR71,7,7} */
#define IGA2_OFFSET_ALIGN_BYTE		    8
#define IGA2_OFFSET_FORMULA(x,y)	    (x*y)/IGA2_OFFSET_ALIGN_BYTE	 /* x: H resolution, y: color depth */

#define IGA2_FETCH_COUNT_REG_NUM        2           /* location: {CR65,0,07},{CR67,2,3} */
#define IGA2_FETCH_COUNT_ALIGN_BYTE	    16
#define IGA2_FETCH_COUNT_PATCH_VALUE	0
#define IGA2_FETCH_COUNT_FORMULA(x,y)	((x*y)/IGA1_FETCH_COUNT_ALIGN_BYTE)+ IGA2_FETCH_COUNT_PATCH_VALUE

/*Define Display OFFSET*/
/*These value are by HW suggested value*/
/* VT3314 chipset*/
#define CN700_IGA1_FIFO_MAX_DEPTH               96 /* location: {SR17,0,7}*/
#define CN700_IGA1_FIFO_THRESHOLD               80 /* location: {SR16,0,5},{SR16,7,7}*/
#define CN700_IGA1_FIFO_HIGH_THRESHOLD          64  /* location: {SR18,0,5},{SR18,7,7}*/
#define CN700_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     0   /* location: {SR22,0,4}. (128/4) =64, P800 must be set zero, because HW only 5 bits*/

#define CN700_IGA2_FIFO_MAX_DEPTH               96  /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define CN700_IGA2_FIFO_THRESHOLD               80  /* location: {CR68,0,3},{CR95,4,6}*/
#define CN700_IGA2_FIFO_HIGH_THRESHOLD          32   /* location: {CR92,0,3},{CR95,0,2}*/
#define CN700_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     128 /* location: {CR94,0,6}*/

/* For VT3324, these values are suggested by HW */
#define CX700_IGA1_FIFO_MAX_DEPTH               192     /* location: {SR17,0,7}*/
#define CX700_IGA1_FIFO_THRESHOLD               128     /* location: {SR16,0,5},{SR16,7,7}*/
#define CX700_IGA1_FIFO_HIGH_THRESHOLD          128     /* location: {SR18,0,5},{SR18,7,7} */
#define CX700_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     124     /* location: {SR22,0,4} */

#define CX700_IGA2_FIFO_MAX_DEPTH               96      /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define CX700_IGA2_FIFO_THRESHOLD               64      /* location: {CR68,0,3},{CR95,4,6}*/
#define CX700_IGA2_FIFO_HIGH_THRESHOLD          32      /* location: {CR92,0,3},{CR95,0,2} */
#define CX700_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     128     /* location: {CR94,0,6}*/

/* VT3336 chipset*/
#define K8M890_IGA1_FIFO_MAX_DEPTH               360 /* location: {SR17,0,7}*/
#define K8M890_IGA1_FIFO_THRESHOLD               328 /* location: {SR16,0,5},{SR16,7,7}*/
#define K8M890_IGA1_FIFO_HIGH_THRESHOLD          296 /* location: {SR18,0,5},{SR18,7,7}*/
#define K8M890_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     124 /* location: {SR22,0,4}.*/

#define K8M890_IGA2_FIFO_MAX_DEPTH               360 /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define K8M890_IGA2_FIFO_THRESHOLD               328 /* location: {CR68,0,3},{CR95,4,6}*/
#define K8M890_IGA2_FIFO_HIGH_THRESHOLD          296 /* location: {CR92,0,3},{CR95,0,2}*/
#define K8M890_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     124 /* location: {CR94,0,6}*/


/* VT3327 chipset*/
#define P4M890_IGA1_FIFO_MAX_DEPTH               96  /* location: {SR17,0,7}*/
#define P4M890_IGA1_FIFO_THRESHOLD               76  /* location: {SR16,0,5},{SR16,7,7}*/
#define P4M890_IGA1_FIFO_HIGH_THRESHOLD          64  /* location: {SR18,0,5},{SR18,7,7}*/
#define P4M890_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     32  /* location: {SR22,0,4}. (32/4) =8*/

#define P4M890_IGA2_FIFO_MAX_DEPTH               96  /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define P4M890_IGA2_FIFO_THRESHOLD               76  /* location: {CR68,0,3},{CR95,4,6}*/
#define P4M890_IGA2_FIFO_HIGH_THRESHOLD          64  /* location: {CR92,0,3},{CR95,0,2}*/
#define P4M890_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     32  /* location: {CR94,0,6}*/


/* VT3364 chipset*/
#define P4M900_IGA1_FIFO_MAX_DEPTH               96     /* location: {SR17,0,7}*/
#define P4M900_IGA1_FIFO_THRESHOLD               76     /* location: {SR16,0,5},{SR16,7,7}*/
#define P4M900_IGA1_FIFO_HIGH_THRESHOLD          76     /* location: {SR18,0,5},{SR18,7,7}*/
#define P4M900_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     32     /* location: {SR22,0,4}.*/

#define P4M900_IGA2_FIFO_MAX_DEPTH               96     /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define P4M900_IGA2_FIFO_THRESHOLD               76     /* location: {CR68,0,3},{CR95,4,6}*/
#define P4M900_IGA2_FIFO_HIGH_THRESHOLD          76     /* location: {CR92,0,3},{CR95,0,2}*/
#define P4M900_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     32     /* location: {CR94,0,6}*/

/* For VT3353, these values are suggested by HW */
#define VX800_IGA1_FIFO_MAX_DEPTH               192     /* location: {SR17,0,7}*/
#define VX800_IGA1_FIFO_THRESHOLD               152     /* location: {SR16,0,5},{SR16,7,7}*/
#define VX800_IGA1_FIFO_HIGH_THRESHOLD          152     /* location: {SR18,0,5},{SR18,7,7} */
#define VX800_IGA1_DISPLAY_QUEUE_EXPIRE_NUM      64     /* location: {SR22,0,4} */

#define VX800_IGA2_FIFO_MAX_DEPTH               96      /* location: {CR68,4,7},{CR94,7,7},{CR95,7,7}*/
#define VX800_IGA2_FIFO_THRESHOLD               64      /* location: {CR68,0,3},{CR95,4,6}*/
#define VX800_IGA2_FIFO_HIGH_THRESHOLD          32      /* location: {CR92,0,3},{CR95,0,2} */
#define VX800_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     128     /* location: {CR94,0,6}*/

/* For VT3409 */
#define VX855_IGA1_FIFO_MAX_DEPTH               400
#define VX855_IGA1_FIFO_THRESHOLD               320
#define VX855_IGA1_FIFO_HIGH_THRESHOLD          320
#define VX855_IGA1_DISPLAY_QUEUE_EXPIRE_NUM     160

#define VX855_IGA2_FIFO_MAX_DEPTH               200
#define VX855_IGA2_FIFO_THRESHOLD               160
#define VX855_IGA2_FIFO_HIGH_THRESHOLD          160
#define VX855_IGA2_DISPLAY_QUEUE_EXPIRE_NUM     320

#define IGA1_FIFO_DEPTH_SELECT_REG_NUM          1
#define IGA1_FIFO_THRESHOLD_REG_NUM             2
#define IGA1_FIFO_HIGH_THRESHOLD_REG_NUM        2
#define IGA1_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM   1

#define IGA2_FIFO_DEPTH_SELECT_REG_NUM          3
#define IGA2_FIFO_THRESHOLD_REG_NUM             2
#define IGA2_FIFO_HIGH_THRESHOLD_REG_NUM        2
#define IGA2_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM   1


#define IGA1_FIFO_DEPTH_SELECT_FORMULA(x)                   (x/2)-1
#define IGA1_FIFO_THRESHOLD_FORMULA(x)                      (x/4)
#define IGA1_DISPLAY_QUEUE_EXPIRE_NUM_FORMULA(x)            (x/4)
#define IGA1_FIFO_HIGH_THRESHOLD_FORMULA(x)                 (x/4)
#define IGA2_FIFO_DEPTH_SELECT_FORMULA(x)                   ((x/2)/4)-1
#define IGA2_FIFO_THRESHOLD_FORMULA(x)                      (x/4)
#define IGA2_DISPLAY_QUEUE_EXPIRE_NUM_FORMULA(x)            (x/4)
#define IGA2_FIFO_HIGH_THRESHOLD_FORMULA(x)                 (x/4)


/* LCD Scaling factor                  */
/* x: indicate setting horizontal size */
/* y: indicate panel horizontal size   */
#define CLE266_LCD_HOR_SCF_FORMULA(x,y)     (((x-1)*1024)/(y-1))    /* Horizontal scaling factor 10 bits (2^10) */
#define CLE266_LCD_VER_SCF_FORMULA(x,y)     (((x-1)*1024)/(y-1))    /* Vertical scaling factor 10 bits (2^10)   */
#define K800_LCD_HOR_SCF_FORMULA(x,y)       (((x-1)*4096)/(y-1))    /* Horizontal scaling factor 10 bits (2^12) */
#define K800_LCD_VER_SCF_FORMULA(x,y)       (((x-1)*2048)/(y-1))    /* Vertical scaling factor 10 bits (2^11)   */

#define LCD_HOR_SCALING_FACTOR_REG_NUM      3               /* location: {CR9F,0,1},{CR77,0,7},{CR79,4,5} */
#define LCD_VER_SCALING_FACTOR_REG_NUM      3               /* location: {CR79,3,3},{CR78,0,7},{CR79,6,7} */

/* Cacalate PLL */
#define SORT_BY_PHASE_MARGIN    1
#define SORT_BY_F_REF_BW        2
#define SORT_BY_PIXEL_CLOCK     3

#define FIN     14.31818
#define PI      3.141592654
#define TWO_PI  6.283185307

typedef struct 
{    
    double clock;
    int M;
    int N;
    int R;
    double f_refDivBW;
    double PhaseMargin;
}CLOCK_SETTING;


/*Define display timing*/

struct display_timing {
    CARD16  hor_total;
    CARD16  hor_addr;
    CARD16  hor_blank_start;
    CARD16  hor_blank_end;
    CARD16  hor_sync_start;
    CARD16  hor_sync_end;
    CARD16  ver_total;
    CARD16  ver_addr;
    CARD16  ver_blank_start;
    CARD16  ver_blank_end;
    CARD16  ver_sync_start;
    CARD16  ver_sync_end;
};

/************************************************/
/*      Define IGA1 Display Timing              */
/************************************************/
struct io_register {
    CARD8   io_addr;
    CARD8   start_bit;
    CARD8   end_bit;
};


/* IGA1 Horizontal Total */
struct iga1_hor_total
{
    int     reg_num;
    struct  io_register reg[IGA1_HOR_TOTAL_REG_NUM];
};

/* IGA1 Horizontal Addressable Video */
struct iga1_hor_addr {
    int     reg_num;
    struct  io_register reg[IGA1_HOR_ADDR_REG_NUM];
};

/* IGA1 Horizontal Blank Start */
struct iga1_hor_blank_start {
    int     reg_num;
    struct  io_register reg[IGA1_HOR_BLANK_START_REG_NUM];
};

/* IGA1 Horizontal Blank End */
struct iga1_hor_blank_end {
    int     reg_num;
    struct  io_register reg[IGA1_HOR_BLANK_END_REG_NUM];
};

/* IGA1 Horizontal Sync Start */
struct iga1_hor_sync_start {
    int     reg_num;
    struct  io_register reg[IGA1_HOR_SYNC_START_REG_NUM];
};

/* IGA1 Horizontal Sync End */
struct iga1_hor_sync_end {
    int     reg_num;
    struct  io_register reg[IGA1_HOR_SYNC_END_REG_NUM];
};

/* IGA1 Vertical Total */
struct iga1_ver_total {
    int     reg_num;
    struct  io_register reg[IGA1_VER_TOTAL_REG_NUM];
};

/* IGA1 Vertical Addressable Video */
struct iga1_ver_addr {
    int     reg_num;
    struct  io_register reg[IGA1_VER_ADDR_REG_NUM];
};

/* IGA1 Vertical Blank Start */
struct iga1_ver_blank_start {
    int     reg_num;
    struct  io_register reg[IGA1_VER_BLANK_START_REG_NUM];
};

/* IGA1 Vertical Blank End */
struct iga1_ver_blank_end {
    int     reg_num;
    struct  io_register reg[IGA1_VER_BLANK_END_REG_NUM];
};

/* IGA1 Vertical Sync Start */
struct iga1_ver_sync_start {
    int     reg_num;
    struct  io_register reg[IGA1_VER_SYNC_START_REG_NUM];
};

/* IGA1 Vertical Sync End */
struct iga1_ver_sync_end {
    int     reg_num;
    struct  io_register reg[IGA1_VER_SYNC_END_REG_NUM];
};

/************************************************/
/*      Define IGA2 Shadow Display Timing       */
/************************************************/

/* IGA2 Shadow Horizontal Total */
struct iga2_shadow_hor_total {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_HOR_TOTAL_REG_NUM];
};

/* IGA2 Shadow Horizontal Blank End */
struct iga2_shadow_hor_blank_end {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_HOR_BLANK_END_REG_NUM];
};

/* IGA2 Shadow Vertical Total */
struct iga2_shadow_ver_total {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_TOTAL_REG_NUM];
};

/* IGA2 Shadow Vertical Addressable Video */
struct iga2_shadow_ver_addr {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_ADDR_REG_NUM];
};

/* IGA2 Shadow Vertical Blank Start */
struct iga2_shadow_ver_blank_start {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_BLANK_START_REG_NUM];
};

/* IGA2 Shadow Vertical Blank End */
struct iga2_shadow_ver_blank_end {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_BLANK_END_REG_NUM];
};

/* IGA2 Shadow Vertical Sync Start */
struct iga2_shadow_ver_sync_start {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_SYNC_START_REG_NUM];
};

/* IGA2 Shadow Vertical Sync End */
struct iga2_shadow_ver_sync_end {
    int     reg_num;
    struct  io_register reg[IGA2_SHADOW_VER_SYNC_END_REG_NUM];
};

/************************************************/
/*      Define IGA2 Display Timing              */
/************************************************/

/* IGA2 Horizontal Total */
struct iga2_hor_total {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_TOTAL_REG_NUM];
};

/* IGA2 Horizontal Addressable Video */
struct iga2_hor_addr {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_ADDR_REG_NUM];
};

/* IGA2 Horizontal Blank Start */
struct iga2_hor_blank_start {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_BLANK_START_REG_NUM];
};

/* IGA2 Horizontal Blank End */
struct iga2_hor_blank_end {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_BLANK_END_REG_NUM];
};

/* IGA2 Horizontal Sync Start */
struct iga2_hor_sync_start {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_SYNC_START_REG_NUM];
};

/* IGA2 Horizontal Sync End */
struct iga2_hor_sync_end {
    int     reg_num;
    struct  io_register reg[IGA2_HOR_SYNC_END_REG_NUM];
};

/* IGA2 Vertical Total */
struct iga2_ver_total {
    int     reg_num;
    struct  io_register reg[IGA2_VER_TOTAL_REG_NUM];
};

/* IGA2 Vertical Addressable Video */
struct iga2_ver_addr {
    int     reg_num;
    struct  io_register reg[IGA2_VER_ADDR_REG_NUM];
};

/* IGA2 Vertical Blank Start */
struct iga2_ver_blank_start {
    int     reg_num;
    struct  io_register reg[IGA2_VER_BLANK_START_REG_NUM];
};

/* IGA2 Vertical Blank End */
struct iga2_ver_blank_end {
    int     reg_num;
    struct  io_register reg[IGA2_VER_BLANK_END_REG_NUM];
};

/* IGA2 Vertical Sync Start */
struct iga2_ver_sync_start {
    int     reg_num;
    struct  io_register reg[IGA2_VER_SYNC_START_REG_NUM];
};

/* IGA2 Vertical Sync End */
struct iga2_ver_sync_end {
    int     reg_num;
    struct  io_register reg[IGA2_VER_SYNC_END_REG_NUM];
};

/* IGA1 Offset Register */
struct iga1_offset {
    int     reg_num;
    struct  io_register reg[IGA1_OFFSET_REG_NUM];
};

/* IGA2 Offset Register */
struct iga2_offset {
    int     reg_num;
    struct  io_register reg[IGA2_OFFSET_REG_NUM];
};

struct offset{
    struct iga1_offset            iga1_offset_reg;
    struct iga2_offset            iga2_offset_reg;
};

/* IGA1 Fetch Count Register */
struct iga1_fetch_count {
    int     reg_num;
    struct  io_register reg[IGA1_FETCH_COUNT_REG_NUM];
};

/* IGA2 Fetch Count Register */
struct iga2_fetch_count {
    int     reg_num;
    struct  io_register reg[IGA2_FETCH_COUNT_REG_NUM];
};

struct fetch_count{
    struct iga1_fetch_count       iga1_fetch_count_reg;
    struct iga2_fetch_count       iga2_fetch_count_reg;
};

struct pll_map {
    CARD32  clk;
    CARD32  k800_pll;
    CARD32  cx700_pll;
    CARD32  vx855_pll;
};

/* LCD Scaling Factor */
struct _lcd_hor_scaling_factor{
    int     reg_num;
    struct  io_register reg[LCD_HOR_SCALING_FACTOR_REG_NUM];
};

struct _lcd_ver_scaling_factor{
    int     reg_num;
    struct  io_register reg[LCD_VER_SCALING_FACTOR_REG_NUM];
};

struct _lcd_scaling_factor{
    struct _lcd_hor_scaling_factor  lcd_hor_scaling_factor;
    struct _lcd_ver_scaling_factor  lcd_ver_scaling_factor;
};

/*Display FIFO Relation Registers*/
struct iga1_fifo_depth_select {
    int     reg_num;
    struct  io_register reg[IGA1_FIFO_DEPTH_SELECT_REG_NUM];
};

struct iga1_fifo_threshold_select {
    int     reg_num;
    struct  io_register reg[IGA1_FIFO_THRESHOLD_REG_NUM];
};

struct iga1_fifo_high_threshold_select {
    int     reg_num;
    struct  io_register reg[IGA1_FIFO_HIGH_THRESHOLD_REG_NUM];
};

struct iga1_display_queue_expire_num {
    int     reg_num;
    struct  io_register reg[IGA1_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM];
};

struct iga2_fifo_depth_select {
    int     reg_num;
    struct  io_register reg[IGA2_FIFO_DEPTH_SELECT_REG_NUM];
};

struct iga2_fifo_threshold_select {
    int     reg_num;
    struct  io_register reg[IGA2_FIFO_THRESHOLD_REG_NUM];
};

struct iga2_fifo_high_threshold_select {
    int     reg_num;
    struct  io_register reg[IGA2_FIFO_HIGH_THRESHOLD_REG_NUM];
};

struct iga2_display_queue_expire_num {
    int     reg_num;
    struct  io_register reg[IGA2_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM];
};

struct fifo_depth_select {
    struct  iga1_fifo_depth_select iga1_fifo_depth_select_reg;
    struct  iga2_fifo_depth_select iga2_fifo_depth_select_reg;
};

struct fifo_threshold_select {
    struct  iga1_fifo_threshold_select iga1_fifo_threshold_select_reg;
    struct  iga2_fifo_threshold_select iga2_fifo_threshold_select_reg;
};

struct fifo_high_threshold_select {
    struct  iga1_fifo_high_threshold_select iga1_fifo_high_threshold_select_reg;
    struct  iga2_fifo_high_threshold_select iga2_fifo_high_threshold_select_reg;
};

struct display_queue_expire_num {
    struct  iga1_display_queue_expire_num iga1_display_queue_expire_num_reg;
    struct  iga2_display_queue_expire_num iga2_display_queue_expire_num_reg;
};



struct iga1_crtc_timing {
    struct iga1_hor_total         hor_total;
    struct iga1_hor_addr          hor_addr;
    struct iga1_hor_blank_start   hor_blank_start;
    struct iga1_hor_blank_end     hor_blank_end;
    struct iga1_hor_sync_start    hor_sync_start;
    struct iga1_hor_sync_end      hor_sync_end;
    struct iga1_ver_total         ver_total;
    struct iga1_ver_addr          ver_addr;
    struct iga1_ver_blank_start   ver_blank_start;
    struct iga1_ver_blank_end     ver_blank_end;
    struct iga1_ver_sync_start    ver_sync_start;
    struct iga1_ver_sync_end      ver_sync_end;
};

struct iga2_shadow_crtc_timing {
    struct iga2_shadow_hor_total        hor_total_shadow;
    struct iga2_shadow_hor_blank_end    hor_blank_end_shadow;
    struct iga2_shadow_ver_total        ver_total_shadow;
    struct iga2_shadow_ver_addr         ver_addr_shadow;
    struct iga2_shadow_ver_blank_start  ver_blank_start_shadow;
    struct iga2_shadow_ver_blank_end    ver_blank_end_shadow;
    struct iga2_shadow_ver_sync_start   ver_sync_start_shadow;
    struct iga2_shadow_ver_sync_end     ver_sync_end_shadow;
};

struct iga2_crtc_timing {
    struct iga2_hor_total         hor_total;
    struct iga2_hor_addr          hor_addr;
    struct iga2_hor_blank_start   hor_blank_start;
    struct iga2_hor_blank_end     hor_blank_end;
    struct iga2_hor_sync_start    hor_sync_start;
    struct iga2_hor_sync_end      hor_sync_end;
    struct iga2_ver_total         ver_total;
    struct iga2_ver_addr          ver_addr;
    struct iga2_ver_blank_start   ver_blank_start;
    struct iga2_ver_blank_end     ver_blank_end;
    struct iga2_ver_sync_start    ver_sync_start;
    struct iga2_ver_sync_end      ver_sync_end;
};


static struct pll_map pll_value[] = {
    {CLK_22_000M,  K800_PLL_22_000M,  CX700_22_000M,  VX855_22_000M},
    {CLK_25_175M,  K800_PLL_25_175M,  CX700_25_175M,  VX855_25_175M},
    {CLK_26_719M,  K800_PLL_26_719M,  CX700_26_719M,  VX855_26_719M},
    {CLK_26_880M,  K800_PLL_26_880M,  CX700_26_880M,  VX855_26_880M},
    {CLK_27_000M,  K800_PLL_27_000M,  CX700_27_000M,  VX855_27_000M},
    {CLK_29_581M,  K800_PLL_29_581M,  CX700_29_581M,  VX855_29_581M},
    {CLK_29_829M,  K800_PLL_29_829M,  CX700_29_829M,  VX855_29_829M},
    {CLK_31_490M,  K800_PLL_31_490M,  CX700_31_490M,  VX855_31_490M},
    {CLK_31_500M,  K800_PLL_31_500M,  CX700_31_500M,  VX855_31_500M},
    {CLK_31_728M,  K800_PLL_31_728M,  CX700_31_728M,  VX855_31_728M},
    {CLK_32_668M,  K800_PLL_32_668M,  CX700_32_668M,  VX855_32_668M},
    {CLK_36_000M,  K800_PLL_36_000M,  CX700_36_000M,  VX855_36_000M},
    {CLK_40_000M,  K800_PLL_40_000M,  CX700_40_000M,  VX855_40_000M},
    {CLK_41_291M,  K800_PLL_41_291M,  CX700_41_291M,  VX855_41_291M},
    {CLK_43_163M,  K800_PLL_43_163M,  CX700_43_163M,  VX855_43_163M},
    {CLK_45_250M,  K800_PLL_45_250M,  CX700_45_250M,  VX855_45_250M},
    {CLK_46_000M,  K800_PLL_46_000M,  CX700_46_000M,  VX855_46_000M},
    {CLK_46_996M,  K800_PLL_46_996M,  CX700_46_996M,  VX855_46_996M},
    {CLK_48_000M,  K800_PLL_48_000M,  CX700_48_000M,  VX855_48_000M},
    {CLK_48_875M,  K800_PLL_48_875M,  CX700_48_875M,  VX855_48_875M},
    {CLK_49_500M,  K800_PLL_49_500M,  CX700_49_500M,  VX855_49_500M},    
    {CLK_52_406M,  K800_PLL_52_406M,  CX700_52_406M,  VX855_52_406M},
    {CLK_52_977M,  K800_PLL_52_977M,  CX700_52_977M,  VX855_52_977M},
    {CLK_56_250M,  K800_PLL_56_250M,  CX700_56_250M,  VX855_56_250M},
    {CLK_60_466M,  K800_PLL_60_466M,  CX700_60_466M,  VX855_60_466M},
    {CLK_61_500M,  K800_PLL_61_500M,  CX700_61_500M,  VX855_61_500M},
    {CLK_65_000M,  K800_PLL_65_000M,  CX700_65_000M,  VX855_65_000M},
    {CLK_65_178M,  K800_PLL_65_178M,  CX700_65_178M,  VX855_65_178M},
    {CLK_66_750M,  K800_PLL_66_750M,  CX700_66_750M,  VX855_66_750M},
    {CLK_67_295M,  K800_PLL_67_295M,  CX700_67_295M,  VX855_67_295M},
    {CLK_68_179M,  K800_PLL_68_179M,  CX700_68_179M,  VX855_68_179M},
    {CLK_68_369M,  K800_pLL_68_369M,  CX700_68_369M,  VX855_68_369M},
    {CLK_69_924M,  K800_PLL_69_924M,  CX700_69_924M,  VX855_69_924M},
    {CLK_70_159M,  K800_PLL_70_159M,  CX700_70_159M,  VX855_70_159M},
    {CLK_72_000M,  K800_PLL_72_000M,  CX700_72_000M,  VX855_72_000M},
    {CLK_73_023M,  K800_PLL_73_023M,  CX700_73_023M,  VX855_73_023M},
    {CLK_74_250M,  K800_PLL_74_250M,  CX700_74_250M,  VX855_74_250M},    
    {CLK_74_481M,  K800_PLL_74_481M,  CX700_74_481M,  VX855_74_481M},
    {CLK_78_750M,  K800_PLL_78_750M,  CX700_78_750M,  VX855_78_750M},
    {CLK_79_466M,  K800_PLL_79_466M,  CX700_79_466M,  VX855_79_466M},
    {CLK_80_136M,  K800_PLL_80_136M,  CX700_80_136M,  VX855_80_136M},
    {CLK_81_627M,  K800_PLL_81_627M,  CX700_81_627M,  VX855_81_627M},
    {CLK_83_375M,  K800_PLL_83_375M,  CX700_83_375M,  VX855_83_375M},    
    {CLK_83_527M,  K800_PLL_83_527M,  CX700_83_527M,  VX855_83_527M},
    {CLK_83_950M,  K800_PLL_83_950M,  CX700_83_950M,  VX855_83_950M},
    {CLK_84_537M,  K800_PLL_84_537M,  CX700_84_537M,  VX855_84_537M},
    {CLK_84_750M,  K800_PLL_84_750M,  CX700_84_750M,  VX855_84_750M},
    {CLK_85_500M,  K800_PLL_85_500M,  CX700_85_500M,  VX855_85_500M},
    {CLK_85_860M,  K800_PLL_85_860M,  CX700_85_860M,  VX855_85_860M},
    {CLK_85_909M,  K800_PLL_85_909M,  CX700_85_909M,  VX855_85_909M},
    {CLK_88_750M,  K800_PLL_88_750M,  CX700_88_750M,  VX855_88_750M},
    {CLK_89_489M,  K800_PLL_89_489M,  CX700_89_489M,  VX855_89_489M},
    {CLK_94_500M,  K800_PLL_94_500M,  CX700_94_500M,  VX855_94_500M},
    {CLK_96_648M,  K800_PLL_96_648M,  CX700_96_648M,  VX855_96_648M},
    {CLK_97_750M,  K800_PLL_97_750M,  CX700_97_750M,  VX855_97_750M},
    {CLK_101_000M, K800_PLL_101_000M, CX700_101_000M, VX855_101_000M},
    {CLK_106_500M, K800_PLL_106_500M, CX700_106_500M, VX855_106_500M},
    {CLK_108_000M, K800_PLL_108_000M, CX700_108_000M, VX855_108_000M},
    {CLK_110_125M, K800_PLL_110_125M, CX700_110_125M, VX855_110_125M},
    {CLK_112_000M, K800_PLL_112_000M, CX700_112_000M, VX855_112_000M},
    {CLK_113_309M, K800_PLL_113_309M, CX700_113_309M, VX855_113_309M},
    {CLK_115_000M, K800_PLL_115_000M, CX700_115_000M, VX855_115_000M},
    {CLK_118_840M, K800_PLL_118_840M, CX700_118_840M, VX855_118_840M},
    {CLK_119_000M, K800_PLL_119_000M, CX700_119_000M, VX855_119_000M},
    {CLK_121_750M, K800_PLL_121_750M, CX700_121_750M, VX855_121_750M},
    {CLK_122_614M, K800_PLL_122_614M, CX700_122_614M, VX855_122_614M},
    {CLK_126_266M, K800_PLL_126_266M, CX700_126_266M, VX855_126_266M},
    {CLK_130_250M, K800_PLL_130_250M, CX700_130_250M, VX855_130_250M},
    {CLK_135_000M, K800_PLL_135_000M, CX700_135_000M, VX855_135_000M},
    {CLK_136_700M, K800_PLL_136_700M, CX700_136_700M, VX855_136_700M},
    {CLK_137_750M, K800_PLL_137_750M, CX700_137_750M, VX855_137_750M},
    {CLK_138_400M, K800_PLL_138_400M, CX700_138_400M, VX855_138_400M},
    {CLK_144_300M, K800_PLL_144_300M, CX700_144_300M, VX855_144_300M},
    {CLK_146_760M, K800_PLL_146_760M, CX700_146_760M, VX855_146_760M},
    {CLK_148_500M, K800_PLL_148_500M, CX700_148_500M, VX855_148_500M},
    {CLK_153_920M, K800_PLL_153_920M, CX700_153_920M, VX855_153_920M},
    {CLK_156_000M, K800_PLL_156_000M, CX700_156_000M, VX855_156_000M},
    {CLK_156_867M, K800_PLL_156_867M, CX700_156_867M, VX855_156_867M},
    {CLK_157_500M, K800_PLL_157_500M, CX700_157_500M, VX855_157_500M},
    {CLK_162_000M, K800_PLL_162_000M, CX700_162_000M, VX855_162_000M},
    {CLK_172_798M, K800_PLL_172_798M, CX700_172_798M, VX855_172_798M},
    {CLK_187_000M, K800_PLL_187_000M, CX700_187_000M, VX855_187_000M},
    {CLK_193_295M, K800_PLL_193_295M, CX700_193_295M, VX855_193_295M},
    {CLK_202_500M, K800_PLL_202_500M, CX700_202_500M, VX855_202_500M},
    {CLK_204_000M, K800_PLL_204_000M, CX700_204_000M, VX855_204_000M},
    {CLK_218_500M, K800_PLL_218_500M, CX700_218_500M, VX855_218_500M},
    {CLK_229_500M, K800_PLL_229_500M, CX700_229_500M, VX855_229_500M},
    {CLK_234_000M, K800_PLL_234_000M, CX700_234_000M, VX855_234_000M},
    {CLK_267_250M, K800_PLL_267_250M, CX700_267_250M, VX855_267_250M},
    {CLK_297_500M, K800_PLL_297_500M, CX700_297_500M, VX855_297_500M},
    {CLK_339_500M, K800_PLL_339_500M, CX700_339_500M, VX855_339_500M},
    {CLK_340_772M, K800_PLL_340_772M, CX700_340_772M, VX855_340_772M}
};

#define NUM_TOTAL_PLL_TABLE ARRAY_SIZE(pll_value)

static struct fifo_depth_select display_fifo_depth_reg= {
    /* IGA1 FIFO Depth_Select */
    {IGA1_FIFO_DEPTH_SELECT_REG_NUM, {{SR17,0,7}}},
    /* IGA2 FIFO Depth_Select */
    {IGA2_FIFO_DEPTH_SELECT_REG_NUM, {{CR68,4,7}, {CR94,7,7}, {CR95,7,7}}}
};

static struct fifo_threshold_select fifo_threshold_select_reg= {
    /* IGA1 FIFO Threshold Select */
    {IGA1_FIFO_THRESHOLD_REG_NUM, {{SR16,0,5},{SR16,7,7}}},
    /* IGA2 FIFO Threshold Select */
    {IGA2_FIFO_THRESHOLD_REG_NUM, {{CR68,0,3}, {CR95,4,6}}}
};

static struct fifo_high_threshold_select fifo_high_threshold_select_reg= {
    /* IGA1 FIFO High Threshold Select */
    {IGA1_FIFO_HIGH_THRESHOLD_REG_NUM, {{SR18,0,5},{SR18,7,7}}},
    /* IGA2 FIFO High Threshold Select */
    {IGA2_FIFO_HIGH_THRESHOLD_REG_NUM, {{CR92,0,3}, {CR95,0,2}}}
};

static struct display_queue_expire_num display_queue_expire_num_reg= {
    /* IGA1 Display Queue Expire Num */
    {IGA1_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM, {{SR22,0,4}}},
    /* IGA2 Display Queue Expire Num */
    {IGA2_DISPLAY_QUEUE_EXPIRE_NUM_REG_NUM, {{CR94,0,6}}}
};


static struct offset offset_reg = {
    /* IGA1 Offset Register */
    {IGA1_OFFSET_REG_NUM, {{CR13,0,7}, {CR35,5,7}}},
    /* IGA2 Offset Register */
    {IGA2_OFFSET_REG_NUM, {{CR66,0,7}, {CR67,0,1}, {CR71,7,7}}}
};

static struct fetch_count fetch_count_reg = {
    /* IGA1 Fetch Count Register */
    {IGA1_FETCH_COUNT_REG_NUM, {{SR1C,0,7}, {SR1D,0,1}}},
    /* IGA2 Fetch Count Register */
    {IGA2_FETCH_COUNT_REG_NUM, {{CR65,0,7}, {CR67,2,3}}}
};

static struct iga1_crtc_timing iga1_crtc_reg = {
    /* IGA1 Horizontal Total */
    {IGA1_HOR_TOTAL_REG_NUM, {{CR00,0,7}, {CR36,3,3}}},
    /* IGA1 Horizontal Addressable Video */
    {IGA1_HOR_ADDR_REG_NUM, {{CR01,0,7}}},
    /* IGA1 Horizontal Blank Start */
    {IGA1_HOR_BLANK_START_REG_NUM, {{CR02,0,7}}},
    /* IGA1 Horizontal Blank End */
    {IGA1_HOR_BLANK_END_REG_NUM, {{CR03,0,4}, {CR05,7,7}, {CR33,5,5}}},
    /* IGA1 Horizontal Sync Start */
    {IGA1_HOR_SYNC_START_REG_NUM, {{CR04,0,7}, {CR33,4,4}}},
    /* IGA1 Horizontal Sync End */
    {IGA1_HOR_SYNC_END_REG_NUM, {{CR05,0,4}}},
    /* IGA1 Vertical Total */
    {IGA1_VER_TOTAL_REG_NUM, {{CR06,0,7}, {CR07,0,0}, {CR07,5,5}, {CR35,0,0}}},
    /* IGA1 Vertical Addressable Video */
    {IGA1_VER_ADDR_REG_NUM, {{CR12,0,7}, {CR07,1,1}, {CR07,6,6}, {CR35,2,2}}},
    /* IGA1 Vertical Blank Start */
    {IGA1_VER_BLANK_START_REG_NUM, {{CR15,0,7}, {CR07,3,3}, {CR09,5,5}, {CR35,3,3}}},
    /* IGA1 Vertical Blank End */
    {IGA1_VER_BLANK_END_REG_NUM, {{CR16,0,7}}},
    /* IGA1 Vertical Sync Start */
    {IGA1_VER_SYNC_START_REG_NUM, {{CR10,0,7}, {CR07,2,2}, {CR07,7,7}, {CR35,1,1}}},
    /* IGA1 Vertical Sync End */
    {IGA1_VER_SYNC_END_REG_NUM, {{CR11,0,3}}}
};

static struct iga2_shadow_crtc_timing iga2_shadow_crtc_reg = {
    /* IGA2 Shadow Horizontal Total */
    {IGA2_SHADOW_HOR_TOTAL_REG_NUM, {{CR6D,0,7}, {CR71,3,3}}},
    /* IGA2 Shadow Horizontal Blank End */
    {IGA2_SHADOW_HOR_BLANK_END_REG_NUM, {{CR6E,0,7}}},
    /* IGA2 Shadow Vertical Total */
    {IGA2_SHADOW_VER_TOTAL_REG_NUM, {{CR6F,0,7}, {CR71,0,2}}},
    /* IGA2 Shadow Vertical Addressable Video */
    {IGA2_SHADOW_VER_ADDR_REG_NUM, {{CR70,0,7}, {CR71,4,6}}},
    /* IGA2 Shadow Vertical Blank Start */
    {IGA2_SHADOW_VER_BLANK_START_REG_NUM, {{CR72,0,7}, {CR74,4,6}}},
    /* IGA2 Shadow Vertical Blank End */
    {IGA2_SHADOW_VER_BLANK_END_REG_NUM, {{CR73,0,7}, {CR74,0,2}}},
    /* IGA2 Shadow Vertical Sync Start */
    {IGA2_SHADOW_VER_SYNC_START_REG_NUM, {{CR75,0,7}, {CR76,4,6}}},
    /* IGA2 Shadow Vertical Sync End */
    {IGA2_SHADOW_VER_SYNC_END_REG_NUM, {{CR76,0,3}}}
};

static struct iga2_crtc_timing iga2_crtc_reg = {
    /* IGA2 Horizontal Total */
    {IGA2_HOR_TOTAL_REG_NUM, {{CR50,0,7}, {CR55,0,3}}},
    /* IGA2 Horizontal Addressable Video */
    {IGA2_HOR_ADDR_REG_NUM, {{CR51,0,7}, {CR55,4,6}}},
    /* IGA2 Horizontal Blank Start */
    {IGA2_HOR_BLANK_START_REG_NUM, {{CR52,0,7}, {CR54,0,2}}},
    /* IGA2 Horizontal Blank End */
    {IGA2_HOR_BLANK_END_REG_NUM, {{CR53,0,7}, {CR54,3,5}, {CR5D,6,6}}},
    /* IGA2 Horizontal Sync Start */
    {IGA2_HOR_SYNC_START_REG_NUM, {{CR56,0,7}, {CR54,6,7}, {CR5C,7,7}, {CR5D,7,7}}},
    /* IGA2 Horizontal Sync End */
    {IGA2_HOR_SYNC_END_REG_NUM, {{CR57,0,7}, {CR5C,6,6}}},
    /* IGA2 Vertical Total */
    {IGA2_VER_TOTAL_REG_NUM, {{CR58,0,7}, {CR5D,0,2}}},
    /* IGA2 Vertical Addressable Video */
    {IGA2_VER_ADDR_REG_NUM, {{CR59,0,7}, {CR5D,3,5}}},
    /* IGA2 Vertical Blank Start */
    {IGA2_VER_BLANK_START_REG_NUM, {{CR5A,0,7}, {CR5C,0,2}}},
    /* IGA2 Vertical Blank End */
    {IGA2_VER_BLANK_END_REG_NUM, {{CR5B,0,7}, {CR5C,3,5}}},
    /* IGA2 Vertical Sync Start */
    {IGA2_VER_SYNC_START_REG_NUM, {{CR5E,0,7}, {CR5F,5,7}}},
    /* IGA2 Vertical Sync End */
    {IGA2_VER_SYNC_END_REG_NUM, {{CR5F,0,4}}}
};

typedef struct IODATA {
    CARD8   Index;
    CARD8   Mask;
    CARD8   Data;
}IODATA, *IODATAPTR;

void load_fix_bit_crtc_reg(void);

#include "viamode.h"

#endif /* __HW_H__ */
