/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __MACROS_H__
#define __MACROS_H__ 1

#undef        max
#undef        min
#define        max(a, b)        ((a) > (b) ? (a) : (b))
#define        min(a, b)        ((a) < (b) ? (a) : (b))

#undef range_limit
#define range_limit(val,min_val,max_val) (max((min_val),min((val),(max_val))))

/*
 * Alignment macro functions
 */
#undef ALIGN_TO
#define ALIGN_TO(f, alignment) (((f) + ((alignment)-1)) & ~((alignment)-1))

#undef EXCHANGE
#define EXCHANGE(a, b)  do { (a) = (a)^(b); (b) = (a)^(b); (a) = (a)^(b); } while(0)

#endif /* __MACROS_H__ */
