/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_HW_3D_SCALING_H_
#define _VIA_HW_3D_SCALING_H_ 1

#define PACKYX(y, x)   (((y) << 16) | ((x) & 0xffff))
#define PACK2W(y, x)   (((y) << 16) | (x))

void Reserve3DScalingMemory(ScrnInfoPtr pScrn);
void VIABlankRectangle( VIAPtr pVia, CARD32 RectAddr, CARD32 RectDimension, CARD32 RectPitch);
Bool BlackSclScrnBoundary(VIAPtr pVia, VIADISP3DSCALCTRLPtr p3DSCALCTRLInfo, RECTL rDest, int index);
void patchForVidColorKey(VIAPtr pVia,CARD32 pSrc,CARD32 pDest,CARD32 ColoyKey,CARD32 pitch,
                            RECTL* prclDst,RECTL* prclClip);
Bool DISP3DScalWindowAdjust(RECTLPtr prSrc, RECTLPtr prDest, VIA3DSclSCNParasPtr pDISP3DScalScreenInfo);
Bool VIASetLCD3DScalScreenParas(VIABIOSInfoPtr  pBIOSInfo);
Bool VIASet3DScalCtrlParas(ScrnInfoPtr pScrn, VIADISP3DSCALCTRLPtr p3DSCALCTRLInfo);
void vid3DScalColorKeyWindowAdjust(RECTL* lpSrcRectVideoWin, RECTL* lpDstRectVideoWin, HW3D_Scaling_INFO   *lpgfx3DScal_info);
void VIADISP3DScalingParasSetting(ScrnInfoPtr pScrn);
Bool doVIADISP3DScalingImageProcessing(VIAPtr pVia, VIADISP3DSCALCTRLPtr p3DSCALCTRLInfo, VIA3DSclSCNParasPtr pDISP3DScalScreenInfo);
Bool VIADISP3DScalingImageProcessing(VIAPtr pVia);


extern void VIASetCursorPosition(ScrnInfoPtr pScrn, int x, int y);
extern Bool via_module_loaded;
extern int gVIAEntityIndex;


#endif  /* _VIA_HW_3D_SCALING_H_ */


