/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef _VIA_BIOS_H_
#define _VIA_BIOS_H_ 1

/* ------- mergedfb support ------ */
	/* Psuedo Xinerama support */
#define NEED_REPLIES  		/* ? */
#define EXTENSION_PROC_ARGS void *
#include "extnsionst.h"  	/* required */
#include "panoramiXproto.h"  	/* required */
#define VIA_XINERAMA_MAJOR_VERSION  1
#define VIA_XINERAMA_MINOR_VERSION  1

#ifdef XF86DRI
#include "xf86drm.h"
#include "sarea.h"
#endif

#define IGA_NONE  0
#define IGA1	    1
#define IGA2	    2
#define IGA1_IGA2   3

#define SCREEN_INDEX_0  0
#define SCREEN_INDEX_1  1


/* Video Mode Index (FB device driver's res. index)*/
#define M480x640        0x000
#define M640x480        0x001
#define M720x480        0x002
#define M720x576        0x003
#define M800x480        0x004
#define M800x600        0x005
#define M848x480        0x006
#define M852x480        0x007
#define M960x600        0x008
#define M1000x600       0x009
#define M1024x512       0x00A
#define M1024x576       0x00B
#define M1024x600       0x00C
#define M1024x768       0x00D
#define M1024x768_I     0x20D   /* Interlace Mode */
#define M1088x612       0x00E
#define M1152x720       0x00F
#define M1152x864       0x010
#define M1152x864_I     0x210   /* Interlace Mode */
#define M1200x720       0x011
#define M1280x600       0x012
#define M1280x720       0x013
#define M1280x768       0x014
#define M1280x800       0x015
#define M1280x960       0x016
#define M1280x1024      0x017
#define M1280x1024_I    0x217   /* Interlace Mode */
#define M1360x768       0x018
#define M1360x768_RB    0x118   /* Reduce Banking */
#define M1366x768       0x019
#define M1368x768       0x01A
#define M1400x1050      0x01B
#define M1400x1050_RB   0x11B   /* Reduce Banking */
#define M1440x900       0x01C
#define M1440x900_RB    0x11C   /* Reduce Banking */
#define M1440x1050      0x01D
#define M1600x900       0x01E
#define M1600x900_RB    0x11E   /* Reduce Banking */
#define M1600x1024      0x01F
#define M1600x1200      0x020
#define M1600x1200_I    0x220   /* Interlace Mode */
#define M1680x600       0x021
#define M1680x1050      0x022
#define M1680x1050_RB   0x122   /* Reduce Banking */
#define M1792x1344      0x023
#define M1856x1392      0x024
#define M1920x1080      0x025
#define M1920x1080_RB   0x125   /* Reduce Banking */
#define M1920x1080_I    0x225   /* Interlace Mode */
#define M1920x1200      0x026
#define M1920x1200_RB   0x126   /* Reduce Banking */
#define M1920x1440      0x027
#define M2048x1536      0x028
#define M800x480_GEN    0x029   /* General timing, only for LCD*/
#define M720x400        0x030
#define M832x624        0x031
#define M_INVALID       0xFFF


#define     VIA_REF_60HZ                    0x0001
#define     VIA_REF_56HZ                    0x0002
#define     VIA_REF_65HZ                    0x0004
#define     VIA_REF_70HZ                    0x0008
#define     VIA_REF_72HZ                    0x0010
#define     VIA_REF_75HZ                    0x0020
#define     VIA_REF_80HZ                    0x0040
#define     VIA_REF_85HZ                    0x0080
#define     VIA_REF_90HZ                    0x0100
#define     VIA_REF_100HZ                   0x0200
#define     VIA_REF_120HZ                   0x0400
#define     VIA_REF_86HZ                    0x0800       /* Interlaced */
#define     VIA_REF_94HZ                    0x1000       /* Interlaced */
#define     VIA_REF_50HZ                    0x2000
#define     VIA_REF_60HZ_I                  0x4000       /* Interlaced */
#define     VIA_REF_50HZ_I                  0x8000       /* Interlaced */

/*Generate a index according to width and height*/
#define     VIA_MAKE_ID(w,h)	    		(((h) << 16) | (w))

#define     VIA_480X640			        VIA_MAKE_ID(480,640)
#define     VIA_640X480                 VIA_MAKE_ID(640,480)
#define     VIA_800X600                 VIA_MAKE_ID(800,600)
#define     VIA_800X480_GEN			    VIA_MAKE_ID(800,480)
#define     VIA_800X480				    VIA_MAKE_ID(800,480)
#define     VIA_1024X600			    VIA_MAKE_ID(1024,600)
#define     VIA_1024X768                VIA_MAKE_ID(1024,768)
#define     VIA_848X480                 VIA_MAKE_ID(848,480)
#define     VIA_720X480                 VIA_MAKE_ID(720,480)
#define     VIA_720X576                 VIA_MAKE_ID(720,576)
#define     VIA_1280X720                VIA_MAKE_ID(1280,720)
#define     VIA_1280X768			    VIA_MAKE_ID(1280,768)
#define     VIA_1280X800				VIA_MAKE_ID(1280,800)
#define     VIA_1280X1024				VIA_MAKE_ID(1280,1024)
#define     VIA_1360X768				VIA_MAKE_ID(1360,768)
#define     VIA_1366X768				VIA_MAKE_ID(1366,768)
#define     VIA_1440X900				VIA_MAKE_ID(1440,900)
#define     VIA_1400X1050				VIA_MAKE_ID(1400,1050)
#define     VIA_1600X1200				VIA_MAKE_ID(1600,1200)
#define     VIA_1920X1080               VIA_MAKE_ID(1920,1080)
#define     VIA_INVALID                 0

/*Get LCD panel size from panel ID*/
#define     VIA_PANEL_WIDTH(ID)           	 	((ID) & 0xFFFF)
#define     VIA_PANEL_HEIGHT(ID)           		(((ID)>> 16) & 0xFFFF)

#define     VIA_NONETRANSMITTER             0x00
#define     VIA_VT1631                      0x01
#define     VIA_TTLTYPE                     0x07
#define     VIA_VT1632                      0x09
#define     VIA_VT1636                      0x0E    /* VT1636 LVDS. */
#define     VIA_Hardwired                   0x0F
#define     VIA_INTEGRATED_LVDS             0x41
#define     VIA_INTEGRATED_TMDS             0x42

#define     VIA_DEVICE_CRT1                 0x01
#define     VIA_DEVICE_LCD                  0x02
#define     VIA_DEVICE_DFP                  0x08
#define     VIA_DEVICE_LCD2                 0x20
#define     VIA_DEVICE_DFP2                 0x80
#define     VIA_DEVICE_ALL                  0x3FF



/* Digital Output Bus Width */
#define		VIA_DI_12BIT					0x00
#define		VIA_DI_24BIT					0x01

/* For 205 or later, there are many case for digital out put.
 * for example:DFP High-half, DFP Low-half
 *              or DVP1 (mobile version).
 * We must distinguish which digital port has been using by device.
 */
/* Digital Output Bus Port */
#define     VIA_DI_NONE                     0x000
#define     VIA_DI_DVP0                     0x001
#define     VIA_DI_DVP1                     0x002
#define     VIA_DI_DFPHIGH                  0x004
#define     VIA_DI_DFPLOW                   0x008
#define     VIA_DI_DFPHIGHLOW               0x010
#define     VIA_DI_LVDS0                    0x020
#define     VIA_DI_LVDS1                    0x040
#define     VIA_DI_LVDS0LVDS1               0x080
#define     VIA_DI_TMDS                     0x100
#define     VIA_DI_LVDS0DVP1                0x200
#define     VIA_DI_LVDS1DVP1                0x400
#define     VIA_DI_TTL                      0x800
#define     VIA_DI_LVDS0LVDS1DVP1           0x1000

/* For HW strapping issue. */
#define     SLOT_AMR       1
#define     SLOT_AGP       2

#define     NOT_FOUND_DEV               0
#define     FOUND_INTERNAL_DEV          1
#define     FOUND_EXTERNAL_DEV_BY_I2C   2
#define     FOUND_EXTERNAL_DEV_BY_GPIO  3


/* LVDS Transmitter I2C Slave Address */
#define     LVDS_I2C_ADDR_VT1636    0x80
#define     LVDS_I2C_ADDR_VT1631    0x70
#define     LVDS_I2C_ADDR_CHRONTEL  0xEA

/*for 3D scaling function used for multi-device*/
#define DISP_3D_SCALING_ENABLE          0x8000
#define DISP_3D_SCALING_BUFNUM_ONESET   3
#define DISP_3D_SCALING_BUFFER_SIZE     0x900000    /* bytes */ /* We reserve 9MB for each scaling buffernow. */

/* The position of some BIOS information from start of BIOS */
#define     VIA_BIOS_SIZE_POS               0x2
#define     VIA_BIOS_OFFSET_POS             0x1B

/* For VT3353 */
#define REVISION_VX800_A    0
#define REVISION_VX800_B    1 
#define REVISION_VX800_B2   2 


/*for mergedfb*/
typedef enum {
   viaLeftOf,
   viaRightOf,
   viaAbove,
   viaBelow,
   viaClone
} VIAScrn2Rel;

/*for mergedfb*/
typedef struct {
    int               bitsPerPixel;
    int               depth;
    int               displayWidth;
    int               pixel_code;
    int               pixel_bytes;
    DisplayModePtr    mode;
} VIAFBLayout;

typedef struct _GPIOI2C_INFO
{
    CARD8       bGPIOPort;
    CARD8       bSlaveAddr;
    int         I2C_WAIT_TIME;
    int         STARTTIMEOUT;
    int         BYTETIMEOUT;
    int         HOLDTIME;
    int         BITTIMEOUT;
} GPIOI2C_INFO, *PGPIOI2C_INFO;


typedef struct _3DSCAL_SCREENPARAS
{
    /* DISPLAY 3D SCALING PARAMETERS*/
    long            XSIZEMax;   	    /* The Max size(physical size,unit:pixel) */
    long            YSIZEMax;

    /*/adjust size*/    
    long            XSIZEMaxRange;   	/* this is the range  parametsers for SIZE (unit:pixel)*/
    long            YSIZEMaxRange;

    long            XScaleStep;        /*  step of X, Y scaling step value(unit:pixel)*/
    long            YScaleStep;    
    
    long            XScaleLevel;      /* X Current Scale level [0~MAX-1](unit:Level)*/
    long            XScaleDefault;    /* X Default Scale level*/
    long            XScaleMaximum;    /* X  max Scale level*/

    long            YScaleLevel;  
    long            YScaleDefault; 
    long            YScaleMaximum;

    long            XSIZEOffset;       /* the scaling offset of the size*/
    long            YSIZEOffset;
    
    long            XSIZENow;         /* the scaling result of the size*/
    long            YSIZENow;    

    /*adjust position*/
    long            XPOSITIONMaxRange;   	/* this is the range  parametsers for position (unit:pixel)*/
    long            YPOSITIONMaxRange;

    long            XPOSITIONStep;       	/*  Position adjust step value(unit:pixel)*/
    long            YPOSITIONStep;    
   
    long            XPOSITIONLevel;      /* X current position level [0~MAX-1](unit:level)*/
    long            XPOSITIONDefault;    /* X position level default value*/
    long            XPOSITIONMaximum;    /* X position max level*/

    long            YPOSITIONLevel;  
    long            YPOSITIONDefault; 
    long            YPOSITIONMaximum;

    long            XPOSITIONOffset;       /* the scaling offset of the POSITION*/
    long            YPOSITIONOffset;

    long            XPOSITIONNow;
    long            YPOSITIONNow;    

    /*flag to black the borders when adjust size and position*/
    Bool              bNeedBlack3dScalingBorders;    
    CARD32            AspectStatus;     /* Aspect ratio lock*/    
} VIA3DSclSCRNParas, *VIA3DSclSCNParasPtr;

typedef struct hwLock {
    volatile unsigned int lock;
    char                      padding[60];
} hwLock, *hwLockPtr;

typedef struct _VIADISP3DSCALCTRL 
{
    Bool    getShareArea;
    drm_context_t     xcontext;
    int     drmFD;
    unsigned int hSArea;
    unsigned int pSArea;    
    drmLock	*plock;
    int     VirtualHActive;
    int     OrigHActive;
    int     OrigVActive;
    int     RealHActive;
    int     RealVActive;
    int     BitsPerPixel;
    int     DISP3DScalIGAPath;
    int     OrigFBAddress;
    int     PanningX;
    int     PanningY;
    int     DISP3DScalingBufIndex; /*the buffer is on screen now*/
    CARD32  DISP3DScalingBufPitch;
    CARD32  DISP3DScalingBufAddr[DISP_3D_SCALING_BUFNUM_ONESET];
    int     CursorX;
    int     CursorY;
}VIADISP3DSCALCTRL, *VIADISP3DSCALCTRLPtr;


typedef struct _CRTSETTINGINFO {
    int     ModeIndex;
    int     HActive;
    int     VActive;
    int     IGAPath;
    int     MonitorSizeH;
    int     MonitorSizeV;
    int     PreferModeH;
    int     PreferModeV;    
    Bool    IsPanning;
    Bool    IsFlatMonitor;
    int     MaxPixelClock;
} CRTSETTINGINFO, *CRTSETTINGINFOPTR;


typedef struct _TMDSSETTINGINFO {
    unsigned char   ChipID;
    int             I2CPort;
    unsigned char   I2CAddress;    
    int             DFPSize;        /* DVI panel size */
    int     ModeIndex;
    int     HActive;
    int     VActive;
    int     IGAPath;
    CARD32     PanelSizeH;
    CARD32     PanelSizeV;
    Bool    IsPanning;
    Bool    IsDownScaling;
    int     MaxPixelClock;
    VIA3DSclSCRNParas DVI3DScalInfo;
    Bool    IsPreSetting;
    Bool   HasUserSetting;
    long    XScalingLevel;
    long    YScalingLevel;
    long    XScalPosLevel;
    long    YScalPosLevel;    
} TMDSSETTINGINFO, *TMDSSETTINGINFOPTR;


typedef struct _LVDSSETTINGINFO {
    unsigned char   ChipID;
    int             I2CPort;
    unsigned char   I2CAddress;    
    unsigned char   BusWidth;   /* Digital Output Bus Width */
    Bool    IsDualEdge;     /* mean add-on card is 2CH or Dual or DDR */
    Bool    IsDithering;    /* Dithering Enable is for 18 bits panel and Disable is for 24 bits panel.*/
    int     DIPort;
    int     IGAPath;
    CARD32  VClk;           /* Clock of the mode table. */
    int     PanelSizeID;    /* LCD panel size ID */
    int     PanelSizeX;
    int     PanelSizeY;
    int     ModeIndex;
    int     HActive;
    int     VActive;
    Bool    Center;
    Bool    IsPanning;
    Bool    IsDownScaling;
    VIA3DSclSCRNParas LCD3DScalInfo;
    Bool    IsPreSetting;
    Bool    HasUserSetting;
    long    XScalingLevel;
    long    YScalingLevel;
    long    XScalPosLevel;
    long    YScalPosLevel;    
    Bool    MsbEnable;           /* data ouput format is MSB or not */
} LVDSSETTINGINFO, *LVDSSETTINGINFOPTR;



typedef struct _IGASETTINGINFO {
    Bool    IsPanning;
	Bool    IsDownScaling;
    Bool    IsDISP3DScaling;
    int     HActive;
    int     VActive;
    int     CrtcWidth;/*record the value we down timing(HActive),is used for video parameter transfer*/            
    int     CrtcHeight;/*record the value we down timing(VActive),is used for video parameter transfer*/ 
    int     CountWidthByQWord;
    int     OffsetWidthByQWord;
    Bool    SetStartingAddrFirstTime;   /* If not panning, we can use this flag to force to reset */
                                        /* starting address when set mode. */
    Bool    IsActive;                   /* Use to indicate if this IGA is in use. */
    VIADISP3DSCALCTRL DISP3DSCALCTRLInfo;
    CARD16  deviceActived;
} IGASETTINGINFO, *IGASETTINGINFOPTR;


/***********************************************************************************/
/*                  Transmitter DPA Setting Structure                              */
/***********************************************************************************/
#include "via_tblDPASetting.h"

/* For adjusting DPA by option. (User Specified)*/
typedef struct VT1636_DPA_SETTING {
    int     PanelSizeID;
    CARD8   CLK_SEL_ST1;
    CARD8   CLK_SEL_ST2;
} VT1636DPASETTING, *VT1636DPASETTINGPTR;


typedef struct USER_DPA_SETTING_INFO {
    Bool                    HasUserSetting_Gfx;
    Bool                    HasUserSetting_VT1636;
    GFX_DPA_VALUE   GfxDPA;
    VT1636DPASETTING        VT1636DPA;
} USERDPASETTINGINFO, *USERDPASETTINGINFOPTR;

/***********************************************************************************/
/*                  VIA BIOS INFO Structure                                        */
/***********************************************************************************/
typedef struct _VIABIOSINFO {

    int                 Chipset;
    int                 ChipRev;            
    unsigned char*      MapBase;
    Bool                FirstInit;
    unsigned char*      FBBase;
    unsigned long       videoRambytes;
    int                 scrnIndex;

    int                 countWidthByQWord;
    int                 offsetWidthByQWord;
    Bool                EnableExtendedFIFO;

    CARD16              ConnectedDevice;
    CARD16              ActiveDevice;
    
    /* 
       On the SAMM mode, pBIOSInfo->ActiveDevice only keep its own device state.
       So we can't know whose devices are actually active. So I add this variable to keep the actual active device state.
    */
    CARD32              ActualActiveDevice;

    /* Here are all the BIOS Relative Options */
    /* Simplify Device ID + Revision ID combination */
    int                 dwProjectIDRevision;
    Bool                IsBiosSupportLCD;                                         
    Bool                IsSpreadSpectrumEnabled;
    Bool                TwoLCD;         /*=* For Advantech Project, support two LCD MHS *=*/
    Bool                DuoView;        /*=* DuoView, only support for CN400 *=*/
    Bool                UseIGA2;
    Bool                Panning;        /* Virtual Desktop or Not ? */    
    Bool                EPIA_DVI;       /*for support DVI on EPIA*/   
    int                 IsDemoBoard;    /*for CN400 only ,DVI use DVP1/DVP1*/         
    int                 DFPDIPort;
    int                 CRTDIPort;
    int                 OptRefresh;
    int                 Refresh;
    int                 FoundRefresh;

    CRTSETTINGINFO      CRTSettingInfo;   
    TMDSSETTINGINFO     TMDSSettingInfo;
    LVDSSETTINGINFO     LVDSSettingInfo;    /* For LCD1. */
    
    /* For dual devices, like dual LCD Only for VT3324 now. */
    LVDSSETTINGINFO     LVDSSettingInfo2;   /* For LCD2. */
 
    /* IGA setting */
    IGASETTINGINFO      IGA1SettingInfo;
    IGASETTINGINFO      IGA2SettingInfo;

    USERDPASETTINGINFO  UserDPASettingInfo;
    
    /* LCD Simultaneous Expand Mode HWCursor Y Scale */
    Bool                scaleY;
    int                 resY;

    /* Some Used Member of ScrnInfoRec */
    int                 bitsPerPixel;   /* fb bpp */
    int                 displayWidth;   /* memory pitch */
    int                 frameX1;        /* viewport position */
    int                 frameY1;
    int                 SaveframeX1;
    int                 SaveframeY1;
    int                 VirtualX;
    int                 VirtualY;
    int                 ActualDesktopSizeX;
    int                 ActualDesktopSizeY;

    /* Some Used Member of DisplayModeRec */
    int                 Clock;          /* pixel clock freq */
    int                 HTotal;
    int                 VTotal;
    int                 HDisplay;       /* horizontal timing */
    int                 VDisplay;       /* vertical timing */
    int                 SaveHDisplay;
    int                 SaveVDisplay;
    int                 CrtcHDisplay;
    int                 CrtcVDisplay;
    int                 SaveCrtcHDisplay;
    int                 SaveCrtcVDisplay;
    int                 SaveVirtualX;
    int                 SaveVirtualY;

    
    /* I2C & DDC */
    GPIOI2C_INFO        GPIOI2CInfo;
    I2CBusPtr           I2C_Port1;
    I2CBusPtr           I2C_Port2;


    /* MHS */
    CARD16              PrimaryDevice;
    Bool                SAMM;           /* SAMM success or not? */
    Bool                IsSecondary;
    Bool                HasSecondary;

    /* Utility User Setting */
    LOCO                colors[256];    /* Gamma value. LOCO typedef in colormapst.h */
    CARD8               SuspendTurnOFFDevice;   /*=* for [Hitachi Escher] suspend garbage *=*/
    Bool                s3utility;     /*The function call is from s3utility*/    

    /*for mergedfb*/
    VIAFBLayout         CurrentLayout;
    Bool                MergedFB;
    VIAScrn2Rel         Scrn2Position;
    
    int                 maxScrn1_X1, maxScrn1_X2, maxScrn1_Y1, maxScrn1_Y2;
    int                 maxScrn2_X1, maxScrn2_X2, maxScrn2_Y1, maxScrn2_Y2;
    Bool                UseVIAXinerama;
    
    ExtensionEntry*     XineramaExtEntry;
    int                 VIAXineramaVX, VIAXineramaVY;
    
    /*to set secondary screen's start address*/
    int                 HalfLine;
    unsigned long       HalfScreen;
    
    int                 CursorStart;

    /* For utility api. */
    ExtensionEntry*     DisplayExtEntry;

    /* Display SW 3D scaling function enable flag */
    unsigned long       Is3DScalingEnable; 
    Bool                IsStableStatus;

	/* For MAMM, VIA is secondary display device. */
    Bool                IsMAMMEnable;

    /* Move NoDDCValue from VIAPtr struct to here. */
    Bool                NoDDCValue;

    /* For Down Scale Used */    
    Bool                IsDownScaleEnable;
    int                 HorDownScaleSize;
    int                 VerDownScaleSize;

    /* For interlace mode. */
    Bool                IsEnableInterlaceMode;

    Bool                IsExtend;

    /* For auto detection and mode line */
    Bool                IsAutoDectectEnable;
    int                 ModeLineStatus;
    int                 EDIDType;
    Bool                isPanelModeLine;
    struct crt_mode_table UserSpecifiedMode;
} VIABIOSInfoRec, *VIABIOSInfoPtr;

typedef struct _VIASUPPORTMODE {
    char  Name[10];
    int   ModeIndex;
    int   HActive;
    int   VActive;
} VIASUPPORTMODE;


/* Functions protype */

unsigned char VIAGetActiveDisplay(VIABIOSInfoPtr pBIOSInfo);
/*Bool VIAPostDVI(VIABIOSInfoPtr pBIOSInfo);*/
CARD32 VIAGetDeviceDetect(VIABIOSInfoPtr pBIOSInfo);
Bool VIAFindRefreshRate(VIABIOSInfoPtr pBIOSInfo, int ModeIndex);
Bool VIAFindModeUseBIOSTable(ScrnInfoPtr pScrn);
Bool VIASetModeUseBIOSTable(VIABIOSInfoPtr pBIOSInfo);
Bool VIASetModeForMHS(VIABIOSInfoPtr pBIOSInfo);
Bool VIASaveGamma(ScrnInfoPtr pScrn, LOCO *colors);
Bool VIARestoreGamma(ScrnInfoPtr pScrn, LOCO *colors);
void VIADelayIn_usec(VIABIOSInfoPtr pBIOSInfo, int usec);
Bool VIASetMode(VIABIOSInfoPtr pBIOSInfo);
void VIACRTDisable(void);
void VIACRTEnable(void);
void VIASetOutputPath(VIABIOSInfoPtr pBIOSInfo, int device, int set_iga, int output_interface);
void VIASetCRTOutputPath(VIABIOSInfoPtr pBIOSInfo, int set_iga, int output_interface);
void VIACRTSetMode(VIABIOSInfoPtr pBIOSInfo, int vmode_index, int set_iga);
Bool VIASenseCRT(ScrnInfoPtr pScrn);
int VIAGetModeIndex(int HorResolution, int VerResolution);

int BIOS_GetBIOSVersion(ScrnInfoPtr pScrn);
unsigned char BIOS_GetActiveDevice(ScrnInfoPtr pScrn);
Bool BIOS_GetBIOSDate(ScrnInfoPtr pScrn);
Bool VIACorrectMonitorSize(int* MonitorH, int* MonitorV); 
void VIAGetModeSizeByName(char *pName, int *pHSize, int *pVSize);
void VIAGetModeSizeByIndex(int ModeIndex, CARD32 *pHSize, CARD32 *pVSize);
CARD32 VIAGetPixelClockByMode(CARD32 ModeIndex);
void VIAReduceBlanking(VIABIOSInfoPtr pBIOSInfo, CARD32 ModeIndex, CARD32 DeviceType);

/* in via_bandwidth.c */
void VIAEnabledPrimaryExtendedFIFO(VIABIOSInfoPtr pBIOSInfo);
void VIASetDPA_Gfx(int DIPort, GFX_DPA_VALUE_PTR pGfxDPASetting);
void ViaModesAttachHelper(ScrnInfoPtr pScrn, MonPtr monitorp, DisplayModePtr Modes);

/* Down Scaling Functions */
void VIASetDownScaleOffsetReg(ScrnInfoPtr pScrn);
void VIASetDownScaleFactor(ScrnInfoPtr pScrn, int DownScaleHSize, int DownScaleVSize);
void VIASetDownScalingEngineReg(ScrnInfoPtr pScrn, int IGAPath);
void VIADisableDownScaling(ScrnInfoPtr pScrn);

CARD32  VIAGetRevisionOfVX800();
Bool BIOS_QueryChipInfo(ScrnInfoPtr pScrn);

int VIAGetFBSize(ScrnInfoPtr pScrn); /* query NB to get frame buffer size */

#endif  /* _VIA_BIOS_H_ */

